/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.resolution.entity;

import com.ibm.smarts.conversation.nlu.schema.entity.ColumnModifierEntity;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.intent.Aggregator;
import com.ibm.smarts.conversation.nlu.schema.intent.Limit;
import com.ibm.smarts.conversation.nlu.schema.intent.Order;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityType;
import java.util.Objects;

public class ResolverEntity {
    private final EntityType type;
    private final Entity entity;

    public ResolverEntity(Entity entity) {
        this.entity = entity;
        this.type = this.getType(entity);
    }

    public EntityType getType() {
        return this.type;
    }

    public String getText() {
        return this.entity.getText();
    }

    public long getStart() {
        return this.entity.getStart();
    }

    public long getEnd() {
        return this.entity.getEnd();
    }

    public Limit getLimit() {
        if (this.type.equals((Object)EntityType.MODIFIER) && this.entity instanceof ColumnModifierEntity) {
            return ((ColumnModifierEntity)this.entity).getLimit();
        }
        return null;
    }

    public Order getOrder() {
        if (this.type.equals((Object)EntityType.MODIFIER) && this.entity instanceof ColumnModifierEntity) {
            return ((ColumnModifierEntity)this.entity).getOrder();
        }
        return null;
    }

    public Aggregator getAggregator() {
        if (this.type.equals((Object)EntityType.MODIFIER) && this.entity instanceof ColumnModifierEntity) {
            return ((ColumnModifierEntity)this.entity).getAggregator();
        }
        return null;
    }

    public Entity getEntity() {
        return this.entity;
    }

    private EntityType getType(Entity entity) {
        EntityType entityType;
        switch (entity.getId()) {
            case "column": {
                entityType = EntityType.COLUMN;
                break;
            }
            case "columnModifier": {
                entityType = EntityType.MODIFIER;
                break;
            }
            case "filter": {
                entityType = EntityType.FILTER;
                break;
            }
            case "percent": {
                entityType = EntityType.PERCENT;
                break;
            }
            case "operator": {
                entityType = EntityType.OPERATOR;
                break;
            }
            case "time": {
                entityType = EntityType.TIME;
                break;
            }
            case "source": {
                entityType = EntityType.SOURCE;
                break;
            }
            case "number": {
                entityType = EntityType.NUMBER;
                break;
            }
            default: {
                entityType = EntityType.COLUMN;
            }
        }
        return entityType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolverEntity)) {
            return false;
        }
        ResolverEntity that = (ResolverEntity)o;
        return this.getType() == that.getType() && Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.entity});
    }

    public String toString() {
        return "ResolverEntity{type=" + (Object)((Object)this.type) + ", entity=" + this.entity + '}';
    }
}

