/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import java.io.FileNotFoundException;
import java.io.PrintStream;

public class GenerateDeterminantFromMinor {
    PrintStream stream;
    int N;

    public GenerateDeterminantFromMinor(String fileName) throws FileNotFoundException {
        this.stream = new PrintStream(fileName);
    }

    public void createClass(int N) {
        this.printTop(N);
        this.printCalls(N);
        this.print2();
        this.print3();
        for (int i = 4; i <= N; ++i) {
            this.printFunction(i);
        }
        this.stream.print("}\n");
    }

    private void printTop(int N) {
        String foo = "/*\n * Copyright (c) 2009-2010, Peter Abeles. All Rights Reserved.\n *\n * This file is part of Efficient Java Matrix Library (EJML).\n *\n * EJML is free software: you can redistribute it and/or modify\n * it under the terms of the GNU Lesser General Public License as\n * published by the Free Software Foundation, either version 3\n * of the License, or (at your option) any later version.\n *\n * EJML is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n * GNU Lesser General Public License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public\n * License along with EJML.  If not, see <http://www.gnu.org/licenses/>.\n */\n\npackage org.ejml.alg.dense.misc;\n\nimport org.ejml.data.RowD1Matrix64F;\n\n\n/**\n * This code was auto generated by  {@link GenerateDeterminantFromMinor} and should not be modified\n * directly.  \n * \n * @author Peter Abeles\n */\npublic class UnrolledDeterminantFromMinor {\n    \n    public static final int MAX = " + N + ";\n";
        this.stream.print(foo);
    }

    private void print2() {
        this.stream.print("    public static double det2( RowD1Matrix64F mat )\n    {\n        return mat.get(0)*mat.get(3) - mat.get(1)*mat.get(2);\n    }\n\n");
    }

    private void print3() {
        this.stream.print("    public static double det3( RowD1Matrix64F mat )\n    {\n        double a11 = mat.get( 0 );\n        double a12 = mat.get( 1 );\n        double a13 = mat.get( 2 );\n        double a21 = mat.get( 3 );\n        double a22 = mat.get( 4 );\n        double a23 = mat.get( 5 );\n        double a31 = mat.get( 6 );\n        double a32 = mat.get( 7 );\n        double a33 = mat.get( 8 );\n\n        double a = a11*(a22*a33 - a23*a32);\n        double b = a12*(a21*a33 - a23*a31);\n        double c = a13*(a21*a32 - a31*a22);\n\n        return a-b+c;\n    }\n\n");
    }

    private void printCalls(int N) {
        this.stream.print("    \n    public static double det( RowD1Matrix64F mat ) {\n");
        this.stream.print("        if( mat.numRows == 2 ) {\n            return det2(mat);\n");
        for (int i = 3; i <= N; ++i) {
            this.stream.print("        } else if( mat.numRows == " + i + " ) {\n" + "            return det" + i + "(mat);            \n");
        }
        this.stream.print("        }\n        \n        throw new IllegalArgumentException(\"Not supported\");\n    }\n\n");
    }

    private void printFunction(int N) {
        int M;
        this.stream.print("    public static double det" + N + "( RowD1Matrix64F mat )\n" + "    {\n");
        this.N = M = N - 1;
        int[] matrix = new int[M * M];
        int index = 0;
        for (int i = 1; i <= M; ++i) {
            int origIndex = i * N + 1;
            int j = 1;
            while (j <= M) {
                matrix[index] = index;
                this.stream.print("        double  " + this.a(index) + " = mat.get( " + origIndex + " );\n");
                ++j;
                ++origIndex;
                ++index;
            }
        }
        this.stream.print("\n");
        this.stream.print("        double ret = 0;\n");
        this.stream.print("        ret += mat.get( 0 ) * (");
        this.minor(matrix, 0, M);
        this.stream.print(");\n");
        for (int minor = 2; minor <= N; ++minor) {
            for (int i = 1; i <= M; ++i) {
                index = minor - 2 + (i - 1) * M;
                int origIndex = minor - 2 + i * N;
                this.stream.print("        " + this.a(index) + " = mat.get( " + origIndex + " );\n");
            }
            if (minor % 2 == 0) {
                this.stream.print("        ret -= ");
            } else {
                this.stream.print("        ret += ");
            }
            this.stream.print("mat.get( " + (minor - 1) + " ) * (");
            this.minor(matrix, 0, M);
            this.stream.print(");\n");
        }
        this.stream.print("        return ret;\n");
        this.stream.print("    }\n");
        this.stream.print("\n");
    }

    private void minor(int[] m, int row, int N) {
        if (N == 2) {
            this.stream.print(this.a(m[0]) + "*" + this.a(m[3]) + " - " + this.a(m[1]) + "*" + this.a(m[2]));
        } else {
            int M = N - 1;
            int[] d = new int[M * M];
            for (int i = 0; i < N; ++i) {
                int index = 0;
                for (int j = 1; j < N; ++j) {
                    for (int k = 0; k < N; ++k) {
                        if (k == i) continue;
                        d[index++] = m[j * N + k];
                    }
                }
                int pow = i;
                if (pow % 2 == 0) {
                    this.stream.print(" + " + this.a(m[i]) + "*(");
                } else {
                    this.stream.print(" - " + this.a(m[i]) + "*(");
                }
                this.minor(d, row + 1, M);
                this.stream.print(")");
            }
        }
    }

    private String a(int index) {
        int i = index / this.N + 1;
        int j = index % this.N + 1;
        return "a" + i + "" + j;
    }

    public static void main(String[] args) throws FileNotFoundException {
        GenerateDeterminantFromMinor gen = new GenerateDeterminantFromMinor("UnrolledDeterminantFromMinor.java");
        gen.createClass(6);
    }
}

