/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerConstants;
import com.ibm.dltj.UniLexAnalyzerPretokenized;
import com.ibm.dltj.data.DecompositionRuleSetFactory;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.uima_annotator.AnalyzerContext;
import com.ibm.dltj.uima_annotator.implBase.Analyzer_ImplBase;
import com.ibm.dltj.uima_annotator.lex_analysis.AnnotationsCreator;
import com.ibm.dltj.uima_annotator.lex_analysis.ConfigurationMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.LanguageDictionaries;
import com.ibm.dltj.uima_annotator.lex_analysis.LexicalAnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.ResultHandler;
import com.ibm.dltj.uima_annotator.lex_analysis.ResultHandlerPretokenized;
import com.ibm.dltj.uima_annotator.lex_analysis.ResultSpecMgr;
import com.ibm.dltj.uima_annotator.util.Language;
import com.ibm.icu.util.ULocale;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import com.ibm.langware.annotator.jFrostAEProcessException;
import com.ibm.langware.annotator.jFrostResourceInitException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class LexicalAnalyzer
extends Analyzer_ImplBase {
    private static final String CLASS_NAME = LexicalAnalyzer.class.getName();
    private final LexicalAnalyzerContext mLAContext = (LexicalAnalyzerContext)this.getContext();
    private final ConfigurationMgr mConfigMgr = (ConfigurationMgr)this.mLAContext.getConfigurationManager();
    private final ResultSpecMgr mRsltSpecMgr = (ResultSpecMgr)this.mLAContext.getResultSpecManager();
    protected final AnnotationsCreator mAnnoCreator = this.getNewAnnotationsCreatorInstance(this.mLAContext);
    protected UniLexAnalyzer mUniLexAnalyzer;
    private MWUParsingStream mResHandler;
    protected String mLastUsedLang = "";
    protected final StringCharacterIterator mDocumentTextItr = new StringCharacterIterator("");

    public LexicalAnalyzer(UimaContext uimaContext) throws ResourceInitializationException {
        super(uimaContext);
    }

    @Override
    public void init() throws ResourceInitializationException {
        try {
            if (this.mLAContext.isTraceEnabled()) {
                this.mLAContext.logDataPath(this.mConfigMgr.getjFrostDataSpec(), this.mLAContext.mLanguageDicts.mBreakRulesSpec, this.mLAContext.mLanguageDicts.mDecompositionRulesSpec);
                this.mLAContext.logAvailableDicts();
            }
            this.mAnnoCreator.initGlossComparator(this.mConfigMgr.mGlossComparatorClassname);
            if (this.mConfigMgr.mPreloadLanguageArray != null && this.mConfigMgr.mPreloadLanguageArray.length > 0) {
                this.mLAContext.logMsg(Level.CONFIG, CLASS_NAME, "init", Messages.MessageKeys.LexicalAnalyzer__Preloading_language_resources__CONFIG.name());
                this.mLAContext.preloadDictsForLanguages(this.mConfigMgr.mPreloadLanguageArray);
            }
        }
        catch (Exception exception) {
            this.mLAContext.logErrorMsg(Level.SEVERE, CLASS_NAME, "init", Messages.MessageKeys.LexicalAnalyzer__Error_during_Frost_initialization__SEVERE.name(), exception);
            throw new jFrostResourceInitException("com.ibm.langware.annotator.messages", Messages.MessageKeys.FROST_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], exception);
        }
    }

    @Override
    public void reset() throws ResourceInitializationException, ResourceConfigurationException {
        super.reset();
        this.mLastUsedLang = "";
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void process(CAS cAS) throws AnalysisEngineProcessException {
        boolean bl;
        String string = cAS.getDocumentText();
        String string2 = cAS.getDocumentLanguage();
        if (string == null || string.length() == 0 || string2.length() == 0) {
            return;
        }
        if (string2.equalsIgnoreCase("x-unspecified") && this.mConfigMgr.mDefaultLanguage != null && this.mConfigMgr.mDefaultLanguage.length() != 0) {
            string2 = this.mConfigMgr.mDefaultLanguage;
            cAS.setDocumentLanguage(string2);
            this.mLAContext.logMsg(Level.FINE, CLASS_NAME, "process", Messages.MessageKeys.LexicalAnalyzer__NoLanguage_UsingDefault__FINE.name(), string2);
        }
        boolean bl2 = bl = string2.compareToIgnoreCase(this.mLastUsedLang) != 0;
        if (bl) {
            if (UniLexAnalyzer.isSameLanguage((ULocale)UniLexAnalyzerConstants.KOREAN, (ULocale)new ULocale(string2)) && this.mConfigMgr.mKoLegacyAnalyzer) {
                string2 = string2 + '-' + UniLexAnalyzerConstants.KOREAN_LEGACY.getVariant();
            }
            this.mLAContext.mLanguageDicts.resetForLanguage(string2);
            this.mLastUsedLang = string2;
        }
        if (this.mLAContext.mLanguageDicts.getDictsOfType(LanguageDictionaries.DICT_TYPE_LOOKUP).length == 0) {
            switch (this.mConfigMgr.mProcessLanguagesWithNoDictionaries) {
                case TOKENIZE: {
                    this.mLAContext.logMsg(Level.WARNING, CLASS_NAME, "resetForLanguage", Messages.MessageKeys.LexicalAnalyzer__NO_DICTS_AVAIL_FOR_LANG_TOKENIZE_ONLY__WARNING.name(), this.mLAContext.mLanguageDicts.getLanguage().getLanguageFullName());
                    break;
                }
                case SKIP: {
                    this.mLAContext.logMsg(Level.WARNING, CLASS_NAME, "resetForLanguage", Messages.MessageKeys.LexicalAnalyzer__NO_DICTS_AVAIL_FOR_LANG_RETURN__WARNING.name(), this.mLAContext.mLanguageDicts.getLanguage().getLanguageFullName());
                    return;
                }
                case ERROR: {
                    throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.LexicalAnalyzer__NO_DICTS_AVAIL_FOR_LANG__SEVERE.name(), new Object[]{this.mLAContext.mLanguageDicts.getLanguage().getLanguageWithNoTerritory()});
                }
            }
        }
        if (bl || this.mRsltSpecMgr.isResultSpecChanged()) {
            this.mRsltSpecMgr.readResultSpec(this.mLAContext.mLanguageDicts.getLanguage());
            this.adjustConfiguration(this.mLAContext.mLanguageDicts.getLanguage().getLanguageType());
            this.mResHandler = this.getNewResultHandlerInstance(this.mLAContext, this.mAnnoCreator, this.mDocumentTextItr);
            if (this.mRsltSpecMgr.mIsTokenReq) {
                try {
                    this.mUniLexAnalyzer = UniLexAnalyzer.getUniLexAnalyzer((ULocale)new ULocale(this.mLAContext.mLanguageDicts.getLanguage().getLanguageFullName()));
                }
                catch (DLTException dLTException) {
                    throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.FROST_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], dLTException);
                }
            } else {
                this.mUniLexAnalyzer = new UniLexAnalyzerPretokenized(this.mLAContext.mLanguageDicts.getLanguage().getLanguageFullName());
                this.mResHandler = new ResultHandlerPretokenized(this.mResHandler, this.mAnnoCreator);
            }
        }
        try {
            this.mDocumentTextItr.setText(string);
            this.mAnnoCreator.init(cAS);
            this.processText(this.mDocumentTextItr, (ParsingStream)this.mResHandler);
        }
        finally {
            this.mDocumentTextItr.setText("");
            this.mAnnoCreator.reset();
        }
    }

    protected synchronized void processText(CharacterIterator characterIterator, ParsingStream parsingStream) throws AnalysisEngineProcessException {
        try {
            this.mUniLexAnalyzer = this.openSession(this.mUniLexAnalyzer);
            if (!this.mRsltSpecMgr.mIsMWURequired || this.mConfigMgr.mAnnotateMWConstituentTokens) {
                this.mUniLexAnalyzer.processTextMW(characterIterator, parsingStream, this.mConfigMgr.mMWBoundary.getSpanFlag(), 4);
            } else {
                this.mUniLexAnalyzer.processTextMW(characterIterator, parsingStream, this.mConfigMgr.mMWBoundary.getSpanFlag(), 2);
            }
        }
        catch (DLTException dLTException) {
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.FROST_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], dLTException);
        }
        finally {
            this.closeSession(this.mUniLexAnalyzer);
        }
    }

    protected void adjustConfiguration(Language.LanguageType languageType) {
        this.mConfigMgr.mLemmatizationEnabled = this.mRsltSpecMgr.mIsLemmaAtTokenReq || this.mRsltSpecMgr.mIsLemmaEntriesAtTokenReq;
        this.mConfigMgr.mCreateDecompStructure = this.mRsltSpecMgr.mIsDecompositionFeatReq && this.mConfigMgr.mCreateDecompStructure_ConfigVal;
        switch (languageType) {
            case JA: {
                this.mConfigMgr.mDecompositionEnabled = this.mConfigMgr.mJaDecomposition;
                this.mConfigMgr.mDoLookupVariant = this.mConfigMgr.mDoLookupVariant_ConfigVal;
                this.mConfigMgr.mDoRuleBasedNormalization4All = this.mConfigMgr.mDoRuleBasedNormalization4All_ConfigVal;
                this.mConfigMgr.mDoRuleBasedNormalization4Katakana = this.mConfigMgr.mDoRuleBasedNormalization4Katakana_ConfigVal;
                break;
            }
            case KO: {
                this.mConfigMgr.mDecompositionEnabled = false;
                this.mConfigMgr.mJaDeepWordBreak = false;
                this.mConfigMgr.mDoLookupVariant = false;
                this.mConfigMgr.mDoRuleBasedNormalization4All = false;
                this.mConfigMgr.mDoRuleBasedNormalization4Katakana = false;
                break;
            }
            default: {
                this.mConfigMgr.mDecompositionEnabled = this.mRsltSpecMgr.mIsCompPartReq || this.mRsltSpecMgr.mIsDecompAnalysisReq;
                this.mConfigMgr.mDoLookupVariant = false;
                this.mConfigMgr.mDoRuleBasedNormalization4All = false;
                this.mConfigMgr.mDoRuleBasedNormalization4Katakana = false;
            }
        }
        this.mConfigMgr.mReturnOnlyFirstLevelOfCompoundBreakdown = languageType != Language.LanguageType.EU ? false : this.mConfigMgr.mReturnOnlyFirstLevelOfCompoundBreakdown_ConfigVal;
    }

    protected UniLexAnalyzer openSession(UniLexAnalyzer uniLexAnalyzer) throws AnalysisEngineProcessException {
        if (uniLexAnalyzer == null) {
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.LEX_SESSION_NOT_INITIALIZED__SEVERE.name(), new Object[0]);
        }
        try {
            if (this.mLAContext.mLanguageDicts.mBreakRulesSpec != null && this.mLAContext.mLanguageDicts.mBreakRulesSpec.length() != 0) {
                uniLexAnalyzer.setBreakIteratorByFilename(this.mLAContext.mLanguageDicts.mBreakRulesSpec);
            }
            if (this.mLAContext.mLanguageDicts.mDecompositionRulesSpec != null && this.mLAContext.mLanguageDicts.mDecompositionRulesSpec.length() != 0) {
                uniLexAnalyzer.setDecompositionRules(DecompositionRuleSetFactory.getDecompositionRulesByFilename((String)this.mLAContext.mLanguageDicts.mDecompositionRulesSpec));
            }
            uniLexAnalyzer.setDictionaries(this.mLAContext.mLanguageDicts.getDictsOfType(LanguageDictionaries.DICT_TYPE_LEXICAL), this.mLAContext.mLanguageDicts.getDictsOfType(LanguageDictionaries.DICT_TYPE_OOV), this.mLAContext.mLanguageDicts.getDictsOfType(LanguageDictionaries.DICT_TYPE_TCR), this.mLAContext.mLanguageDicts.getDictsOfType(LanguageDictionaries.DICT_TYPE_MW));
            uniLexAnalyzer.setCaseStrictMode(this.mConfigMgr.mUseStrictCaseMode);
            uniLexAnalyzer.open(this.mConfigMgr.mUseFirstMatchPolicy ? 1 : 0, LexicalAnalyzer.getOptions(this.mConfigMgr.mDecompositionEnabled, this.mConfigMgr.mReturnOnlyFirstLevelOfCompoundBreakdown_ConfigVal, this.mConfigMgr.mCrossDictionaryDecomposition, this.mConfigMgr.mBOFAOnlyDecomposition, this.mConfigMgr.mBreakOnHyphens, this.mConfigMgr.mFilterDecompositions, this.mConfigMgr.mStandaloneDecomposition), LexicalAnalyzer.getSpecificOptions(this.mConfigMgr.mJaDeepWordBreak, this.mConfigMgr.mAggressiveSentenceBreaks));
        }
        catch (DLTException dLTException) {
            this.closeSession(uniLexAnalyzer);
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.FROST_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], dLTException);
        }
        return uniLexAnalyzer;
    }

    protected void closeSession(UniLexAnalyzer uniLexAnalyzer) {
        if (uniLexAnalyzer != null) {
            try {
                uniLexAnalyzer.close();
            }
            catch (DLTException dLTException) {
                throw new Error(dLTException.getMessage());
            }
        }
    }

    protected static final int getOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        int n = 0;
        if (bl) {
            n |= 1;
            if (bl2) {
                n |= 8;
            }
            if (bl3) {
                n |= 0x20;
            }
            if (bl4) {
                n |= 0x200;
            }
            if (!bl6) {
                n |= 0x400;
            }
            if (bl7) {
                n |= 0x10;
            }
        }
        if (!bl5) {
            n |= 2;
        }
        return n |= 0x80;
    }

    protected static final int getSpecificOptions(boolean bl, boolean bl2) {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        return n;
    }

    protected AnnotationsCreator getNewAnnotationsCreatorInstance(LexicalAnalyzerContext lexicalAnalyzerContext) {
        return new AnnotationsCreator(lexicalAnalyzerContext);
    }

    protected ResultHandler getNewResultHandlerInstance(LexicalAnalyzerContext lexicalAnalyzerContext, AnnotationsCreator annotationsCreator, CharacterIterator characterIterator) {
        return new ResultHandler(lexicalAnalyzerContext, annotationsCreator, characterIterator);
    }

    @Override
    protected AnalyzerContext getNewAnalyzerContextInstance(UimaContext uimaContext) throws ResourceInitializationException {
        return new LexicalAnalyzerContext(uimaContext);
    }
}

