/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis.es;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.uima_annotator.AnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.LanguageDictionaries;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ConfigurationMgrOF;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class LanguageDictionariesOF
extends LanguageDictionaries {
    private static final int[] GLOSS_TYPES_STOPWORD = new int[]{128};
    private static final int[] GLOSS_TYPES_BOOSTTERM = new int[]{18, -19, -15, -17};
    public static final String DICT_TYPE_SPELL = "SpellMatchDicts";
    public static final String DICT_TYPE_STW = "StopwordDicts";
    public static final String DICT_TYPE_QSYN = "QuerySynDicts";
    public static final String DICT_TYPE_BOOST = "BoostTermDicts";
    private final ConfigurationMgrOF mConfigMgr;

    public LanguageDictionariesOF(AnalyzerContext analyzerContext) throws DLTException {
        super(analyzerContext);
        this.mConfigMgr = (ConfigurationMgrOF)analyzerContext.getConfigurationManager();
    }

    @Override
    protected void findByConfig(UimaContext uimaContext) {
        super.findByConfig(uimaContext);
        String[] stringArray = null;
        CapMatrix.Entry[] entryArray = null;
        if (this.mConfigMgr.mQueryProcessingMode) {
            stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.getLanguage(), DICT_TYPE_SPELL);
            entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionariesOF__spellMatch__CONFIG.name()), stringArray);
            this.mDictsTable.put(DICT_TYPE_SPELL, entryArray);
            stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.getLanguage(), DICT_TYPE_STW);
            entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionariesOF__stopword__CONFIG.name()), stringArray);
            this.mDictsTable.put(DICT_TYPE_STW, entryArray);
            stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.getLanguage(), DICT_TYPE_QSYN);
            entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionariesOF__querysyn__CONFIG.name()), stringArray);
            this.mDictsTable.put(DICT_TYPE_QSYN, entryArray);
            stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.getLanguage(), DICT_TYPE_BOOST);
            entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionariesOF__boost__CONFIG.name()), stringArray);
            this.mDictsTable.put(DICT_TYPE_BOOST, entryArray);
        }
    }

    @Override
    protected void findByGlossTypes() throws AnalysisEngineProcessException {
        super.findByGlossTypes();
        CapMatrix.Entry[] entryArray = null;
        if (this.mConfigMgr.mQueryProcessingMode) {
            entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionariesOF__stopword__CONFIG.name()), GLOSS_TYPES_STOPWORD);
            this.mDictsTable.put(DICT_TYPE_STW, entryArray);
            entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionariesOF__boost__CONFIG.name()), GLOSS_TYPES_BOOSTTERM);
            this.mDictsTable.put(DICT_TYPE_BOOST, entryArray);
        }
    }
}

