/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis.generic;

import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.uima_annotator.lex_analysis.generic.FSEntry;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.cas.impl.LowLevelTypeSystem;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
class TypeManager {
    private final LowLevelTypeSystem _lowTypeSys;
    private final Map<String, Integer> _typeCodeMap = new TreeMap<String, Integer>();
    private final Map<String, Integer> _featureCodeMap = new TreeMap<String, Integer>();
    private final int _fsArrayTypeCode;
    private final int _beginFeatureCode;
    private final int _endFeatureCode;
    private final int _sofaFeatureCode;

    TypeManager(LowLevelTypeSystem lowLevelTypeSystem) {
        this._lowTypeSys = lowLevelTypeSystem;
        this._fsArrayTypeCode = lowLevelTypeSystem.ll_getCodeForTypeName("uima.cas.FSArray");
        this._beginFeatureCode = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:begin");
        this._endFeatureCode = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:end");
        this._sofaFeatureCode = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:sofa");
    }

    int getFsArrayTypeCode() {
        return this._fsArrayTypeCode;
    }

    int getTypeCode(String string) throws AnnotateException {
        Integer n = this._typeCodeMap.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this._lowTypeSys.ll_getCodeForTypeName(string);
        if (n2 <= 0) {
            throw new AnnotateException(Messages.getFormattedMessage(Messages.MessageKeys.TypeManager__notypecode__SEVERE.name(), string));
        }
        this._typeCodeMap.put(string, n2);
        return n2;
    }

    int getFeatureCode(FSEntry fSEntry, String string) throws AnnotateException {
        String string2 = fSEntry.getTypeName() + ':' + string;
        Integer n = this._featureCodeMap.get(string2);
        if (n != null) {
            return n;
        }
        int n2 = this._lowTypeSys.ll_getCodeForFeatureName(string2);
        if (n2 <= 0) {
            throw new AnnotateException(Messages.getFormattedMessage(Messages.MessageKeys.TypeManager__nofeaturecode__SEVERE.name(), string2));
        }
        this._featureCodeMap.put(string2, n2);
        return n2;
    }

    int getFeatureCode(int n, String string) throws AnnotateException {
        String string2 = this._lowTypeSys.ll_getTypeForCode(n).getName();
        String string3 = string2 + ':' + string;
        Integer n2 = this._featureCodeMap.get(string3);
        if (n2 != null) {
            return n2;
        }
        int n3 = this._lowTypeSys.ll_getCodeForFeatureName(string3);
        if (n3 <= 0) {
            throw new AnnotateException(Messages.getFormattedMessage(Messages.MessageKeys.TypeManager__nofeaturecode__SEVERE.name(), string3));
        }
        this._featureCodeMap.put(string3, n3);
        return n3;
    }

    int getBeginFeatureCode() {
        return this._beginFeatureCode;
    }

    int getEndFeatureCode() {
        return this._endFeatureCode;
    }

    int getSofaFeatureCode() {
        return this._sofaFeatureCode;
    }
}

