/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.langware.annotator;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.TCRGloss;
import com.ibm.dltj.uima_annotator.util.ResultSpecificationUtil;
import com.ibm.dltj.uima_annotator.util.TypeSystemUtil;
import com.ibm.dltj.util.LowercasingCharacterIterator;
import com.ibm.langware.annotator.Copyright;
import java.io.File;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.resource.ResourceInitializationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class QueryTermAnnotator
extends CasAnnotator_ImplBase {
    private LowLevelCAS ll_cas;
    private LowLevelIndexRepository ll_indexRepository;
    private CapMatrix cm;
    private final ResultSpecificationUtil result = new ResultSpecificationUtil();
    private TypeSystemUtil codes;
    private final Map<String, ArrayList<CapMatrix.Entry>> dictEntryMap = new HashMap<String, ArrayList<CapMatrix.Entry>>();
    private final Set<AnnotationEntry> entrySet = new HashSet<AnnotationEntry>();
    private String[] sofaNames;
    private String[] targetTokenTypes;
    private int ll_tcode_boost_term;
    private int ll_tcode_stopword;
    private int ll_tcode_synonym;
    private int ll_acode_string;
    private int ll_fcode_begin;
    private int ll_fcode_end;
    private int ll_fcode_sofa;
    private int ll_fcode_boost_term_value;
    private int ll_fcode_synonyms;
    private int[] ll_tcodes_targets;
    private int ll_tcode_super_target;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this.sofaNames = (String[])uimaContext.getConfigParameterValue("SofaNames");
        if (null != this.sofaNames && 0 == this.sofaNames.length) {
            this.sofaNames = null;
        }
        this.targetTokenTypes = (String[])uimaContext.getConfigParameterValue("TargetTokenTypes");
        if (null == this.targetTokenTypes || 0 == this.targetTokenTypes.length) {
            throw new ResourceInitializationException("incorrect_number_of_parameters", new Object[]{"TargetTokenTypes"});
        }
        this.dictEntryMap.clear();
        String string = uimaContext.getDataPath();
        String string2 = (String)uimaContext.getConfigParameterValue("LWDataSubdir");
        if (null != string2 && 0 < string2.length()) {
            String[] stringArray = string.split(File.pathSeparator);
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stringArray) {
                stringBuilder.append(string3);
                if (new File(string3).isDirectory()) {
                    stringBuilder.append(File.separatorChar);
                    stringBuilder.append(string2);
                }
                stringBuilder.append(File.pathSeparatorChar);
            }
            string = stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        try {
            if (null == this.cm) {
                this.cm = new CapMatrix(string);
            } else {
                this.cm.setDataSpec(string);
            }
        }
        catch (DLTException dLTException) {
            throw new ResourceInitializationException("com.ibm.langware.annotator.messages", "FROST_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)dLTException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        super.destroy();
        if (null != this.cm) {
            try {
                this.cm.deactivateAll();
            }
            catch (DLTException dLTException) {
            }
            finally {
                this.cm = null;
            }
        }
        if (null != this.dictEntryMap) {
            this.dictEntryMap.clear();
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.codes = new TypeSystemUtil(typeSystem.getLowLevelTypeSystem());
        this.ll_tcode_boost_term = this.codes.getTypeCode("com.ibm.es.tt.BoostTermAnnotation", true);
        this.ll_tcode_stopword = this.codes.getTypeCode("uima.tt.StopwordAnnotation", true);
        this.ll_tcode_synonym = this.codes.getTypeCode("uima.tt.SynonymAnnotation", true);
        this.ll_fcode_begin = this.codes.getFeatureCode("uima.tcas.Annotation:begin", true);
        this.ll_fcode_end = this.codes.getFeatureCode("uima.tcas.Annotation:end", true);
        this.ll_fcode_sofa = this.codes.getFeatureCode("uima.tcas.Annotation:sofa", true);
        this.ll_fcode_boost_term_value = this.codes.getFeatureCode("com.ibm.es.tt.BoostTermAnnotation:value", true);
        this.ll_fcode_synonyms = this.codes.getFeatureCode("uima.tt.SynonymAnnotation:synonyms", true);
        this.ll_acode_string = this.codes.getTypeCode("uima.cas.StringArray", true);
        this.ll_tcodes_targets = new int[this.targetTokenTypes.length];
        for (int i = 0; i < this.targetTokenTypes.length; ++i) {
            this.ll_tcodes_targets[i] = this.codes.getTypeCode(this.targetTokenTypes[i], true);
        }
        this.ll_tcode_super_target = this.codes.getSuperAnnotationTypeCode(this.ll_tcodes_targets);
        this.result.setTypeSystem(typeSystem);
    }

    public void setResultSpecification(ResultSpecification resultSpecification) {
        super.setResultSpecification(resultSpecification);
        this.result.setResultSpecification(resultSpecification);
    }

    public void process(CAS cAS) throws AnalysisEngineProcessException {
        if (null == this.sofaNames) {
            this.processCas(cAS);
        } else {
            for (String string : this.sofaNames) {
                Iterator iterator = cAS.getViewIterator(string);
                while (iterator.hasNext()) {
                    this.processCas((CAS)iterator.next());
                }
            }
        }
    }

    private void processCas(CAS cAS) throws AnalysisEngineProcessException {
        int n;
        UimaContext uimaContext = this.getContext();
        String string = cAS.getDocumentLanguage();
        String string2 = cAS.getDocumentText();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        this.ll_cas = cAS.getLowLevelCAS();
        this.ll_indexRepository = this.ll_cas.ll_getIndexRepository();
        SofaFS sofaFS = cAS.getSofa();
        int n2 = n = sofaFS != null ? this.ll_cas.ll_getFSRef((FeatureStructure)sofaFS) : 0;
        if (this.result.isRequiredType(string, "com.ibm.es.tt.BoostTermAnnotation")) {
            this.process(uimaContext, string, stringCharacterIterator, DICTTYPE.BoostTermDicts);
        }
        if (this.result.isRequiredType(string, "uima.tt.StopwordAnnotation")) {
            this.process(uimaContext, string, stringCharacterIterator, DICTTYPE.StopwordDicts);
        }
        if (this.result.isRequiredType(string, "uima.tt.SynonymAnnotation")) {
            this.process(uimaContext, string, stringCharacterIterator, DICTTYPE.QuerySynDicts);
        }
        this.createQueryAnnotation(n);
        this.entrySet.clear();
    }

    private void process(UimaContext uimaContext, String string, CharacterIterator characterIterator, DICTTYPE dICTTYPE) throws AnalysisEngineProcessException {
        assert (null != uimaContext);
        assert (null != string);
        assert (null != characterIterator);
        assert (null != dICTTYPE);
        ArrayList<Dictionary> arrayList = new ArrayList<Dictionary>();
        arrayList.addAll(this.getDictionaries(uimaContext, string, dICTTYPE));
        arrayList.addAll(this.getDictionaries(uimaContext, "default", dICTTYPE));
        if (arrayList.isEmpty()) {
            return;
        }
        this.processPreTokenizedToken(characterIterator, arrayList, dICTTYPE);
    }

    private ArrayList<Dictionary> getDictionaries(UimaContext uimaContext, String string, DICTTYPE dICTTYPE) throws AnalysisEngineProcessException {
        assert (null != uimaContext);
        assert (null != string);
        assert (null != dICTTYPE);
        try {
            String string2 = string + "-" + dICTTYPE.toString();
            ArrayList<CapMatrix.Entry> arrayList = this.dictEntryMap.get(string2);
            if (null == arrayList) {
                arrayList = this.getDictionaryEntries(uimaContext, string, dICTTYPE);
                this.dictEntryMap.put(string2, arrayList);
            }
            ArrayList<Dictionary> arrayList2 = new ArrayList<Dictionary>();
            for (CapMatrix.Entry entry : arrayList) {
                Dictionary dictionary = entry.activate();
                arrayList2.add(dictionary);
            }
            return arrayList2;
        }
        catch (DLTException dLTException) {
            throw new AnalysisEngineProcessException("com.ibm.langware.annotator.messages", "LanguageDictionaries.could_not_activate_required_dictionaries__SEVERE", new Object[0], (Throwable)dLTException);
        }
    }

    private ArrayList<CapMatrix.Entry> getDictionaryEntries(UimaContext uimaContext, String string, DICTTYPE dICTTYPE) throws DLTException {
        assert (null != uimaContext);
        assert (null != string);
        assert (null != dICTTYPE);
        ArrayList<CapMatrix.Entry> arrayList = new ArrayList<CapMatrix.Entry>();
        String[] stringArray = (String[])uimaContext.getConfigParameterValue(string, dICTTYPE.toString());
        if (null != stringArray) {
            for (String string2 : stringArray) {
                File file = new File(string2);
                CapMatrix.Entry entry = file.isFile() && file.exists() ? this.cm.getEntryByFile(file) : this.cm.getEntryByFilename(string2);
                if (null == entry) continue;
                arrayList.add(entry);
            }
        }
        return arrayList;
    }

    private void processPreTokenizedToken(CharacterIterator characterIterator, ArrayList<Dictionary> arrayList, DICTTYPE dICTTYPE) throws AnalysisEngineProcessException {
        assert (0 < this.ll_tcode_super_target);
        MatchBuffer matchBuffer = new MatchBuffer();
        LowLevelIndex lowLevelIndex = this.ll_indexRepository.ll_getIndex("AnnotationIndex", this.ll_tcode_super_target);
        LowLevelIterator lowLevelIterator = lowLevelIndex.ll_iterator();
        LowLevelIterator lowLevelIterator2 = lowLevelIndex.ll_iterator();
        LowercasingCharacterIterator lowercasingCharacterIterator = new LowercasingCharacterIterator(characterIterator);
        for (Dictionary dictionary : arrayList) {
            Object object = dictionary.getSummary().isLowerCase() ? lowercasingCharacterIterator : characterIterator;
            lowLevelIterator.moveToFirst();
            while (lowLevelIterator.isValid()) {
                int n = lowLevelIterator.ll_get();
                if (!this.isSubsumed(this.ll_cas.ll_getFSRefType(n))) {
                    lowLevelIterator.moveToNext();
                    continue;
                }
                object.setIndex(this.ll_cas.ll_getIntValue(n, this.ll_fcode_begin));
                matchBuffer.clear();
                dictionary.traverse((CharacterIterator)object, matchBuffer);
                int n2 = matchBuffer.mpos;
                lowLevelIterator2.moveToLast();
                while (n2 > 0) {
                    int n3;
                    int n4;
                    int n5 = matchBuffer.index[--n2];
                    do {
                        n3 = lowLevelIterator2.ll_get();
                        n4 = this.ll_cas.ll_getIntValue(n3, this.ll_fcode_end);
                        if (n3 == n && this.isSubsumed(this.ll_cas.ll_getFSRefType(n3))) break;
                        lowLevelIterator2.moveToPrevious();
                    } while (lowLevelIterator2.isValid() && n5 < n4);
                    if (n5 == n4) {
                        int n6 = this.ll_cas.ll_getIntValue(n, this.ll_fcode_begin);
                        int n7 = matchBuffer.index[n2];
                        GlossCollection glossCollection = matchBuffer.gloss[n2];
                        this.entrySet.add(new AnnotationEntry(n6, n7, dICTTYPE, glossCollection));
                        while (n != n3 && lowLevelIterator.isValid()) {
                            lowLevelIterator.moveToNext();
                            if (!lowLevelIterator.isValid()) continue;
                            n = lowLevelIterator.ll_get();
                        }
                        break;
                    }
                    if (lowLevelIterator2.isValid()) {
                        lowLevelIterator2.moveToNext();
                        if (lowLevelIterator2.isValid()) continue;
                        lowLevelIterator2.moveToLast();
                        continue;
                    }
                    lowLevelIterator2.moveToFirst();
                }
                lowLevelIterator.moveToNext();
            }
        }
    }

    private boolean isSubsumed(int n) {
        for (int n2 : this.ll_tcodes_targets) {
            if (!this.codes.subsumes(n2, n)) continue;
            return true;
        }
        return false;
    }

    private void createQueryAnnotation(int n) throws AnalysisEngineProcessException {
        assert (null != this.entrySet);
        block5: for (AnnotationEntry annotationEntry : this.entrySet) {
            switch (annotationEntry.type) {
                case BoostTermDicts: {
                    for (Gloss gloss : annotationEntry.gc) {
                        IntegerGloss integerGloss = (IntegerGloss)gloss;
                        this.createBoostTermAnnotation(annotationEntry.begin, annotationEntry.end, n, integerGloss.weight);
                    }
                    continue block5;
                }
                case StopwordDicts: {
                    this.createStopwordAnnotation(annotationEntry.begin, annotationEntry.end, n);
                    break;
                }
                case QuerySynDicts: {
                    this.createSynonymAnnotation(annotationEntry.begin, annotationEntry.end, n, annotationEntry.gc);
                }
            }
        }
    }

    private void createBoostTermAnnotation(int n, int n2, int n3, int n4) throws AnalysisEngineProcessException {
        assert (null != this.ll_cas);
        assert (null != this.ll_indexRepository);
        assert (0 < this.ll_tcode_boost_term);
        assert (0 < this.ll_fcode_begin);
        assert (0 < this.ll_fcode_end);
        assert (0 < this.ll_fcode_boost_term_value);
        assert (0 <= n);
        assert (n <= n2);
        int n5 = this.ll_cas.ll_createFS(this.ll_tcode_boost_term);
        this.ll_cas.ll_setIntValue(n5, this.ll_fcode_begin, n);
        this.ll_cas.ll_setIntValue(n5, this.ll_fcode_end, n2);
        this.ll_cas.ll_setIntValue(n5, this.ll_fcode_sofa, n3);
        this.ll_cas.ll_setIntValue(n5, this.ll_fcode_boost_term_value, n4);
        this.ll_indexRepository.ll_addFS(n5);
    }

    private void createStopwordAnnotation(int n, int n2, int n3) throws AnalysisEngineProcessException {
        assert (null != this.ll_cas);
        assert (null != this.ll_indexRepository);
        assert (0 < this.ll_tcode_stopword);
        assert (0 < this.ll_fcode_begin);
        assert (0 < this.ll_fcode_end);
        assert (0 <= n);
        assert (n <= n2);
        int n4 = this.ll_cas.ll_createFS(this.ll_tcode_stopword);
        this.ll_cas.ll_setIntValue(n4, this.ll_fcode_begin, n);
        this.ll_cas.ll_setIntValue(n4, this.ll_fcode_end, n2);
        this.ll_cas.ll_setIntValue(n4, this.ll_fcode_sofa, n3);
        this.ll_indexRepository.ll_addFS(n4);
    }

    private void createSynonymAnnotation(int n, int n2, int n3, GlossCollection glossCollection) throws AnalysisEngineProcessException {
        assert (null != this.ll_cas);
        assert (null != this.ll_indexRepository);
        assert (0 < this.ll_tcode_synonym);
        assert (0 < this.ll_fcode_begin);
        assert (0 < this.ll_fcode_end);
        assert (0 < this.ll_fcode_synonyms);
        assert (null != glossCollection);
        assert (0 <= n);
        assert (n <= n2);
        int n4 = this.ll_cas.ll_createFS(this.ll_tcode_synonym);
        this.ll_cas.ll_setIntValue(n4, this.ll_fcode_begin, n);
        this.ll_cas.ll_setIntValue(n4, this.ll_fcode_end, n2);
        this.ll_cas.ll_setIntValue(n4, this.ll_fcode_sofa, n3);
        ArrayList<Gloss> arrayList = new ArrayList<Gloss>(glossCollection.size());
        for (Gloss gloss : glossCollection) {
            if (arrayList.contains(gloss)) continue;
            arrayList.add(gloss);
        }
        int n5 = this.ll_cas.ll_createArray(this.ll_acode_string, arrayList.size());
        int n6 = 0;
        for (Object e : arrayList) {
            TCRGloss tCRGloss = (TCRGloss)e;
            this.ll_cas.ll_setStringArrayValue(n5, n6++, String.valueOf(tCRGloss.charValue));
        }
        this.ll_cas.ll_setRefValue(n4, this.ll_fcode_synonyms, n5);
        this.ll_indexRepository.ll_addFS(n4);
    }

    final class AnnotationEntry {
        final int begin;
        final int end;
        final DICTTYPE type;
        final GlossCollection gc;

        AnnotationEntry(int n, int n2, DICTTYPE dICTTYPE, GlossCollection glossCollection) {
            this.begin = n;
            this.end = n2;
            this.type = dICTTYPE;
            this.gc = glossCollection;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.begin;
            n = 31 * n + this.end;
            n = 31 * n + (this.gc == null ? 0 : this.gc.hashCode());
            n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            AnnotationEntry annotationEntry = (AnnotationEntry)object;
            if (this.begin != annotationEntry.begin) {
                return false;
            }
            if (this.end != annotationEntry.end) {
                return false;
            }
            if (this.gc == null ? annotationEntry.gc != null : !this.gc.equals((Object)annotationEntry.gc)) {
                return false;
            }
            return this.type == annotationEntry.type;
        }
    }

    private static enum DICTTYPE {
        BoostTermDicts,
        StopwordDicts,
        QuerySynDicts;

    }
}

