/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.rs;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.CommonsMessageKeys;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.bi.rs.BaseContainerRequestFilter;
import com.ibm.bi.rs.ICapabilitiesFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ICapabilitiesFilter
public class CapabilitiesFilter
extends BaseContainerRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilitiesFilter.class);
    private static final boolean disabled = Boolean.getBoolean("CapabilitiesFilter.disable");
    @Context
    protected ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest servletRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!disabled) {
            MatchType matchType = this.getMatchType();
            Object[] capabilitiesToCheck = this.getCapabilitiesList();
            if (capabilitiesToCheck != null && capabilitiesToCheck.length > 0) {
                JsonArray userCapabilities = this.getUserCapabilities();
                if (userCapabilities != null) {
                    if (!this.capabilitiesMatch(matchType, userCapabilities, (String[])capabilitiesToCheck) && this.abort()) {
                        requestContext.abortWith(this.abortResponse(CommonsMessageKeys.capabilities_required.buildMessage((Object)Arrays.toString(capabilitiesToCheck)).getLocalizedMessage()));
                    }
                } else {
                    LOGGER.error("error retrieving user capabilities");
                    if (this.abort()) {
                        requestContext.abortWith(this.abortResponse(CommonsMessageKeys.capabilities_check.buildMessage().getLocalizedMessage()));
                    }
                }
            }
        }
    }

    boolean capabilitiesMatch(MatchType matchType, JsonArray userCapabilities, String[] capabilitiesToCheck) {
        HashSet<Object> ucs = new HashSet<Object>(userCapabilities);
        for (String capability : capabilitiesToCheck) {
            if (ucs.contains(capability)) {
                if (!matchType.equals((Object)MatchType.ANY)) continue;
                return true;
            }
            if (!matchType.equals((Object)MatchType.ALL)) continue;
            return false;
        }
        return !matchType.equals((Object)MatchType.ANY);
    }

    String[] getCapabilitiesList() {
        ICapabilitiesFilter icf = (ICapabilitiesFilter)this.getEffectiveAnnotation(ICapabilitiesFilter.class);
        if (icf != null) {
            return icf.capabilities();
        }
        return null;
    }

    MatchType getMatchType() {
        MatchType annotation = null;
        ICapabilitiesFilter icf = (ICapabilitiesFilter)this.getEffectiveAnnotation(ICapabilitiesFilter.class);
        if (icf != null) {
            annotation = icf.match();
        }
        return annotation == null ? MatchType.ANY : annotation;
    }

    JsonArray getUserCapabilities() {
        JsonObject me = null;
        try (RESTClient client = RESTClientFactory.getInstance().getClient(this.servletRequest);){
            me = client.getResource("/bi/v1/user_capabilities", "application/json");
        }
        catch (Exception e) {
            LOGGER.error("error", (Throwable)e);
            return null;
        }
        return me.getArray("userCapabilities");
    }

    protected Response abortResponse(String message) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)message).header("Content-Type", (Object)"text/plain").build();
    }

    boolean abort() {
        ICapabilitiesFilter icf = (ICapabilitiesFilter)this.getEffectiveAnnotation(ICapabilitiesFilter.class);
        if (icf != null) {
            return icf.abort();
        }
        return true;
    }

    public static enum MatchType {
        ANY,
        ALL;

    }
}

