/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.rs;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;

@Provider
public class RequestTimeFilter
implements ContainerResponseFilter,
ContainerRequestFilter {
    private static final boolean disabled = Boolean.getBoolean("RequestTimeFilter.disable");

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object startObj;
        if (!disabled && (startObj = requestContext.getProperty("start")) != null) {
            long start = (Long)startObj;
            long end = System.currentTimeMillis();
            this.addHeader(responseContext, "x-ca-requesttime", this.getValue(requestContext, start, end));
        }
    }

    void addHeader(ContainerResponseContext responseContext, String name, String value) {
        responseContext.getHeaders().add((Object)name, (Object)value);
    }

    private String getValue(ContainerRequestContext requestContext, long start, long end) {
        return "path=" + requestContext.getUriInfo().getPath() + "; start=" + start + "; end=" + end + "; elapsed=" + (end - start);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!disabled) {
            requestContext.setProperty("start", (Object)System.currentTimeMillis());
        }
    }
}

