/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.finder.entity;

import com.ibm.smarts.conversation.finder.entity.ColumnFinderResponse;
import com.ibm.smarts.conversation.finder.entity.ColumnFinderStatus;
import com.ibm.smarts.conversation.finder.entity.UnknownEntityProcessor;
import com.ibm.smarts.conversation.finder.entity.UnknownEntityProcessorResponse;
import com.ibm.smarts.conversation.finder.entity.UnknownEntityProcessorStatus;
import com.ibm.smarts.conversation.finder.module.ModuleFinder;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.intent.Limit;
import com.ibm.smarts.conversation.nlu.schema.intent.Operator;
import com.ibm.smarts.conversation.schema.ClientContext;
import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.intent.Column;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.model.common.content.ContentObject;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityType;
import com.ibm.smarts.nlu.resolver.schema.resolution.Resolution;
import com.ibm.smarts.nlu.resolver.schema.resolution.ResolutionResponse;
import com.ibm.smarts.nlu.resolver.schema.resolution.SentenceResolution;
import com.ibm.smarts.nlu.resolver.schema.resolution.UnResolvedEntity;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Aggregation;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Expression;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Membership;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.OrderBy;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ColumnFinder {
    private boolean requireJoinCheck;
    private ClientContext clientContext;
    private IConversationProvider provider;
    private List<ContentObject> allSources = null;
    private UnknownEntityProcessor unknownEntityProcessor;

    public ColumnFinder(ClientContext clientContext, IConversationProvider provider, boolean requireJoinCheck) {
        this.unknownEntityProcessor = new UnknownEntityProcessor(provider);
        this.requireJoinCheck = requireJoinCheck;
        this.clientContext = clientContext;
        this.provider = provider;
    }

    public void setUnknownEntity(Entity unknownEntity) {
        this.unknownEntityProcessor.setUnknownEntity(unknownEntity);
    }

    public Entity getUnknownEntity() {
        return this.unknownEntityProcessor.getUnknownEntity();
    }

    public ColumnFinderResponse processRedefinedEntity(String oldSentence, String redefinedEntity, String skillId) {
        UnknownEntityProcessorResponse response = this.unknownEntityProcessor.processRedefinedEntity(oldSentence, redefinedEntity, skillId, true);
        return this.retryGetColumns(response);
    }

    private ColumnFinderResponse retryGetColumns(UnknownEntityProcessorResponse response) {
        ColumnFinderResponse newResponse = this.getColumns(response.getSentence(), response.getNluEntities(), response.getSkillId());
        return newResponse;
    }

    public ColumnFinderResponse getColumns(String sentence, List<Entity> nluEntities, String skillId) {
        String smartsModuleId = this.clientContext.getModuleId();
        if (smartsModuleId == null || smartsModuleId.isEmpty()) {
            ResolutionResponse resolutionResponse = this.provider.resolveEntities(null, sentence, nluEntities, skillId, this.requireJoinCheck);
            SentenceResolution primaryResolution = resolutionResponse.getResolutionInModule();
            List globalResolutions = resolutionResponse.getGlobalCandidates();
            if (primaryResolution == null) {
                if (globalResolutions.isEmpty()) {
                    if (nluEntities.isEmpty() || nluEntities.stream().filter(r -> r.getId().equals("column")).collect(Collectors.toList()).isEmpty()) {
                        ColumnFinderStatus status = new ColumnFinderStatus("NO_FINAL_ENTITIES");
                        return new ColumnFinderResponse(sentence, null, null, null, status, false);
                    }
                    List unknownColumns = nluEntities.stream().filter(r -> r.getId().equals("column")).collect(Collectors.toList());
                    UnknownEntityProcessorResponse unknownEntityresponse = this.unknownEntityProcessor.handleUnknownEntities(Collections.singletonMap(null, unknownColumns), sentence, skillId);
                    return this.handleUnknownEntityProcessorResponse(unknownEntityresponse, primaryResolution, globalResolutions);
                }
                primaryResolution = (SentenceResolution)globalResolutions.get(0);
                Source source = ModuleFinder.getSourceById(primaryResolution.getModuleId(), this.getAllSources(this.provider));
                this.clientContext.setContext(source.getId(), source.getType(), source.getLabel());
                return this.buildResponse(sentence, skillId, primaryResolution, globalResolutions);
            }
            Source source = ModuleFinder.getSourceById(primaryResolution.getModuleId(), this.getAllSources(this.provider));
            this.clientContext.setContext(source.getId(), source.getType(), source.getLabel());
            return this.buildResponse(sentence, skillId, primaryResolution, globalResolutions);
        }
        ResolutionResponse resolutionResponse = this.provider.resolveEntities(smartsModuleId, sentence, nluEntities, skillId, this.requireJoinCheck);
        SentenceResolution primaryResolution = resolutionResponse.getResolutionInModule();
        List globalResolutions = resolutionResponse.getGlobalCandidates();
        return this.buildResponse(sentence, skillId, primaryResolution, globalResolutions);
    }

    private ColumnFinderResponse buildResponse(String sentence, String skillId, SentenceResolution primaryResolution, List<SentenceResolution> globalResolutions) {
        List<Entity> primaryUnknownColumns = this.filterUnknownColumnEntities(primaryResolution);
        if (primaryResolution.getResolutions().isEmpty() && globalResolutions.isEmpty() && primaryUnknownColumns.isEmpty()) {
            ColumnFinderStatus status = new ColumnFinderStatus("NO_FINAL_ENTITIES");
            return new ColumnFinderResponse(sentence, null, null, null, status, false);
        }
        List<String> moduleIdsWithAllColFound = globalResolutions.stream().filter(g -> this.filterUnknownColumnEntities((SentenceResolution)g).isEmpty()).map(SentenceResolution::getModuleId).collect(Collectors.toList());
        List<Source> sourcesWithAllColFound = ModuleFinder.getSourceListByIds(moduleIdsWithAllColFound, this.getAllSources(this.provider));
        List<Column> columns = primaryResolution.getResolutions().stream().map(ColumnFinder::convertResolution).collect(Collectors.toList());
        List<Column> columnsMissingColInfo = columns.stream().filter(col -> col.getColumnInfo() == null).collect(Collectors.toList());
        if (!columnsMissingColInfo.isEmpty()) {
            SmartsModule smarts = this.provider.getSmartModule(primaryResolution.getModuleId(), new ArrayList(columnsMissingColInfo.stream().map(Column::getId).collect(Collectors.toList())), false);
            HashMap id2ColinfoMap = new HashMap();
            columnsMissingColInfo.forEach(f -> {
                ColumnInfo colInfo = id2ColinfoMap.computeIfAbsent(f.getId(), k -> SmartsUtil.getColumnInfoByIdForExpression((SmartsModule)smarts, (String)k));
                f.setColumnInfo(colInfo);
            });
        }
        if (primaryUnknownColumns.isEmpty()) {
            return this.checkInvalidConstraints(primaryResolution, sentence, columns, sourcesWithAllColFound);
        }
        Map<String, List<Entity>> moduleUnknownsMap = this.getUnknownColumnsInAllModules(primaryResolution, globalResolutions);
        if (!sourcesWithAllColFound.isEmpty()) {
            ColumnFinderStatus status = new ColumnFinderStatus("FOUND_ALL_COLUMNS_IN_ANOTHER_SOURCE");
            boolean isUnjoinable = false;
            if (primaryResolution != null) {
                isUnjoinable = primaryResolution.isUnjoinable();
            }
            return new ColumnFinderResponse(sentence, null, sourcesWithAllColFound, moduleUnknownsMap, status, isUnjoinable);
        }
        UnknownEntityProcessorResponse unknownEntityresponse = this.unknownEntityProcessor.handleUnknownEntities(moduleUnknownsMap, sentence, skillId);
        return this.handleUnknownEntityProcessorResponse(unknownEntityresponse, primaryResolution, globalResolutions);
    }

    private ColumnFinderResponse checkInvalidConstraints(SentenceResolution primaryResolution, String sentence, List<Column> columns, List<Source> sourcesWithAllColFound) {
        String status;
        List primaryUnknownNonColumns = primaryResolution.getUnresolved().stream().filter(r -> r.getUnresolvedEntity() != null && !r.getUnresolvedEntity().getId().equals("column")).collect(Collectors.toList());
        if (primaryUnknownNonColumns.isEmpty()) {
            return new ColumnFinderResponse(sentence, columns, sourcesWithAllColFound, null, new ColumnFinderStatus("FOUND_ALL_COLUMNS_IN_CURRENT_SOURCE"), primaryResolution.isUnjoinable());
        }
        UnResolvedEntity firstInvalidConstraint = (UnResolvedEntity)primaryUnknownNonColumns.get(0);
        String relatedColumn = firstInvalidConstraint.getRelatedEntityResolution();
        switch (firstInvalidConstraint.getReason()) {
            case INVALID_AGGREGATION_CONSTRAINT: {
                status = "INVALID_AGGREGATION";
                break;
            }
            case MISSING_ORDER_BY_ENTITY_ORDER_CONSTRAINT: {
                status = "MISSING_ORDER_BY_ENTITY_ORDER";
                break;
            }
            case INVALID_PERCENTAGE_ORDER_CONSTRAINT: {
                status = "INVALID_PERCENTAGE_ORDER";
                break;
            }
            case INVALID_SINGLE_MEASURE_ORDER_CONSTRAINT: {
                status = "INVALID_SINGLE_MEASURE_ORDER";
                break;
            }
            case INVALID_MEASURE_EXPRESSION_CONSTRAINT: {
                status = "INVALID_MEASURE_EXPRESSION";
                break;
            }
            default: {
                status = "ERROR";
            }
        }
        return new ColumnFinderResponse(sentence, columns, sourcesWithAllColFound, null, new ColumnFinderStatus(status, relatedColumn), primaryResolution.isUnjoinable());
    }

    private Map<String, List<Entity>> getUnknownColumnsInAllModules(SentenceResolution primaryResolution, List<SentenceResolution> globalResolutions) {
        Map<String, List<Entity>> moduleUnknownsMap = globalResolutions.stream().filter(r -> !this.filterUnknownColumnEntities((SentenceResolution)r).isEmpty()).collect(Collectors.toMap(e -> e.getModuleId(), e -> e.getUnresolved().stream().map(f -> f.getUnresolvedEntity()).collect(Collectors.toList())));
        if (primaryResolution != null) {
            List<Entity> unresolvedColumns = this.filterUnknownColumnEntities(primaryResolution);
            moduleUnknownsMap.put(primaryResolution.getModuleId(), unresolvedColumns);
        }
        return moduleUnknownsMap;
    }

    private List<Source> getSourcesWithAllColumnsFound(List<SentenceResolution> globalResolutions) {
        List<String> moduleIdsWithAllColFound = globalResolutions.stream().filter(g -> this.filterUnknownColumnEntities((SentenceResolution)g).isEmpty()).map(SentenceResolution::getModuleId).collect(Collectors.toList());
        List<Source> sourcesWithAllColFound = ModuleFinder.getSourceListByIds(moduleIdsWithAllColFound, this.getAllSources(this.provider));
        return sourcesWithAllColFound;
    }

    private List<Entity> filterUnknownColumnEntities(SentenceResolution resolution) {
        return resolution.getUnresolved().stream().map(e -> e.getUnresolvedEntity()).filter(r -> r.getId().equals("column")).collect(Collectors.toList());
    }

    private static Column convertResolution(Resolution resolution) {
        boolean isExplicit = !resolution.getResolutionType().equals(EntityType.FILTER.getId()) && (resolution.getConstraints().isEmpty() || resolution.getConstraints().stream().noneMatch(cons -> cons.getConstraintType().equals((Object)ConstraintType.EXPRESSION)));
        Column column = new Column(resolution.getColId(), resolution.getDatasetId(), resolution.getModuleId(), resolution.getColumnInfo(), isExplicit);
        List constraints = resolution.getConstraints();
        for (Constraint constraint : constraints) {
            if (constraint == null) continue;
            switch (constraint.getConstraintType()) {
                case AGGREGATION: {
                    ColumnFinder.setColumnAggregation(column, constraint);
                    break;
                }
                case ORDER: {
                    ColumnFinder.setColumnOrder(column, constraint);
                    break;
                }
                case MEMBERSHIP: {
                    ColumnFinder.setColumnMembership(column, constraint);
                    break;
                }
                case EXPRESSION: {
                    ColumnFinder.setColumnExpression(column, constraint);
                }
            }
        }
        return column;
    }

    private static void setColumnAggregation(Column column, Constraint constraint) {
        Aggregation aggregation = (Aggregation)constraint;
        column.setAggregator(aggregation.getAggregator());
    }

    private static void setColumnOrder(Column column, Constraint constraint) {
        OrderBy orderBy = (OrderBy)constraint;
        column.setOrder(orderBy.getOrder());
        Limit limit = orderBy.getLimit();
        if (limit != null) {
            column.setLimit(new Limit(limit.getNumber(), limit.isPercent()));
        }
        column.setOrderBy(orderBy.getOrderedById(), orderBy.getOrderedByName(), orderBy.getOrderByAggregator());
    }

    private static void setColumnMembership(Column column, Constraint constraint) {
        Membership membership = (Membership)constraint;
        if (membership.isInclusion()) {
            membership.getMembers().forEach(m -> column.addFilter(m, false));
        } else {
            membership.getMembers().forEach(m -> column.addFilter(m, true));
        }
    }

    private static void setColumnExpression(Column column, Constraint constraint) {
        Expression exp = (Expression)constraint;
        Operator op = Operator.formText((String)exp.getOperator().getText());
        column.setExpression(op, exp.getValue().getValue().toString());
    }

    private ColumnFinderResponse handleUnknownEntityProcessorResponse(UnknownEntityProcessorResponse unknownEntityresponse, SentenceResolution primaryResolution, List<SentenceResolution> globalResolutions) {
        if (unknownEntityresponse.getStatus().equals((Object)UnknownEntityProcessorStatus.UNKNOWN_COLUMNS_RESOLVED)) {
            return this.retryGetColumns(unknownEntityresponse);
        }
        Map<String, List<Entity>> moduleUnknownsMap = this.getUnknownColumnsInAllModules(primaryResolution, globalResolutions);
        List<Source> sourcesWithAllColFound = this.getSourcesWithAllColumnsFound(globalResolutions);
        if (unknownEntityresponse.getStatus().equals((Object)UnknownEntityProcessorStatus.UNKNOWN_COLUMNS_NOT_IN_DICTIONARY)) {
            Entity unknownEntity = unknownEntityresponse.getUnknownEntity();
            return new ColumnFinderResponse(unknownEntityresponse.getSentence(), null, sourcesWithAllColFound, moduleUnknownsMap, new ColumnFinderStatus("UNKNOWN_COLUMNS_NOT_IN_DICTIONARY", unknownEntity.getText()), primaryResolution != null ? primaryResolution.isUnjoinable() : false);
        }
        if (unknownEntityresponse.getStatus().equals((Object)UnknownEntityProcessorStatus.UNKNOWN_COLUMN_IS_KNOWN_IN_AT_LEAST_ONE_SOURCE)) {
            return new ColumnFinderResponse(unknownEntityresponse.getSentence(), null, sourcesWithAllColFound, moduleUnknownsMap, new ColumnFinderStatus("UNKNOWN_COLUMN_IS_KNOWN_IN_AT_LEAST_ONE_SOURCE"), primaryResolution != null ? primaryResolution.isUnjoinable() : false);
        }
        return new ColumnFinderResponse(unknownEntityresponse.getSentence(), null, sourcesWithAllColFound, moduleUnknownsMap, new ColumnFinderStatus("ERROR"), primaryResolution != null ? primaryResolution.isUnjoinable() : false);
    }

    private List<ContentObject> getAllSources(IConversationProvider provider) {
        if (this.allSources == null) {
            this.allSources = provider.getDataSources();
        }
        return this.allSources;
    }
}

