/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.finder.entity;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.finder.entity.UnknownEntityProcessorResponse;
import com.ibm.smarts.conversation.finder.entity.UnknownEntityProcessorStatus;
import com.ibm.smarts.conversation.nlu.NLUTagger;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownEntityProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnknownEntityProcessor.class);
    private Entity unknownEntity = null;
    private int numberOfRedefineAttempts = 0;
    private static final int MAX_REDEFINE_ATTEMPTS = 3;
    private static final String SYNONYM_DICTIONARY = "dictionary";
    private static final String DICTIONARY_KEY = "key";
    private static final String DICTIONARY_VALUE = "value";
    private static final int DICTIONARY_SIZE = 30;
    private IConversationProvider provider;

    public UnknownEntityProcessor(IConversationProvider provider) {
        this.provider = provider;
    }

    public void setUnknownEntity(Entity unknownEntity) {
        this.unknownEntity = unknownEntity;
    }

    public Entity getUnknownEntity() {
        return this.unknownEntity;
    }

    public UnknownEntityProcessorResponse handleUnknownEntities(Map<String, List<Entity>> unknownEntitiesInAllModules, String oldSentence, String skillId) {
        this.unknownEntity = this.getFirstUnknownEntity(unknownEntitiesInAllModules);
        if (this.unknownEntity != null) {
            LOGGER.debug("Globally Unknown Entity: {}", (Object)this.unknownEntity);
            String redefinedEntity = null;
            if (this.numberOfRedefineAttempts < 3) {
                redefinedEntity = this.getSynonymFromUPS(this.unknownEntity.getText());
                ++this.numberOfRedefineAttempts;
            }
            if (redefinedEntity != null) {
                LOGGER.debug("Replace {} with UPS: {}", (Object)this.unknownEntity.getText(), (Object)redefinedEntity);
                return this.processRedefinedEntity(oldSentence, redefinedEntity, skillId, false);
            }
            return new UnknownEntityProcessorResponse(UnknownEntityProcessorStatus.UNKNOWN_COLUMNS_NOT_IN_DICTIONARY, this.unknownEntity, oldSentence);
        }
        return new UnknownEntityProcessorResponse(UnknownEntityProcessorStatus.UNKNOWN_COLUMN_IS_KNOWN_IN_AT_LEAST_ONE_SOURCE, oldSentence);
    }

    public UnknownEntityProcessorResponse processRedefinedEntity(String oldSentence, String redefinedEntity, String skillId, boolean addToUPS) {
        String newSentence = this.getNewSentence(oldSentence, this.unknownEntity, redefinedEntity);
        LOGGER.debug("Process reconstructed sentence: {}", (Object)newSentence);
        List newNluEntities = NLUTagger.tagSentence((String)newSentence, null, (IConversationProvider)this.provider, (String)skillId).getEntities();
        if (addToUPS) {
            this.addSynonymToUPS(this.createNewDictionaryEntry(this.unknownEntity.getText(), redefinedEntity));
        }
        return new UnknownEntityProcessorResponse(UnknownEntityProcessorStatus.UNKNOWN_COLUMNS_RESOLVED, newSentence, newNluEntities, skillId);
    }

    private String getNewSentence(String sentence, Entity originalEntity, String redefinedEntity) {
        sentence = sentence.substring(0, (int)originalEntity.getStart()) + redefinedEntity + sentence.substring((int)originalEntity.getEnd());
        return sentence;
    }

    private Entity getFirstUnknownEntity(Map<String, List<Entity>> unknownEntitiesInAllModules) {
        HashMap<Entity, Integer> map = new HashMap<Entity, Integer>();
        for (Map.Entry<String, List<Entity>> entry : unknownEntitiesInAllModules.entrySet()) {
            List<Entity> unknownEntities = entry.getValue();
            for (Entity entity : unknownEntities) {
                if (!entity.isColumn()) continue;
                Integer numberOfTimes = (Integer)map.get(entity);
                if (numberOfTimes == null) {
                    numberOfTimes = 1;
                } else {
                    Integer n = numberOfTimes;
                    Integer n2 = numberOfTimes = Integer.valueOf(numberOfTimes + 1);
                }
                map.put(entity, numberOfTimes);
            }
        }
        int totalNumberOfModules = unknownEntitiesInAllModules.size();
        for (Map.Entry entry : map.entrySet()) {
            if (totalNumberOfModules != (Integer)entry.getValue()) continue;
            return (Entity)entry.getKey();
        }
        return null;
    }

    private void addSynonymToUPS(JSONObject synonym) {
        JSONObject jsonBlob = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        JSONObject dictionary = this.provider.getConversationUserActions();
        if (dictionary != null && dictionary.containsKey((Object)SYNONYM_DICTIONARY)) {
            jsonArray = (JSONArray)dictionary.get((Object)SYNONYM_DICTIONARY);
            for (int i = 0; i < jsonArray.size(); ++i) {
                String key;
                JSONObject obj = (JSONObject)jsonArray.get(i);
                if (obj == null || !(key = (String)obj.get((Object)DICTIONARY_KEY)).equalsIgnoreCase((String)synonym.get((Object)DICTIONARY_KEY))) continue;
                jsonArray.remove(i);
                break;
            }
        }
        jsonArray.add(0, (Object)synonym);
        if (jsonArray.size() > 30) {
            jsonArray.remove(jsonArray.size() - 1);
        }
        jsonBlob.put((Object)SYNONYM_DICTIONARY, (Object)jsonArray);
        this.provider.storeConversationUserAction(jsonBlob);
    }

    private String getSynonymFromUPS(String entity) {
        JSONArray array;
        JSONObject dictionary = this.provider.getConversationUserActions();
        if (dictionary != null && dictionary.containsKey((Object)SYNONYM_DICTIONARY) && (array = (JSONArray)dictionary.get((Object)SYNONYM_DICTIONARY)) != null) {
            for (int i = 0; i < array.size(); ++i) {
                String key;
                JSONObject obj = (JSONObject)array.get(i);
                if (obj == null || !(key = (String)obj.get((Object)DICTIONARY_KEY)).equalsIgnoreCase(entity)) continue;
                String value = (String)obj.get((Object)DICTIONARY_VALUE);
                array.remove(i);
                array.add(0, (Object)this.createNewDictionaryEntry(key, value));
                JSONObject jsonBlob = new JSONObject();
                jsonBlob.put((Object)SYNONYM_DICTIONARY, (Object)array);
                this.provider.storeConversationUserAction(jsonBlob);
                return value;
            }
        }
        return null;
    }

    private JSONObject createNewDictionaryEntry(String key, String value) {
        JSONObject keyValue = new JSONObject();
        keyValue.put((Object)DICTIONARY_KEY, (Object)key);
        keyValue.put((Object)DICTIONARY_VALUE, (Object)value);
        return keyValue;
    }
}

