/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.finder.module;

import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.model.common.content.ContentObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ModuleFinder {
    private ModuleFinder() {
    }

    public static List<Source> findModule(String sentence, String suggestedModuleName, IConversationProvider provider) {
        List<Source> sources;
        List contentObjects = provider.getDataSources();
        if (contentObjects.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)sentence)) {
            sources = ModuleFinder.getAllSources(contentObjects);
        } else {
            List<ContentObject> filteredCO = ModuleFinder.findSourcesBySentence(sentence, contentObjects);
            if (filteredCO.isEmpty()) {
                if (StringUtils.isEmpty((CharSequence)suggestedModuleName)) {
                    sources = ModuleFinder.getAllSources(contentObjects);
                } else {
                    filteredCO = ModuleFinder.findSourcesByFilter(suggestedModuleName, contentObjects);
                    sources = ModuleFinder.getAllSources(filteredCO);
                }
            } else {
                sources = ModuleFinder.getAllSources(filteredCO);
            }
        }
        return sources;
    }

    private static List<ContentObject> findSourcesBySentence(String sentence, List<ContentObject> contentObjects) {
        ArrayList<ContentObject> sources = new ArrayList<ContentObject>();
        int maxLen = -1;
        for (ContentObject co : contentObjects) {
            int len = co.defaultName.length();
            if (len < maxLen || !StringUtils.containsIgnoreCase((CharSequence)sentence, (CharSequence)co.defaultName)) continue;
            if (len > maxLen) {
                sources.clear();
            }
            sources.add(co);
            maxLen = len;
        }
        return sources;
    }

    private static List<ContentObject> findSourcesByFilter(String suggestedModuleName, List<ContentObject> contentObjects) {
        ArrayList<ContentObject> sources = new ArrayList<ContentObject>();
        for (ContentObject co : contentObjects) {
            if (StringUtils.equalsIgnoreCase((CharSequence)suggestedModuleName, (CharSequence)co.defaultName)) {
                sources.clear();
                sources.add(co);
                break;
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)co.defaultName, (CharSequence)suggestedModuleName)) continue;
            sources.add(co);
        }
        return sources;
    }

    private static List<Source> getAllSources(List<ContentObject> contentObjects) {
        return contentObjects.stream().map(co -> new Source(co.defaultName, co.id, co.type, (String)co.getFields().get("location"))).collect(Collectors.toList());
    }

    public static Source getSourceById(String id, List<ContentObject> objects) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        for (ContentObject co : objects) {
            if (!co.id.equals(id)) continue;
            return new Source(co.defaultName, co.id, co.type, (String)co.getFields().get("location"));
        }
        return null;
    }

    public static List<Source> getSourceListByIds(List<String> ids, List<ContentObject> objects) {
        ArrayList<Source> sources = new ArrayList<Source>();
        if (ids == null || ids.isEmpty()) {
            return sources;
        }
        Map<String, ContentObject> coMap = objects.stream().collect(Collectors.toMap(o -> o.id, o -> o));
        for (String id : ids) {
            ContentObject co = coMap.get(id);
            if (co == null) continue;
            sources.add(new Source(co.defaultName, co.id, co.type, (String)co.getFields().get("location")));
        }
        return sources;
    }
}

