/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.api.query;

import java.util.Collections;
import java.util.Map;

public interface IRecord<T> {
    public T getRecord();

    public String getId();

    default public String getRecordVersion() {
        return "";
    }

    default public Map<String, String> getResourceURI() {
        return Collections.emptyMap();
    }

    public static <T> IRecord<T> create(final T record, final String id) {
        return new IRecord<T>(){

            @Override
            public T getRecord() {
                return record;
            }

            @Override
            public String getId() {
                return id;
            }

            public String toString() {
                return IRecord.convertToString(record, id, "");
            }
        };
    }

    public static <T> IRecord<T> create(final T record, final String id, final String version) {
        return new IRecord<T>(){

            @Override
            public T getRecord() {
                return record;
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getRecordVersion() {
                return version;
            }

            public String toString() {
                return IRecord.convertToString(record, id, version);
            }
        };
    }

    public static <T> IRecord<T> create(final T record, final String id, final String version, final Map<String, String> urlMap) {
        return new IRecord<T>(){

            @Override
            public T getRecord() {
                return record;
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getRecordVersion() {
                return version;
            }

            @Override
            public Map<String, String> getResourceURI() {
                return urlMap;
            }

            public String toString() {
                return IRecord.convertToString(record, id, version);
            }
        };
    }

    public static <T> String convertToString(T record, String id, String version) {
        StringBuilder sb = new StringBuilder();
        sb.append("[IRecord");
        sb.append(" id=" + id);
        if (!version.isEmpty()) {
            sb.append(" version=" + version);
        }
        sb.append(" record=" + record);
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }
}

