/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.schema;

import com.ibm.smarts.common.learning.Sentiment;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.visualization.recommender.schema.AutoGrouping;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public interface IRecommendedVisualization
extends Comparable<IRecommendedVisualization> {
    public String getLabel();

    public double getScore();

    public String getCombintaionId();

    public List<Binding> getColumnBindings();

    public int getRank();

    public String toString();

    public boolean isMatrix();

    public String getNaturalLanguageLabel();

    public String getNaturalLanguageTitle();

    public String getNaturalLanguageDescription();

    public void setNaturalLanguage(String var1, String var2, String var3, Locale var4);

    public Map<String, AutoGrouping> getAutoGrouping();

    default public Map<String, TopBottomFilter> getTopBottomFilters() {
        return Collections.emptyMap();
    }

    default public Map<String, InclusionExclusionFilter> getInclusionExclusionFilters() {
        return Collections.emptyMap();
    }

    default public List<BaseFilter> getBaseFilterList() {
        return Collections.emptyList();
    }

    default public Map<String, AggregationType> getAggregationMap() {
        return Collections.emptyMap();
    }

    default public Sentiment getSentiment() {
        return Sentiment.NONE;
    }

    @Override
    default public int compareTo(IRecommendedVisualization o) {
        int result = Double.compare(this.getScore(), o.getScore());
        if (result == 0) {
            if (this.getRank() == o.getRank()) {
                return 0;
            }
            if (this.getRank() > o.getRank()) {
                return -1;
            }
            return 1;
        }
        if (result < 0) {
            return -1;
        }
        return 1;
    }
}

