/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.client;

import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.SemanticSearchResult;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class SimilarityClassifierClient
extends CaRestClient {
    public SimilarityClassifierClient(RequestContext requestContext, Properties config) {
        super((RestClient.RestCallContextFactory)requestContext.getAttribute("com.ibm.smarts.rest.restCallContextFactory"), requestContext, config.getProperty("smarts.ca.core.caServer.url"));
    }

    public CompletableFuture<SemanticSearchResult> similarityClassifierAsync(String smartsModuleId, List<Entity> nluEntities) {
        String path = Paths.similarityClassifierPath();
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("smartsModuleId", new String[]{smartsModuleId});
        if (nluEntities != null && !nluEntities.isEmpty()) {
            String[] entities = (String[])nluEntities.stream().map(entity -> entity.toJSON().toString()).toArray(String[]::new);
            queryParams.add("nluEntities", entities);
        }
        return this.getAsync(path, queryParams).thenApply(json -> (SemanticSearchResult)CommonJAXBHelper.unmarshalFromJSON(SemanticSearchResult.class, (String)json));
    }

    public SemanticSearchResult similarityClassifier(String smartsModuleID, List<Entity> nluEntities) {
        try {
            return this.similarityClassifierAsync(smartsModuleID, nluEntities).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private static class Paths {
        private static final String INSIGHTS = "/bi/v1/smarts/insights";
        private static final String SIMILARITY_CLASSIFIER = "/bi/v1/smarts/insights/semantic-search/similarity-classifier/classify";

        private Paths() {
        }

        public static String similarityClassifierPath() {
            return SIMILARITY_CLASSIFIER;
        }
    }
}

