/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.SystemIntentHandlersRegistrar;
import com.ibm.smarts.conversation.exceptions.ProviderException;
import com.ibm.smarts.conversation.intent.SkillErrorIntentHandler;
import com.ibm.smarts.conversation.intent.UnknownIntentHandler;
import com.ibm.smarts.conversation.nlu.NLUTagger;
import com.ibm.smarts.conversation.nlu.SkillAction;
import com.ibm.smarts.conversation.nlu.skills.ISystemIntentHandlersRegistrar;
import com.ibm.smarts.conversation.nlu.skills.SkillsManager;
import com.ibm.smarts.conversation.schema.ChatContext;
import com.ibm.smarts.conversation.schema.ClientContext;
import com.ibm.smarts.conversation.schema.ConversationRequest;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.GeneralErrorAction;
import com.ibm.smarts.conversation.schema.action.ListenAction;
import com.ibm.smarts.conversation.schema.action.ShowErrorAction;
import com.ibm.smarts.conversation.schema.action.ShowTextAction;
import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.conversation.schema.training.TrainingStatus;
import com.ibm.smarts.conversation.skill.handler.SentenceHandler;
import com.ibm.smarts.conversation.skill.intent.IntentHandler;
import com.ibm.smarts.conversation.utils.ConversationUtils;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Conversation.class);

    private Conversation() {
    }

    public static Action processSentence(ConversationRequest request, IConversationProvider provider) {
        try {
            String skillId;
            List sources;
            Source activeSource;
            ClientContext context = request.getClientContext();
            if (context.getModuleId() == null && (activeSource = (Source)(sources = request.getAppContext().getSources()).stream().filter(s -> s.isActive()).findFirst().orElse(!sources.isEmpty() ? (Source)sources.get(0) : null)) != null) {
                context.setContext(activeSource.getId(), activeSource.getType(), activeSource.getLabel());
            }
            String sentence = request.getSentence();
            sentence = ConversationUtils.normalizeSentence(sentence);
            request.setSentence(sentence);
            if (sentence.isEmpty()) {
                return new ShowErrorAction(Messages.getString((String)"Conversation.InvalidSentence"));
            }
            ChatContext chatContext = request.getChatContext();
            List params = chatContext.getClickParams();
            if (params != null && !params.isEmpty()) {
                skillId = (String)params.get(0);
                params.remove(0);
            } else {
                SkillAction skillAction = NLUTagger.getSkillLockAction((String)sentence);
                skillId = skillAction.getSkillId();
                switch (skillAction.getAction()) {
                    case LOCK_SKILL: {
                        context.lockSkill(skillAction.getSkillId());
                        return new ShowTextAction(String.format(Messages.getString((String)"Conversation.SkillWelcome"), Conversation.getSkillsManager().getSkillById(skillId).getName()));
                    }
                    case UNLOCK_SKILL: {
                        String lockedSkillId = context.getLockedSkill();
                        String defaultSkillId = Conversation.getSkillsManager().getDefaultSkillId();
                        if (lockedSkillId == null || lockedSkillId.equals(defaultSkillId)) {
                            return new ShowErrorAction(String.format(Messages.getString((String)"Conversation.NoSkillToUnlock"), Conversation.getSkillsManager().getSkillById(defaultSkillId).getActivationPhrase()));
                        }
                        context.unlockSkill();
                        return new ShowTextAction(String.format(Messages.getString((String)"Conversation.SkillGoodbye"), Conversation.getSkillsManager().getSkillById(lockedSkillId).getName()));
                    }
                    case DIRECT_TO_SKILL: {
                        sentence = skillAction.getSkillSentence();
                        request.setSentence(sentence);
                        break;
                    }
                    case DEFAULT: {
                        skillId = context.getLockedSkill();
                    }
                }
                if (skillId == null) {
                    skillId = Conversation.getSkillsManager().getDefaultSkillId();
                }
            }
            SentenceHandler sentenceHandler = Conversation.createSentenceHandler(skillId);
            if (sentenceHandler != null) {
                sentenceHandler.init(request, provider, skillId);
                return sentenceHandler.getAction();
            }
            return new GeneralErrorAction();
        }
        catch (ProviderException ex) {
            LOGGER.error("sentence", (Throwable)ex);
            String exceptionMessage = ex.getFailureMessage();
            if (StringUtils.isNotBlank((CharSequence)exceptionMessage)) {
                return new ShowTextAction(exceptionMessage);
            }
            return new GeneralErrorAction(ex.getServiceName());
        }
        catch (Exception ex) {
            LOGGER.error("sentence", (Throwable)ex);
            return new GeneralErrorAction(Messages.getString((String)"Service.Conversation"));
        }
    }

    public static void initializeConversationEngine(Properties config) {
        NLUTagger.initializeNLUEngine((Properties)config, (ISystemIntentHandlersRegistrar)new SystemIntentHandlersRegistrar());
    }

    public static Action continueSentence(ConversationRequest request, IConversationProvider provider) {
        return new ListenAction();
    }

    public static Action reset(ConversationRequest request) {
        return new ShowTextAction(Messages.getString((String)"Conversation.HelloAgain"));
    }

    public static IntentHandler createIntentHandler(String skillId, String intent) {
        Class intentHandlerClass = NLUTagger.getIntentHandlerClass((String)skillId, (String)intent);
        if (intentHandlerClass == null) {
            LOGGER.error("No intent handler found in registry for skill: {}, intent: {}", (Object)skillId, (Object)intent);
            return new UnknownIntentHandler();
        }
        try {
            return (IntentHandler)intentHandlerClass.newInstance();
        }
        catch (IllegalAccessException e) {
            LOGGER.error(String.format("Illegal access exception for class: %s for intent: %s, skill: %s", intentHandlerClass.getName(), intent, skillId), (Throwable)e);
            return new SkillErrorIntentHandler();
        }
        catch (InstantiationException e) {
            LOGGER.error(String.format("Cannot instantiate class: %s for intent: %s, skill: %s", intentHandlerClass.getName(), intent, skillId), (Throwable)e);
            return new SkillErrorIntentHandler();
        }
    }

    public static SentenceHandler createSentenceHandler(String skillId) {
        Class sentenceHandlerClass = NLUTagger.getSentenceHandlerClass((String)skillId);
        if (sentenceHandlerClass == null) {
            LOGGER.error("No sentence handler found in registry for skill: {}", (Object)skillId);
            return null;
        }
        try {
            return (SentenceHandler)sentenceHandlerClass.newInstance();
        }
        catch (IllegalAccessException e) {
            LOGGER.error(String.format("Illegal access exception for class: %s, skill: %s", sentenceHandlerClass.getName(), skillId), (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            LOGGER.error(String.format("Cannot instantiate class: %s, skill: %s", sentenceHandlerClass.getName(), skillId), (Throwable)e);
            return null;
        }
    }

    public static String createSkill(JSONObject trainingData, String activationPhrase, String jarFilePath, JSONObject blob, IConversationProvider provider) {
        String storeId = provider.createSkill(trainingData, activationPhrase, jarFilePath, blob, TrainingStatus.QUEUED);
        Conversation.getSkillsManager().buildSkill(storeId, trainingData, activationPhrase, jarFilePath, blob, provider);
        return storeId;
    }

    public static boolean deleteSkill(String storeId, IConversationProvider provider) {
        if (provider.deleteSkill(storeId)) {
            Conversation.getSkillsManager().deleteSkill(storeId);
            return true;
        }
        return false;
    }

    public static boolean updateSkill(String storeId, JSONObject trainingData, String activationPhrase, String jarFilePath, JSONObject blob, IConversationProvider provider) {
        if (provider.updateSkill(storeId, trainingData, activationPhrase, jarFilePath, blob, TrainingStatus.QUEUED)) {
            Conversation.getSkillsManager().updateSkill(storeId, trainingData, activationPhrase, jarFilePath, blob, provider);
            return true;
        }
        return false;
    }

    private static SkillsManager getSkillsManager() {
        return NLUTagger.getNLUEngine().getSkillsManager();
    }
}

