/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.intent;

import com.ibm.json.java.JSONArray;
import com.ibm.smarts.conversation.schema.ChatContext;
import com.ibm.smarts.conversation.schema.ClientContext;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.GenerateDashboardAction;
import com.ibm.smarts.conversation.schema.action.ShowTextAction;
import com.ibm.smarts.conversation.skill.intent.IntentHandler;
import com.ibm.smarts.conversation.utils.ConversationUtils;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.List;

public class GenerateDashboardIntentHandler
extends IntentHandler {
    public Action getAction() {
        String moduleType;
        String moduleId;
        if (!ConversationUtils.canAuthorDashboard(this.request.getChatContext(), this.getProvider())) {
            return new ShowTextAction(Messages.getString((String)"GenerateDashboardAction.NoCreateDashboardCapability"));
        }
        VisRecommendation selectedChart = null;
        JSONArray modifiers = null;
        JSONArray filters = null;
        ChatContext chatContext = this.request.getChatContext();
        ClientContext clientContext = this.request.getClientContext();
        if (this.getIntent().equals("generate_dashboard_context")) {
            moduleId = chatContext.getModuleId();
            moduleType = chatContext.getModuleType();
            modifiers = chatContext.getVisModifiers();
            filters = chatContext.getVisFilters();
            selectedChart = chatContext.getSelectedChart();
            if (modifiers == null && selectedChart == null) {
                return new ShowTextAction(Messages.getString((String)"GenerateDashboardAction.NoRelatedChart"));
            }
        } else {
            moduleId = clientContext.getModuleId();
            moduleType = clientContext.getModuleType();
        }
        if (moduleId == null || moduleId.isEmpty()) {
            return new ShowTextAction(Messages.getString((String)"Conversation.NoSelectedSource"));
        }
        List containers = this.getProvider().getContentRecommendations(moduleId, moduleType, this.getAppContext().getIncludedCharts(), this.getAppContext().getExcludedCharts(), !this.getIntent().equals("generate_dashboard_simple"), modifiers, filters, selectedChart);
        if (containers.isEmpty()) {
            return new ShowTextAction(Messages.getString((String)"GenerateDashboardAction.NoGeneratedDashboard"));
        }
        return new GenerateDashboardAction(moduleId, moduleType, containers);
    }
}

