/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.intent;

import com.ibm.smarts.conversation.intent.ShowColumnsIntentHandler;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.GenerateDashboardAction;
import com.ibm.smarts.conversation.schema.action.ShowTextAction;
import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.intent.Column;
import com.ibm.smarts.conversation.utils.ConversationUtils;
import java.util.List;

public class GuidedDashboardIntentHandler
extends ShowColumnsIntentHandler {
    @Override
    public Action createActionFromItems(List<Column> columns, List<Source> sources) {
        if (!ConversationUtils.canAuthorDashboard(this.request.getChatContext(), this.getProvider())) {
            return new ShowTextAction(Messages.getString((String)"GenerateDashboardAction.NoCreateDashboardCapability"));
        }
        String moduleId = this.request.getClientContext().getModuleId();
        String moduleType = this.request.getClientContext().getModuleType();
        if (columns.stream().findAny().filter(column -> column.getColumnInfo() != null).isPresent()) {
            List containers = this.getProvider().getContentRecommendations(moduleId, moduleType, this.getAppContext().getIncludedCharts(), this.getAppContext().getExcludedCharts(), true, columns);
            if (containers.isEmpty()) {
                return new ShowTextAction(Messages.getString((String)"GenerateDashboardAction.NoGeneratedDashboard"));
            }
            return new GenerateDashboardAction(moduleId, moduleType, containers);
        }
        return new ShowTextAction(Messages.getString((String)"GenerateDashboardAction.NoGeneratedDashboard"));
    }

    @Override
    public boolean canHandleModifiedItem() {
        return true;
    }

    @Override
    public boolean canHandleFilters() {
        return true;
    }

    @Override
    public boolean requireJoinCheck() {
        return true;
    }
}

