/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.intent;

import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.intent.Column;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.LogicalGroupType;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsightsManager.class);
    private static final String HAS_POSITIVE_INDICATOR = "hasPositiveIndicator";
    private static final String INCREASED = "Increased";
    private static final String DECREASED = "Decreased";

    public static List<String> getInsights(IConversationProvider provider, String moduleId, String moduleType, SmartsModule module, Column column) {
        try {
            ArrayList<String> insights = new ArrayList<String>();
            String datasetId = column.getDatasetId();
            Optional<DatasetInfo> ds = module.getDatasets().stream().filter(dataset -> datasetId.equals(dataset.getId())).findFirst();
            if (ds.isPresent()) {
                DatasetInfo dataset2 = ds.get();
                List<LogicalGroup> groups = InsightsManager.getScenarioGroups(dataset2, column.getId());
                for (LogicalGroup group : groups) {
                    List members = group.getMember();
                    List flattenedColumns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataset2);
                    List columns = members.stream().map(member -> {
                        String idForExpression = member.getIdForExpression();
                        return flattenedColumns.stream().filter(c -> idForExpression.equals(c.getIdForExpression())).findFirst().orElse(null);
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    double[] values = provider.getColumnsTotals(moduleId, moduleType, columns);
                    if (values == null) continue;
                    String positiveIndicator = "";
                    ConceptInfo concept = group.getConcept();
                    if (concept != null) {
                        positiveIndicator = (String)ConceptsRegistry.instance().getConcept(concept.getConceptID()).getProperties().get(HAS_POSITIVE_INDICATOR);
                    }
                    String insight = InsightsManager.getInsight(dataset2, (LogicalGroup.Member)members.get(0), values[0], (LogicalGroup.Member)members.get(1), values[1], positiveIndicator);
                    insights.add(insight);
                }
            }
            return insights;
        }
        catch (Exception e) {
            LOGGER.error("Error querying for insights", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<LogicalGroup> getScenarioGroups(DatasetInfo dataset, String columnIdForExpression) {
        return dataset.getLogicalGroups().stream().filter(group -> LogicalGroupType.SCENARIO == group.getLogicGroupType() && group.getMember().stream().anyMatch(member -> columnIdForExpression.equals(member.getIdForExpression()))).collect(Collectors.toList());
    }

    private static String getInsight(DatasetInfo dataset, LogicalGroup.Member memberPlanned, double valuePlanned, LogicalGroup.Member memberActual, double valueActual, String positiveIndicator) {
        List columns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataset);
        String columnNameActual = InsightsManager.getColumnName(columns, memberActual);
        String columnNamePlanned = InsightsManager.getColumnName(columns, memberPlanned);
        double pct = Math.abs(100.0 * (valueActual / valuePlanned - 1.0));
        int actualVsPlanned = Double.compare(valueActual, valuePlanned);
        String insight = actualVsPlanned > 0 ? (INCREASED.equals(positiveIndicator) ? String.format(Messages.getString((String)"Insight.ExceedBeat"), EscapeUtils.markdown((String)columnNameActual), EscapeUtils.markdown((String)columnNamePlanned), pct) : (DECREASED.equals(positiveIndicator) ? String.format(Messages.getString((String)"Insight.ExceedMiss"), EscapeUtils.markdown((String)columnNameActual), EscapeUtils.markdown((String)columnNamePlanned), pct) : String.format(Messages.getString((String)"Insight.Exceed"), EscapeUtils.markdown((String)columnNameActual), EscapeUtils.markdown((String)columnNamePlanned), pct))) : (actualVsPlanned < 0 ? (DECREASED.equals(positiveIndicator) ? String.format(Messages.getString((String)"Insight.LowerBeat"), EscapeUtils.markdown((String)columnNameActual), EscapeUtils.markdown((String)columnNamePlanned), pct) : (INCREASED.equals(positiveIndicator) ? String.format(Messages.getString((String)"Insight.LowerMiss"), EscapeUtils.markdown((String)columnNameActual), EscapeUtils.markdown((String)columnNamePlanned), pct) : String.format(Messages.getString((String)"Insight.Lower"), EscapeUtils.markdown((String)columnNameActual), EscapeUtils.markdown((String)columnNamePlanned), pct))) : String.format(Messages.getString((String)"Insight.Equal"), EscapeUtils.markdown((String)columnNameActual), EscapeUtils.markdown((String)columnNamePlanned)));
        return insight;
    }

    private static String getColumnName(List<ColumnInfo> columns, LogicalGroup.Member member) {
        String name = "";
        String idForExpression = member.getIdForExpression();
        Optional<ColumnInfo> col = columns.stream().filter(c -> idForExpression.equals(c.getIdForExpression())).findFirst();
        if (col.isPresent()) {
            name = col.get().getName();
        }
        return name;
    }
}

