/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.intent;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.finder.module.ModuleFinder;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.schema.ChatContext;
import com.ibm.smarts.conversation.schema.ClientContext;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.GeneralErrorAction;
import com.ibm.smarts.conversation.schema.action.ShowQueryItemsAction;
import com.ibm.smarts.conversation.schema.action.ShowSourcesAction;
import com.ibm.smarts.conversation.schema.action.ShowTextAction;
import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.provider.ConversationColumnInfo;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.conversation.skill.intent.IntentHandler;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadSourcesIntentHandler
extends IntentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadSourcesIntentHandler.class);

    public Action getAction() {
        ChatContext chatContext = this.request.getChatContext();
        List params = chatContext.getClickParams();
        if (params != null && !params.isEmpty()) {
            try {
                Source src = new Source(JSONObject.parse((String)((String)params.get(1))));
                return this.getOneModuleAction(src.getId(), src.getType(), src.getLabel());
            }
            catch (IOException e) {
                LOGGER.error("Error parsing click parameters: ", (Throwable)e);
                return new GeneralErrorAction(Messages.getString((String)"Service.Conversation"));
            }
        }
        String sentence = this.nluResponse.getSentence();
        List rasaEntities = this.nluResponse.getEntities();
        String moduleName = null;
        if (rasaEntities != null && !rasaEntities.isEmpty()) {
            Entity entity = (Entity)rasaEntities.get(0);
            long start = entity.getStart();
            long end = entity.getEnd();
            for (int i = 1; i < rasaEntities.size(); ++i) {
                entity = (Entity)rasaEntities.get(i);
                if (entity.getEnd() <= end) continue;
                end = entity.getEnd();
            }
            moduleName = sentence.substring((int)start, (int)end);
        }
        return this.buildAction(sentence, moduleName);
    }

    private Action getOneModuleAction(String moduleId, String moduleType, String moduleLabel) {
        SmartsModule smarts;
        ClientContext clientContext = this.request.getClientContext();
        clientContext.setContext(moduleId, moduleType, moduleLabel);
        clientContext.addEvent("source", (Object)moduleLabel);
        boolean isPartial = false;
        try {
            smarts = this.getProvider().getSmartModule(moduleId, Collections.emptyList(), true);
            AnalysisStateType state = smarts.getAnalysisState();
            switch (state) {
                case PARTIAL: 
                case IN_PROGRESS: {
                    isPartial = true;
                    break;
                }
                case CANCELED: {
                    return new ShowTextAction(String.format(Messages.getString((String)"LoadSourcesIntentHandler.SmartsCanceled"), EscapeUtils.markdown((String)moduleLabel)));
                }
                case FAILED: {
                    return new ShowTextAction(String.format(Messages.getString((String)"LoadSourcesIntentHandler.SmartsFailed"), EscapeUtils.markdown((String)moduleLabel)));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Can't load smarts", (Throwable)ex);
            return new ShowTextAction(String.format(Messages.getString((String)"LoadSourcesIntentHandler.NoSmarts"), EscapeUtils.markdown((String)moduleLabel)));
        }
        boolean isInteresting = true;
        List<ConversationColumnInfo> interestingColumns = this.getProvider().getInterestingColumns(moduleId, smarts);
        if (interestingColumns == null || interestingColumns.isEmpty()) {
            interestingColumns = this.getAllColumns(smarts);
            if (interestingColumns.isEmpty()) {
                return new ShowTextAction(String.format(Messages.getString((String)"LoadSourcesIntentHandler.SmartsEmpty"), EscapeUtils.markdown((String)moduleLabel)));
            }
            isInteresting = false;
        }
        List questions = Collections.emptyList();
        return new ShowQueryItemsAction(interestingColumns, questions, moduleId, moduleLabel, moduleType, isInteresting, isPartial);
    }

    private Action getOneModuleAction(Source source) {
        return this.getOneModuleAction(source.getId(), source.getType(), source.getLabel());
    }

    private List<ConversationColumnInfo> getAllColumns(SmartsModule smarts) {
        ArrayList<ConversationColumnInfo> cols = new ArrayList<ConversationColumnInfo>();
        for (DatasetInfo ds : smarts.getDatasets()) {
            List columns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds);
            List dsCol = columns.stream().map(column -> new ConversationColumnInfo(column, ds.getId())).collect(Collectors.toList());
            cols.addAll(dsCol);
        }
        return cols;
    }

    private Action buildAction(String sentence, String filter) {
        List sources = ModuleFinder.findModule((String)sentence, (String)filter, (IConversationProvider)this.getProvider());
        if (sources == null) {
            return new ShowTextAction(Messages.getString((String)"LoadSourcesIntentHandler.NoModules"));
        }
        if (sources.isEmpty()) {
            return new ShowTextAction(String.format(Messages.getString((String)"LoadSourcesIntentHandler.ModuleNotFound"), EscapeUtils.markdown((String)filter)));
        }
        if (sources.size() == 1) {
            return this.getOneModuleAction((Source)sources.get(0));
        }
        return new ShowSourcesAction(sources);
    }

    public boolean isStandalone() {
        return true;
    }
}

