/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.intent;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.finder.entity.ColumnFinder;
import com.ibm.smarts.conversation.finder.entity.ColumnFinderResponse;
import com.ibm.smarts.conversation.finder.entity.ColumnFinderStatus;
import com.ibm.smarts.conversation.intent.InsightsManager;
import com.ibm.smarts.conversation.nlu.ConversationNLUResponse;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import com.ibm.smarts.conversation.schema.ChatContext;
import com.ibm.smarts.conversation.schema.ClientContext;
import com.ibm.smarts.conversation.schema.ConversationRequest;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.GeneralErrorAction;
import com.ibm.smarts.conversation.schema.action.ShowChartAction;
import com.ibm.smarts.conversation.schema.action.ShowModifiedItemAction;
import com.ibm.smarts.conversation.schema.action.ShowQueryItemInfoAction;
import com.ibm.smarts.conversation.schema.action.ShowTextAction;
import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.intent.Column;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.conversation.skill.intent.IntentHandler;
import com.ibm.smarts.conversation.utils.ConversationUtils;
import com.ibm.smarts.generated.parser.ParseException;
import com.ibm.smarts.nlg.api.ISmartsNLGRealiser;
import com.ibm.smarts.nlg.api.SmartsNLGFactory;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowColumnsIntentHandler
extends IntentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowColumnsIntentHandler.class);
    private Module joinProposal;
    private boolean shouldTryJoin = false;
    private SmartsModule currentSmartsModule = null;
    private String sentence;
    private ColumnFinder columnFinder;

    public void init(ConversationNLUResponse parseResponse, ConversationRequest request, IConversationProvider provider) {
        super.init(parseResponse, request, provider);
        this.sentence = parseResponse.getSentence();
        this.columnFinder = new ColumnFinder(request.getClientContext(), provider, this.requireJoinCheck());
    }

    public void init(JSONObject json, ConversationRequest request, IConversationProvider provider) {
        JSONObject jsonJoinProposal;
        super.init(json, request, provider);
        this.sentence = (String)json.get((Object)"sentence");
        this.columnFinder = new ColumnFinder(request.getClientContext(), provider, this.requireJoinCheck());
        JSONObject jsonUnknownEntity = (JSONObject)json.get((Object)"unknownEntity");
        if (jsonUnknownEntity != null) {
            Entity unknownEntity = EntityFactory.createEntityFromJSON((JSONObject)jsonUnknownEntity);
            this.columnFinder.setUnknownEntity(unknownEntity);
        }
        if ((jsonJoinProposal = (JSONObject)json.get((Object)"joinProposal")) != null) {
            this.joinProposal = Module.fromJSON((JSONObject)jsonJoinProposal, (ObjectFactory)new ObjectFactory());
        }
    }

    public String getSentence() {
        if (this.sentence != null) {
            return this.sentence;
        }
        return super.getSentence();
    }

    public Action getAction() {
        Source source;
        ChatContext chatContext = this.request.getChatContext();
        List params = chatContext.getClickParams();
        ClientContext clientContext = this.request.getClientContext();
        if (params != null && !params.isEmpty()) {
            ArrayList<Column> columns = new ArrayList<Column>();
            try {
                Source src = new Source(JSONObject.parse((String)((String)params.get(1))));
                clientContext.setContext(src.getId(), src.getType(), src.getLabel());
                for (int i = 2; i < params.size(); ++i) {
                    JSONObject param = JSONObject.parse((String)((String)params.get(i)));
                    Column column = new Column(param, clientContext.getModuleId());
                    columns.add(column);
                }
                if (!columns.isEmpty()) {
                    if (columns.size() == 1) {
                        return this.buildOneItemAction(columns, null);
                    }
                    return this.buildMultipleItemsAction(columns, null);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error parsing click parameters: ", (Throwable)e);
                return new GeneralErrorAction(Messages.getString((String)"Service.Conversation"));
            }
        }
        if (clientContext.getModuleId() == null && (source = this.request.getAppContext().getActiveSource()) != null) {
            clientContext.setContext(source.getId(), source.getType(), source.getLabel());
        }
        ColumnFinderResponse response = this.columnFinder.getColumns(this.sentence, this.nluResponse.getEntities(), this.skillId);
        this.sentence = response.getSentence();
        return this.buildAction(response);
    }

    public Action getResumeAction(String redefinedEntity) {
        ColumnFinderResponse response = this.columnFinder.processRedefinedEntity(this.sentence, redefinedEntity, this.skillId);
        this.sentence = response.getSentence();
        return this.buildAction(response);
    }

    public Action resumeJoin() {
        ClientContext clientContext = this.request.getClientContext();
        Module module = this.getProvider().getModule(clientContext.getModuleId());
        this.getProvider().updateModule(clientContext.getModuleId(), module);
        return null;
    }

    private Action getNoItemsActionWithSources(String message, List<Source> sources) {
        return new ShowTextAction(message == null ? Messages.getString((String)"ShowColumnsIntentHandler.NoColumnsFound") : message, sources, this.request.getSentence(), this.getIntent());
    }

    private Action getNoItemsAction(String message) {
        return this.getNoItemsActionWithSources(message, null);
    }

    private Action buildAction(ColumnFinderResponse response) {
        ColumnFinderStatus status = response.getStatus();
        ClientContext clientContext = this.request.getClientContext();
        if ("NO_FINAL_ENTITIES".equals(status.getCode())) {
            return this.getNoItemsAction(null);
        }
        if ("UNKNOWN_COLUMNS_NOT_IN_DICTIONARY".equals(status.getCode())) {
            clientContext.pushIntent(this.toJSON());
            String markdownSafeUnknownText = EscapeUtils.markdown((String)status.getAffectedColumn());
            String message = String.format(Messages.getString((String)"ShowColumnsIntentHandler.WhatDoYouMean"), markdownSafeUnknownText, markdownSafeUnknownText, markdownSafeUnknownText);
            return new ShowTextAction(message);
        }
        if ("UNKNOWN_COLUMN_IS_KNOWN_IN_AT_LEAST_ONE_SOURCE".equals(status.getCode())) {
            String smartsModuleId;
            String string = smartsModuleId = clientContext != null ? clientContext.getModuleId() : null;
            if (smartsModuleId == null || smartsModuleId.isEmpty()) {
                String msg = String.format(Messages.getString((String)"ShowColumnsIntentHandler.NoColumnsNoContext"), EscapeUtils.markdown((String)this.request.getClientContext().getModuleName()));
                return this.getNoItemsActionWithSources(msg, null);
            }
        }
        return this.buildGlobalSearchResultAction(response);
    }

    private List<Column> getExplicitItems(List<Column> columns) {
        ArrayList<Column> explicitItems = new ArrayList<Column>(columns.size());
        for (Column column : columns) {
            if (!column.isExplicit()) continue;
            explicitItems.add(column);
        }
        return explicitItems;
    }

    private Column getFirstExplicitItem(List<Column> columns) {
        for (Column column : columns) {
            if (!column.isExplicit()) continue;
            return column;
        }
        return null;
    }

    private int getNumberOfExplicitItems(List<Column> columns) {
        int numberOfExplicitItems = 0;
        for (Column column : columns) {
            if (!column.isExplicit()) continue;
            ++numberOfExplicitItems;
        }
        return numberOfExplicitItems;
    }

    private Action buildGlobalSearchResultAction(ColumnFinderResponse response) {
        ClientContext clientContext = this.request.getClientContext();
        List columns = response.getItems();
        List sources = response.getSources();
        if (columns == null || columns.isEmpty()) {
            String msg;
            Map unknownsAllModules = response.getUnknownEntitiesInAllModules();
            List unknownColumnsInContext = (List)unknownsAllModules.get(clientContext.getModuleId());
            if (unknownColumnsInContext == null || unknownColumnsInContext.isEmpty()) {
                msg = String.format(Messages.getString((String)"ShowColumnsIntentHandler.NoColumnsHasSources"), EscapeUtils.markdown((String)clientContext.getModuleName()));
            } else {
                ArrayList<String> unknownColumns = new ArrayList<String>();
                for (Entity unknownEntity : unknownColumnsInContext) {
                    unknownColumns.add("***" + EscapeUtils.markdownForNLGRealiser((String)unknownEntity.getText()) + "***");
                }
                ISmartsNLGRealiser realiser = SmartsNLGFactory.createRealiser();
                try {
                    msg = realiser.realise(Messages.getString((String)"ShowColumnsIntentHandler.UnknownColumnsHasSources"), new Object[]{unknownColumns, "***" + EscapeUtils.markdownForNLGRealiser((String)clientContext.getModuleName()) + "***"});
                }
                catch (ParseException e) {
                    LOGGER.error("NLG Parser error", (Throwable)e);
                    msg = String.format(Messages.getString((String)"GeneralErrorAction.ServiceError"), Messages.getString((String)"Service.NLG"));
                    sources = null;
                }
            }
            return this.getNoItemsActionWithSources(msg, sources);
        }
        if (response.isUnjoinable()) {
            return this.handleUnjoinedItems(columns);
        }
        int numberOfExplicitItems = this.getNumberOfExplicitItems(columns);
        if (numberOfExplicitItems == 0) {
            return new ShowTextAction(Messages.getString((String)"SuggestionIntentHandler.RephraseFilter"), sources, this.getSentence(), this.getIntent());
        }
        String affectedColumn = response.getStatus().getAffectedColumn();
        switch (response.getStatus().getCode()) {
            case "INVALID_AGGREGATION": {
                return new ShowTextAction(String.format(Messages.getString((String)"ShowColumnsIntentHandler.InvalidAggregation"), EscapeUtils.markdown((String)affectedColumn)));
            }
            case "MISSING_ORDER_BY_ENTITY_ORDER": {
                return new ShowTextAction(String.format(Messages.getString((String)"ShowColumnsIntentHandler.SortedCategory"), EscapeUtils.markdown((String)affectedColumn)));
            }
            case "INVALID_PERCENTAGE_ORDER": {
                return new ShowTextAction(String.format(Messages.getString((String)"ShowColumnsIntentHandler.InvalidMeasurePercent"), EscapeUtils.markdown((String)affectedColumn)));
            }
            case "INVALID_SINGLE_MEASURE_ORDER": {
                return new ShowTextAction(String.format(Messages.getString((String)"ShowColumnsIntentHandler.AggregatedFact"), EscapeUtils.markdown((String)affectedColumn)));
            }
            case "INVALID_MEASURE_EXPRESSION": {
                return new ShowTextAction(Messages.getString((String)"ShowColumnsIntentHandler.InvalidMeasureExpression"));
            }
        }
        if (numberOfExplicitItems == 1) {
            return this.buildOneItemAction(columns, sources);
        }
        return this.buildMultipleItemsAction(columns, sources);
    }

    private Action buildOneItemAction(List<Column> columns, List<Source> sources) {
        Column column = this.getFirstExplicitItem(columns);
        ColumnInfo colInfo = column.getColumnInfo();
        if (colInfo == null) {
            colInfo = SmartsUtil.getColumnInfoByIdForExpression((SmartsModule)this.getSmartsModule(new ArrayList<String>(Arrays.asList(column.getId()))), (String)column.getId());
        }
        if (colInfo != null) {
            column.setColumnInfo(colInfo);
            return this.createActionFromItems(columns, sources);
        }
        return new ShowTextAction(Messages.getString((String)"ShowColumnsIntentHandler.NoInfoFound"));
    }

    private Action buildMultipleItemsAction(List<Column> columns, List<Source> sources) {
        if ("showinfluencer".equals(this.getIntent())) {
            return new ShowTextAction(Messages.getString((String)"ShowColumnsIntentHandler.NoInfluencersMultipleColumns"));
        }
        return this.createActionFromItems(columns, sources);
    }

    private Action handleUnjoinedItems(List<Column> columns) {
        if (this.shouldTryJoin) {
            Set datasetIds = columns.stream().map(column -> column.getDatasetId()).collect(Collectors.toSet());
            ClientContext clientContext = this.request.getClientContext();
            this.joinProposal = this.getProvider().getJoinProposal(clientContext.getModuleId(), datasetIds);
            if (this.joinProposal != null && !this.joinProposal.getRelationship().isEmpty()) {
                if (this.getProvider().isModuleWritable(clientContext.getModuleId())) {
                    clientContext.pushIntent(this.toJSON());
                    return new ShowTextAction(String.format(Messages.getString((String)"ShowColumnsIntentHandler.JoinQuestion"), EscapeUtils.markdown((String)clientContext.getModuleName())));
                }
                return new ShowTextAction(Messages.getString((String)"ShowColumnsIntentHandler.ReadOnlyModule"));
            }
            return new ShowTextAction(Messages.getString((String)"ShowColumnsIntentHandler.NoJoin"));
        }
        return new ShowTextAction(Messages.getString((String)"ShowColumnsIntentHandler.NoJoin"));
    }

    private Action buildColumnInfoAction(Column column, List<Source> sources) {
        SmartsModule module = this.getSmartsModule(Collections.emptyList());
        List relatedColumns = Collections.emptyList();
        ClientContext clientContext = this.request.getClientContext();
        String moduleId = clientContext.getModuleId();
        if ("show".equals(this.getIntent())) {
            relatedColumns = this.getProvider().getRelatedColumns(module, moduleId, column.getId());
        } else if ("showinfluencer".equals(this.getIntent()) && (relatedColumns = this.getProvider().getColumnInfluencer(module, moduleId, column.getId())).isEmpty()) {
            return this.getNoItemsAction(String.format(Messages.getString((String)"ShowColumnsIntentHandler.NoInfluencers"), EscapeUtils.markdown((String)column.getName())));
        }
        List<String> insights = InsightsManager.getInsights(this.getProvider(), moduleId, clientContext.getModuleType(), module, column);
        return new ShowQueryItemInfoAction(column, relatedColumns, this.getIntent(), clientContext.getModuleName(), clientContext.getModuleId(), clientContext.getModuleType(), sources, insights, this.request.getSentence());
    }

    protected Action createActionFromItems(List<Column> columns, List<Source> sources) {
        ClientContext clientContext = this.request.getClientContext();
        int numberOfExplicitItems = this.getNumberOfExplicitItems(columns);
        if (numberOfExplicitItems == 1) {
            Column column = this.getFirstExplicitItem(columns);
            if (this.canHandleModifiedItem() && (column.isModified() || column.isFiltered() || columns.size() > 1)) {
                return new ShowModifiedItemAction(columns, clientContext.getModuleName(), clientContext.getModuleId(), clientContext.getModuleType(), sources, this.request.getSentence());
            }
            return this.buildColumnInfoAction(column, sources);
        }
        List visRecs = this.getProvider().getVisRecommendations(clientContext.getModuleId(), this.getExplicitItems(columns), this.request.getAppContext().getIncludedCharts(), this.request.getAppContext().getExcludedCharts());
        if (visRecs == null || visRecs.isEmpty()) {
            return new ShowTextAction(Messages.getString((String)"ShowColumnsIntentHandler.NoVizRecommendation"));
        }
        boolean canAuthorDashboard = ConversationUtils.canAuthorDashboard(this.request.getChatContext(), this.getProvider());
        return new ShowChartAction(clientContext.getModuleId(), clientContext.getModuleType(), clientContext.getModuleName(), visRecs, columns, sources, this.request.getSentence(), canAuthorDashboard);
    }

    protected boolean canHandleModifiedItem() {
        return this.isShowIntent();
    }

    protected boolean canHandleFilters() {
        return this.isShowIntent();
    }

    protected boolean requireJoinCheck() {
        return this.isShowIntent();
    }

    protected SmartsModule getSmartsModule(List<String> tags) {
        ClientContext clientContext = this.request.getClientContext();
        this.currentSmartsModule = this.getProvider().getSmartModule(clientContext.getModuleId(), tags, true);
        return this.currentSmartsModule;
    }

    protected JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put((Object)"sentence", (Object)this.sentence);
        Entity unknownEntity = this.columnFinder.getUnknownEntity();
        if (unknownEntity != null) {
            json.put((Object)"unknownEntity", (Object)unknownEntity.toJSON());
        }
        if (this.joinProposal != null) {
            json.put((Object)"joinProposal", (Object)this.joinProposal.toJSON());
        }
        return json;
    }

    public boolean isStandalone() {
        return true;
    }

    private boolean isShowIntent() {
        return "show".equals(this.getIntent());
    }
}

