/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.intent;

import com.ibm.smarts.conversation.nlu.NLUTagger;
import com.ibm.smarts.conversation.nlu.skills.Skill;
import com.ibm.smarts.conversation.nlu.skills.SkillsManager;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.ShowTextAction;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.conversation.skill.intent.IntentHandler;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class SkillDiscoverabilityIntentHandler
extends IntentHandler {
    public Action getAction() {
        SkillsManager skillsManager = NLUTagger.getNLUEngine().getSkillsManager();
        Collection skills = skillsManager.getAllSkills();
        if (skills == null || skills.size() <= 1) {
            return new ShowTextAction(Messages.getString((String)"Skills.NoSkillsFound"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(Messages.getString((String)"Skills.FoundSkills"), new Object[0]));
        String systemSkillId = skillsManager.getSystemSkillId();
        for (Skill skill : skills) {
            if (skill.getId().equals(systemSkillId)) continue;
            stringBuilder.append(String.format(Messages.getString((String)"Skills.Name"), EscapeUtils.markdown((String)skill.getName())));
            if (StringUtils.isNotBlank((CharSequence)skill.getDescription())) {
                stringBuilder.append(String.format(Messages.getString((String)"Skills.Description"), EscapeUtils.markdown((String)skill.getDescription())));
            }
            stringBuilder.append(String.format(Messages.getString((String)"Skills.ActivationPhrase"), EscapeUtils.markdown((String)skill.getName()), EscapeUtils.markdown((String)skill.getActivationPhrase())));
        }
        return new ShowTextAction(stringBuilder.toString());
    }

    public boolean isStandalone() {
        return true;
    }
}

