/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.intent;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.ShowTextAction;
import com.ibm.smarts.conversation.skill.intent.IntentHandler;
import com.ibm.smarts.conversation.utils.EntityUtils;
import com.ibm.smarts.conversation.utils.IntentUtils;
import java.util.List;

public class SuggestionIntentHandler
extends IntentHandler {
    public Action getAction() {
        JSONObject intentHandlerJSON = this.request.getClientContext().popIntent();
        if (intentHandlerJSON == null) {
            return new ShowTextAction(Messages.getString((String)"SuggestionIntentHandler.Rephrase"));
        }
        IntentHandler intentHandler = IntentUtils.getHandlerFromJSON(intentHandlerJSON, this.request, this.getProvider());
        List entities = this.nluResponse.getEntities();
        if (!entities.isEmpty()) {
            String redefinedEntity = this.getRedefineEntity(entities);
            String originSentence = intentHandler.getSentence();
            this.request.setSentence(originSentence);
            return intentHandler.getResumeAction(redefinedEntity);
        }
        return new ShowTextAction(Messages.getString((String)"SuggestionIntentHandler.Rephrase"));
    }

    private String getRedefineEntity(List<Entity> entities) {
        Entity entity = entities.get(entities.size() - 1);
        long start = entity.getStart();
        long end = entity.getEnd();
        for (int i = entities.size() - 1; i > 0; --i) {
            Entity entity1 = entities.get(i - 1);
            Entity entity2 = entities.get(i);
            if (!EntityUtils.isWhiteSpaceGap(this.getSentence(), entity1, entity2) && !entity1.partiallyContains(entity2)) continue;
            start = Math.min(start, Math.min(entity1.getStart(), entity2.getStart()));
            end = Math.max(end, Math.max(entity1.getEnd(), entity2.getEnd()));
        }
        return this.getSentence().substring((int)start, (int)end);
    }
}

