/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.utils;

import com.ibm.smarts.conversation.schema.ChatContext;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.nlp.core.utility.CharsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConversationUtils.class);

    private ConversationUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean canAuthorDashboard(ChatContext chatContext, IConversationProvider provider) {
        return chatContext.canAuthorDashboard() ? provider.canUseDashboard() : false;
    }

    public static String normalizeSentence(String sentence) {
        String normalizedSentence = CharsUtils.preProcessString((String)sentence);
        normalizedSentence = normalizedSentence.trim().replaceAll("\\s+", " ");
        if (sentence.length() != normalizedSentence.length()) {
            LOGGER.debug("Sentence has changed from {} to {}", (Object)sentence, (Object)normalizedSentence);
        }
        return normalizedSentence;
    }
}

