/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.common.content;

import com.ibm.smarts.model.common.content.ModuleCodec;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentObject.class);
    public final String id;
    public final String type;
    public final String defaultName;
    public final Long version;
    private Map<String, String> fields = new HashMap<String, String>();

    public ContentObject(String id, String type, String defaultName, Long version) {
        this.id = id;
        this.type = type;
        this.defaultName = defaultName;
        this.version = version;
    }

    public void addField(String name, String value) {
        this.fields.put(name, value);
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public String getField(String defaultName) {
        return this.getFields().get(defaultName);
    }

    public InputStream getDecodedInputStream(String fieldName) {
        String value = this.getFields().get(fieldName);
        try {
            return ModuleCodec.getDecodedInputStream(value);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("failed to create input stream for " + fieldName, (Throwable)e);
            return null;
        }
    }
}

