/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external;

import com.ibm.bi.config.external.CheckedFileContentException;
import com.ibm.bi.config.external.CheckedInputStreamFilter;
import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigurationSource
implements PolledConfigurationSource {
    private static final Logger LOG = LoggerFactory.getLogger(FileConfigurationSource.class);
    private File file;
    private long lastPolled;
    private boolean checkCRC;

    public FileConfigurationSource(File file, boolean checkCRC) {
        this.file = file;
        this.checkCRC = checkCRC;
    }

    public PollResult poll(boolean initial, Object checkPoint) throws IOException {
        long lastModified = this.file.lastModified();
        if (lastModified != this.lastPolled) {
            return this.checkCRC ? this.loadAndCheckCRC(lastModified) : this.load(lastModified);
        }
        return PollResult.createFull(null);
    }

    PollResult load(long lastModified) throws IOException {
        try (FileInputStream fin = new FileInputStream(this.file);){
            PollResult result = this.load(fin);
            this.lastPolled = lastModified;
            LOG.debug("Updated configuration file {} loaded", (Object)this.file);
            PollResult pollResult = result;
            return pollResult;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PollResult loadAndCheckCRC(long lastModified) throws IOException {
        try (CheckedInputStreamFilter fin = new CheckedInputStreamFilter(new FileInputStream(this.file));){
            PollResult result = this.load(fin);
            this.lastPolled = lastModified;
            LOG.debug("Updated configuration file {} loaded", (Object)this.file);
            PollResult pollResult = result;
            return pollResult;
        }
        catch (CheckedFileContentException cfx) {
            LOG.debug("content of file {} did not match checksum. File update may be in progress.  Will retry load on next poll.", (Object)this.file);
            return PollResult.createFull(null);
        }
    }

    PollResult load(InputStream is) throws IOException {
        Properties props = new Properties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        props.load(is);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        LOG.debug("Updated configuration file {} loaded", (Object)this.file);
        return PollResult.createFull(map);
    }
}

