/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.util;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.util.ConfigurationResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static String INSTALL_ROOT = null;
    private static String COGROOT_LINK_FILENAME = "cogroot.link";
    private static final String METADATA_PATH = "configuration/metadata/xml";
    private static final String CMPLST_TXT = "cmplst.txt";
    private static final String COMPNAME_CM = "CM";
    private static final String COMPNAME_DLS = "DLS";
    private static final String ENVVAR_FLIPPER_PORT = "FLIPPER_PORT";
    private static final String ENVVAR_FLIPPER_HOST = "FLIPPER_HOST";
    private static final String ENVVAR_RUNNING_ON_CLOUD = "RUNNING_ON_CLOUD";
    private static final String ENVVAR_RUNNING_WITH_P2PD = "RUNNING_WITH_P2PD";
    private static final String ENVVAR_BI_ENDPOINT = "BI_ENDPOINT";
    private static final String HOST_LOCALHOST = "localhost";
    private static final int FLIPPER_DEFAULT_PORT = 4300;
    private static final String CNFG_FLIPPER_MEMBER_HOST = "CFS.configGroupMemberHost";
    private static final String NODE_ID_SEPARATOR = "#";
    private static Properties cmpLstProperties = null;
    private static final String REPOSITORY_PATH = "configuration/data/flipper/config";
    private static final String CONFIG_TODELETE_FILE = "configuration/config_to_delete.txt";
    public static final String ME = "/v1/me";
    public static final String EXTERNAL_DISP_URL = "externalDispatcher";
    public static final String EXTERNAL_DISP_SCHEME = "externalDispatcherScheme";
    public static final String EXTERNAL_DISP_HOST = "externalDispatcherHost";
    public static final String EXTERNAL_DISP_PORT = "externalDispatcherPort";
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    public static HashMap<String, String> cloudConfigEntries = new HashMap();
    private static URL cogRootURL;
    private static String meRestUrl;
    private static Boolean CMServiceEnabled;

    private ConfigurationUtils() {
    }

    public static String getInstallRoot() {
        if (INSTALL_ROOT != null) {
            return INSTALL_ROOT;
        }
        String rootpath = null;
        String installdir = System.getProperty("install.dir");
        if (ConfigurationUtils.isAbsolutePath(installdir)) {
            rootpath = installdir;
        }
        if (rootpath == null) {
            try {
                InputStream locationStream = cogRootURL != null ? cogRootURL.openStream() : Class.forName("com.ibm.bi.config.util.ConfigurationUtils").getClassLoader().getResourceAsStream(COGROOT_LINK_FILENAME);
                if (null != locationStream) {
                    BufferedReader read = new BufferedReader(new InputStreamReader(locationStream));
                    rootpath = new File(read.readLine(), "./").getCanonicalPath();
                    log.debug("Root path: " + rootpath);
                }
            }
            catch (IOException | ClassNotFoundException | SecurityException e) {
                log.debug("Exception processing cogroot.link: ", (Throwable)e);
            }
        }
        INSTALL_ROOT = rootpath != null ? rootpath.replace('\\', '/') : null;
        return INSTALL_ROOT;
    }

    public static boolean isAbsolutePath(String path) {
        if (null != path && path.length() > 0) {
            File f = new File(path);
            return f.isAbsolute() || path.charAt(0) == '/' || path.charAt(0) == '\\';
        }
        return false;
    }

    public static String resolvePath(String inputPath) {
        String resultPath = "";
        if (inputPath != null && inputPath.length() > 0) {
            if (ConfigurationUtils.isAbsolutePath(inputPath)) {
                try {
                    File f = new File(inputPath);
                    resultPath = f.getCanonicalPath();
                }
                catch (IOException e) {
                    log.debug("Unexpected IOException occurred for ConfigurationUtils.resolvePath():", (Throwable)e);
                }
            } else {
                String root = ConfigurationUtils.getInstallRoot();
                if (root != null) {
                    try {
                        resultPath = new File(root, inputPath).getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        log.debug("Unexpected IOException occurred for ConfigurationUtils.resolvePath():", (Throwable)ioe);
                    }
                }
            }
        }
        return ConfigurationUtils.normalizePath(resultPath);
    }

    public static String normalizePath(String path) {
        if (path != null) {
            return path.replace('\\', '/');
        }
        return "";
    }

    public static void resetInstallRootForTest() {
        INSTALL_ROOT = null;
    }

    public static void setCogRootLinkFileNameForTest(String filename) {
        COGROOT_LINK_FILENAME = filename;
    }

    private static String getLocalHostName() {
        InetAddress localhost;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn("Exception getting localhost ", (Throwable)e);
            localhost = null;
        }
        return localhost != null ? localhost.getHostName() : "";
    }

    public static String replacePathDelimiter(String path) {
        if (path != null) {
            return path.replace('/', '.');
        }
        return path;
    }

    public static ArrayList<String> getMetadataFiles(String rootPath) {
        ArrayList<String> fullPaths = new ArrayList<String>();
        String metadataFolder = rootPath + "/" + METADATA_PATH;
        File file = new File(metadataFolder);
        if (file.exists()) {
            File[] fileList;
            for (File fileName : fileList = file.listFiles()) {
                try {
                    if (!fileName.isFile() || !fileName.getName().endsWith(".xml")) continue;
                    fullPaths.add(fileName.getCanonicalPath());
                }
                catch (IOException e) {
                    log.error("IOException occurred for ConfigurationUtils.getMetadataFiles():" + e.getMessage());
                    log.debug("exception detail:", (Throwable)e);
                }
            }
        }
        return fullPaths;
    }

    public static Properties getCmpLstProperties() {
        String absPath;
        File installProp;
        if (cmpLstProperties == null && (installProp = new File(absPath = ConfigurationUtils.resolvePath(CMPLST_TXT))).exists()) {
            try (FileInputStream fis = new FileInputStream(installProp);){
                cmpLstProperties = new Properties();
                cmpLstProperties.load(fis);
            }
            catch (IOException e) {
                log.error("exception reading cmplst from " + absPath, (Throwable)e);
            }
        }
        return cmpLstProperties;
    }

    public static boolean isComponentInstalled(String compName) {
        if (compName == null || compName.length() == 0) {
            return false;
        }
        String cmpEntry = compName + "_version";
        if (ConfigurationUtils.getCmpLstProperties() != null) {
            String ver = (String)cmpLstProperties.get(cmpEntry);
            return ver != null && ver.length() > 0;
        }
        return false;
    }

    public static boolean isCMEnabled() {
        if (CMServiceEnabled == null) {
            CMServiceEnabled = ConfigurationUtils.isComponentInstalled(COMPNAME_CM) && !Boolean.getBoolean("com.cognos.cm.service.disabled");
            log.debug("isCMEnabled() - init set CMServiceEnabled. com.cognos.cm.service.disabled = '{}', CMServiceEnabled = '{}'", (Object)Boolean.getBoolean("com.cognos.cm.service.disabled"), (Object)CMServiceEnabled);
        }
        return CMServiceEnabled;
    }

    public static void setCmpLstPropertiesForTest(Properties list) {
        cmpLstProperties = list;
    }

    public static String getLocalNodeId() {
        String name = ConfigurationUtils.getLocalHostName() + NODE_ID_SEPARATOR + ConfigurationUtils.getInstallRoot();
        return Base64.getUrlEncoder().encodeToString(name.getBytes());
    }

    public static File getRepositoryRoot() {
        String path = ConfigurationUtils.resolvePath(REPOSITORY_PATH);
        log.debug("Repository root= {}", (Object)path);
        return new File(path);
    }

    public static void setCogRootLinkUrlForTest(URL cogRootURL) {
        ConfigurationUtils.cogRootURL = cogRootURL;
    }

    public static boolean isDLSInstalled() {
        return ConfigurationUtils.isComponentInstalled(COMPNAME_DLS);
    }

    public static void addCloudConfigEntry(String keyname, String keyvalue) {
        cloudConfigEntries.put(keyname, keyvalue);
    }

    public static int getFlipperPort() {
        String port = System.getenv(ENVVAR_FLIPPER_PORT);
        if (StringUtils.isBlank((String)port) && StringUtils.isBlank((String)(port = cloudConfigEntries.get(EXTERNAL_DISP_PORT)))) {
            return 4300;
        }
        return Integer.parseInt(port);
    }

    public static String getFlipperhost() {
        String host = System.getenv(ENVVAR_FLIPPER_HOST);
        log.debug("host value from env var: {}", (Object)host);
        if (StringUtils.isBlank((String)host)) {
            host = ConfigurationPropertyFactory.getInstance().getStringProperty(CNFG_FLIPPER_MEMBER_HOST, HOST_LOCALHOST).get();
            log.debug("flipper host from config parameter, CFS.configGroupMemberHost is: {}", (Object)host);
        }
        return host;
    }

    public static String getFlipperScheme() {
        String scheme = cloudConfigEntries.get(EXTERNAL_DISP_SCHEME);
        if (StringUtils.isBlank((String)scheme)) {
            return SCHEME_HTTPS;
        }
        return scheme;
    }

    public static boolean runningOnCloud() {
        String cloud = System.getenv(ENVVAR_RUNNING_ON_CLOUD);
        return Boolean.parseBoolean(cloud);
    }

    public static boolean runningWithP2PD() {
        String withP2pd = System.getenv(ENVVAR_RUNNING_WITH_P2PD);
        return Boolean.parseBoolean(withP2pd);
    }

    public static String getBIEndpoint() {
        String biurl = System.getenv(ENVVAR_BI_ENDPOINT);
        return biurl;
    }

    public static boolean isDynamicNamespaceEnabled() {
        return !Boolean.getBoolean("com.ibm.bi.config.dynamicNamespaceDisabled");
    }

    public static String buildMeURL() {
        if (meRestUrl != null) {
            return meRestUrl;
        }
        String biurl = "/bi";
        if (ConfigurationUtils.runningOnCloud()) {
            biurl = ConfigurationUtils.getBIEndpoint();
        }
        meRestUrl = biurl + ME;
        log.debug("The url to query admin role is: " + meRestUrl);
        return meRestUrl;
    }

    public static String getLocalizedValue(String id, String localeID) {
        return ConfigurationResource.getMessage(id, localeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markToDelete(String configKeyName) {
        log.debug("in ConfigurationUtils.markToDelete()");
        String toDeleteFile = ConfigurationUtils.resolvePath(CONFIG_TODELETE_FILE);
        File file = new File(toDeleteFile);
        FileOutputStream os = null;
        if (!file.exists()) {
            log.debug("file {} doesn't exist, creating...");
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                log.error("Failed to create file: {} due to exception, {}", (Object)toDeleteFile, (Object)e.getMessage());
                return;
            }
        }
        try {
            log.debug("writing key to delete to the file");
            os = new FileOutputStream(file);
            os.write(configKeyName.getBytes());
            os.flush();
        }
        catch (IOException e) {
            log.error("Failed to write to file: {} due to exception, {} ", (Object)toDeleteFile, (Object)e.getMessage());
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    public static URL getHostPortFromURL(String urlstr) {
        try {
            URL url = new URL(urlstr);
            String hoststr = url.getHost();
            int port = url.getPort();
            String protocol = url.getProtocol();
            if (StringUtils.isEmpty((String)hoststr) || port <= 0 || StringUtils.isEmpty((String)protocol)) {
                log.error("getHostPortFromURL() - the url '" + urlstr + "' is not a valid base url.");
                return null;
            }
            return new URL(protocol + "://" + hoststr + ":" + port);
        }
        catch (MalformedURLException e) {
            log.error("getHostPortFromURL() - MalformedURLException when get baseurl from '" + urlstr + "'. - " + e);
            return null;
        }
    }

    public static String getCloudConfigString(String key) {
        return cloudConfigEntries.get(key);
    }

    public static void ResetCMServiceEnabledForTest() {
        CMServiceEnabled = null;
    }

    public static void setCMServiceEnabledForTest(boolean isEnabled) {
        CMServiceEnabled = new Boolean(isEnabled);
    }

    static {
        meRestUrl = null;
    }
}

