/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.util;

import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathConfigurationUtils {
    private static final Logger log = LoggerFactory.getLogger(PathConfigurationUtils.class);
    public static final String NO_ZOOKEEPER_CONFIGURATION = "no.zookeeper.configuration";
    public static final String INSTALLDATA_PROPFILE = "configuration/installData.properties";
    public static final String CONFIGURATION_ROOTPATH = "/configuration";
    public static final String GLOBAL_PATHNAME = "global";
    public static final String NODES_PATHNAME = "nodes";
    public static final String NODEID_PATHNAME_PREFIX = "nodeID";
    public static final String PATH_DELIMITER = "/";
    public static final String PROP_DELIMITER = ".";
    public static final String UTF8_ENCODING = "utf-8";

    public static String resolveToFullPath(String rootPath) {
        if (rootPath == null || rootPath.length() == 0) {
            return rootPath;
        }
        return "/configuration/" + rootPath;
    }

    public static String resolveKey(String key, String localNodePath) throws Exception {
        String resolvedKeyStr = key;
        if (key != null && key.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(key, PATH_DELIMITER);
            String firstToken = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                if (localNodePath.length() == 0) {
                    throw new Exception("The local node path is empty, unable to resolve key '" + key + "' to local node.");
                }
                return localNodePath + PATH_DELIMITER + key;
            }
            String nodeStr = firstToken;
            if (nodeStr != null && (nodeStr.equalsIgnoreCase(GLOBAL_PATHNAME) || nodeStr.equalsIgnoreCase(NODES_PATHNAME))) {
                return PathConfigurationUtils.resolveToFullPath(resolvedKeyStr);
            }
            throw new Exception("The path of key '" + key + "' is not valid, cannot set property");
        }
        throw new Exception("The key is empty, cannot set property");
    }

    public static String switchToPathDelimiter(String path) {
        String[] parts;
        String res = path;
        if (path != null && (parts = path.split("\\.")).length > 1) {
            StringBuilder newpath = new StringBuilder();
            String part1 = parts[0];
            if (part1.equals(GLOBAL_PATHNAME)) {
                String part2 = path.substring(GLOBAL_PATHNAME.length() + 1, path.length());
                newpath.append(part1).append(PATH_DELIMITER).append(part2);
            } else if (part1.equals(NODES_PATHNAME)) {
                String part2 = parts[1];
                if (part2.startsWith(NODEID_PATHNAME_PREFIX)) {
                    newpath.append(part1).append(PATH_DELIMITER).append(part2);
                    if (parts.length > 2) {
                        String rest = path.substring(NODES_PATHNAME.length() + part2.length() + 2, path.length());
                        newpath.append(PATH_DELIMITER).append(rest);
                    }
                } else {
                    newpath.append(part1);
                    String rest = path.substring(NODES_PATHNAME.length() + 1, path.length());
                    if (rest.length() > 0) {
                        newpath.append(PATH_DELIMITER).append(rest);
                    }
                }
            } else {
                newpath.append(path);
            }
            res = newpath.toString();
        }
        return res;
    }
}

