/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core;

import com.ibm.smarts.core.lifecycle.IComponentLifecycle;
import com.ibm.smarts.core.lifecycle.IComponentLifecycleOperations;
import com.ibm.smarts.core.lifecycle.ILifecycleManager;
import com.ibm.smarts.core.lifecycle.IManagedLifecycle;
import com.ibm.smarts.core.lifecycle.LifecycleManager;
import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.nlp.core.analyzer.SmartAnalyzer;
import com.ibm.smarts.nlp.core.analyzer.SmartAnalyzerImpl;
import com.ibm.smarts.nlp.core.corenlp.analyzer.CoreNLPAnalyzer;
import com.ibm.smarts.nlp.core.corenlp.analyzer.CoreNLPResourceManager;
import com.ibm.smarts.nlp.core.corenlp.domain.CoreNLPAssembler;
import com.ibm.smarts.nlp.core.corenlp.domain.CoreNLPResults;
import com.ibm.smarts.nlp.core.function.NlpSmartsModuleTasks;
import com.ibm.smarts.nlp.core.uima.UIMAServiceProvider;
import com.ibm.smarts.nlp.core.utility.CharsUtils;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartNLPImpl
implements SmartNLP,
IComponentLifecycle,
IManagedLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartNLPImpl.class);
    private final Properties configuration;
    private final IStoreProvider storeProvider;
    private final MessageQueueingSystem messageSystem;
    private final LifecycleManager clh;

    public SmartNLPImpl(Properties configuration, IStoreProvider storeProvider) {
        this(configuration, storeProvider, null);
    }

    public SmartNLPImpl(Properties configuration, IStoreProvider storeProvider, MessageQueueingSystem messageSystem) {
        this.configuration = configuration;
        this.storeProvider = storeProvider;
        this.messageSystem = messageSystem;
        if (messageSystem != null) {
            this.configureSmartsModuleTasks(storeProvider, messageSystem);
        }
        this.clh = new LifecycleManager((IComponentLifecycle)this, new IComponentLifecycleOperations[0]);
    }

    public String toString() {
        return String.format("[SmartNLPImpl @ %s config=%s storeProvider=%s messaging=%s]", Integer.toHexString(this.hashCode()), this.configuration, this.storeProvider, this.messageSystem);
    }

    public ILifecycleManager getLifecycleManager() {
        return this.clh;
    }

    public void initialize(RequestContext rc) {
        String uimaDatapath = this.configuration.getProperty("smarts.nlp.uima.datapath");
        String uimaDescriptor = this.configuration.getProperty("smarts.nlp.uima.descriptor");
        UIMAServiceProvider.createInstance((String)uimaDatapath, (String)uimaDescriptor);
        CoreNLPResourceManager.loadPipelineAndSettings();
        LOGGER.info("<TCL> Component initialize NLP");
    }

    public void shutDown(RequestContext rc) {
        LOGGER.info("<TCL> Component shutdown NLP");
    }

    public List<TextInfo> describeText(RequestContext requestContext, String[] text) {
        if (text == null || text.length == 0) {
            return Collections.emptyList();
        }
        Locale locale = this.getLocale(requestContext);
        return this.describe(locale, text);
    }

    private List<TextInfo> describe(Locale locale, String[] text) {
        String[] questionNoSpecialChar = new String[text.length];
        for (int i = 0; i < text.length; ++i) {
            questionNoSpecialChar[i] = CharsUtils.preProcessString(text[i]);
        }
        SmartAnalyzer smartAnalyzer = this.getSmartAnalyzer(locale);
        return smartAnalyzer.analyzeColumnNames(locale, questionNoSpecialChar);
    }

    public List<TextInfo> describeText(Locale locale, String[] text) {
        if (null == locale) {
            locale = Locale.US;
        }
        return this.describe(locale, text);
    }

    private SmartAnalyzer getSmartAnalyzer(Locale locale) {
        CoreNLPAnalyzer nlpAnalyzer = new CoreNLPAnalyzer(locale);
        CoreNLPAssembler assembler = new CoreNLPAssembler(locale);
        return new SmartAnalyzerImpl<CoreNLPResults>(nlpAnalyzer, assembler, locale);
    }

    private Locale getLocale(RequestContext requestContext) {
        Locale locale = requestContext == null || requestContext.locale == null ? Locale.US : requestContext.locale;
        return locale;
    }

    public TextInfo describeQuestion(RequestContext requestContext, String question) {
        Locale locale = this.getLocale(requestContext);
        SmartAnalyzer smartAnalyzer = this.getSmartAnalyzer(locale);
        return smartAnalyzer.analyzeQuestionForTextInfo(locale, question);
    }

    void configureSmartsModuleTasks(IStoreProvider storeProvider, MessageQueueingSystem messageSystem) {
        new NlpSmartsModuleTasks(storeProvider, messageSystem, this).configure();
    }
}

