/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.opennlp;

import com.ibm.smarts.nlp.core.opennlp.ChunkParser;
import com.ibm.smarts.nlp.core.opennlp.NLPModelFactory;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.cmdline.parser.ParserTool;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.Parser;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;

public class ChunkProcessor {
    private final ChunkParser chunkParser;

    public ChunkProcessor() {
        NLPModelFactory factor = new NLPModelFactory();
        ChunkerModel chunkModel = (ChunkerModel)factor.getNLPModel(NLPModelFactory.NLPModelType.chunker);
        ChunkerME chunkerME = new ChunkerME(chunkModel);
        POSModel posModel = (POSModel)factor.getNLPModel(NLPModelFactory.NLPModelType.postagger);
        POSTaggerME posTaggerME = new POSTaggerME(posModel);
        this.chunkParser = new ChunkParser(chunkerME, posTaggerME);
    }

    public Parse doChunking(String text) {
        Parse[] results = ParserTool.parseLine((String)text, (Parser)this.chunkParser, (int)1);
        return this.chunkParser.parse(results[0]);
    }
}

