/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.modifiers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.common.modifiers.CompositeFilter;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.FilterTypeConversionException;
import com.ibm.smarts.common.modifiers.FilterTypeDeserializer;
import com.ibm.smarts.common.modifiers.GenericFilter;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.NumericFilter;
import com.ibm.smarts.common.modifiers.NumericRangeFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import java.util.Objects;

@JsonDeserialize(using=FilterTypeDeserializer.class)
public abstract class BaseFilter {
    private String columnId;
    private String filterId;
    private String label;

    @JsonCreator
    public BaseFilter(@JsonProperty(value="columnId") String columnId, @JsonProperty(value="filterId") String filterId, @JsonProperty(value="label") String label) {
        this.columnId = columnId;
        this.filterId = filterId;
        this.label = label;
    }

    public abstract FilterType getType();

    public abstract JSONObject toJSONObject();

    public static BaseFilter negate(BaseFilter filter) {
        switch (filter.getType()) {
            case TOP_BOTTOM: {
                return TopBottomFilter.negate((TopBottomFilter)filter);
            }
            case NUMERIC: {
                return NumericFilter.negate((NumericFilter)filter);
            }
            case NUMERICRANGE: {
                return NumericRangeFilter.negate((NumericRangeFilter)filter);
            }
            case INCLUSION_EXCLUSION: {
                return InclusionExclusionFilter.negate((InclusionExclusionFilter)filter);
            }
            case GENERIC: {
                return GenericFilter.negate((GenericFilter)filter);
            }
            case COMPOSITE: {
                return CompositeFilter.negate((CompositeFilter)filter);
            }
        }
        return null;
    }

    public TopBottomFilter toTopBottomFilter() throws FilterTypeConversionException {
        if (this.getType() != FilterType.TOP_BOTTOM) {
            throw new FilterTypeConversionException(this.errorMsg("Top/Bottom"));
        }
        return (TopBottomFilter)this;
    }

    public CompositeFilter toCompositeFilter() throws FilterTypeConversionException {
        if (this.getType() != FilterType.COMPOSITE) {
            throw new FilterTypeConversionException(this.errorMsg("Composite"));
        }
        return (CompositeFilter)this;
    }

    public GenericFilter toGenericFilter() throws FilterTypeConversionException {
        if (this.getType() != FilterType.GENERIC) {
            throw new FilterTypeConversionException(this.errorMsg("Generic"));
        }
        return (GenericFilter)this;
    }

    public NumericRangeFilter toNumericRangeFilter() throws FilterTypeConversionException {
        if (this.getType() != FilterType.NUMERICRANGE) {
            throw new FilterTypeConversionException(this.errorMsg("NumericRange"));
        }
        return (NumericRangeFilter)this;
    }

    public NumericFilter toNumericFilter() throws FilterTypeConversionException {
        if (this.getType() != FilterType.NUMERIC) {
            throw new FilterTypeConversionException(this.errorMsg("Numeric"));
        }
        return (NumericFilter)this;
    }

    public InclusionExclusionFilter toInclusionExclusionFilter() throws FilterTypeConversionException {
        if (this.getType() != FilterType.INCLUSION_EXCLUSION) {
            throw new FilterTypeConversionException(this.errorMsg("InclusionExclusion"));
        }
        return (InclusionExclusionFilter)this;
    }

    public String errorMsg(String toFilterType) {
        return "Cannot convert " + this.getType().name() + " to " + toFilterType + " filter.";
    }

    public String getColumnId() {
        return this.columnId;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void setFilterId(String fId) {
        this.filterId = fId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void toJSONObject(JSONObject json) {
        json.put((Object)"columnId", (Object)this.columnId);
        this.putIfNotNull(json, "filterId", this.filterId);
        this.putIfNotNull(json, "label", this.label);
        json.put((Object)"type", (Object)this.getType().name());
    }

    protected void putIfNotNull(JSONObject json, String key, String value) {
        if (value != null) {
            json.put((Object)key, (Object)value);
        }
    }

    public void fromJSON(JsonNode node) {
        JsonNode labelNode;
        JsonNode filterIdNode = node.get("filterId");
        if (filterIdNode != null) {
            this.setFilterId(filterIdNode.asText());
        }
        if ((labelNode = node.get("label")) != null) {
            this.setLabel(labelNode.asText());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseFilter)) {
            return false;
        }
        BaseFilter that = (BaseFilter)o;
        return Objects.equals(this.getColumnId(), that.getColumnId()) && Objects.equals(this.getFilterId(), that.getFilterId()) && Objects.equals(this.getLabel(), that.getLabel());
    }

    public int hashCode() {
        return Objects.hash(this.getColumnId(), this.getFilterId(), this.getLabel());
    }
}

