/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.modifiers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterAggregation;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.NumericRangeValue;
import java.util.Objects;

public class NumericRangeFilter
extends BaseFilter {
    private NumericRangeValue lowValue;
    private NumericRangeValue highValue;
    private boolean invertFlag = false;
    private FilterAggregation filterAggregation;

    public boolean isInvertFlag() {
        return this.invertFlag;
    }

    @JsonCreator
    public NumericRangeFilter(@JsonProperty(value="columnId") String columnId, @JsonProperty(value="filterId") String filterId, @JsonProperty(value="label") String label, @JsonProperty(value="lowValue") NumericRangeValue lowValue, @JsonProperty(value="highValue") NumericRangeValue highValue, @JsonProperty(value="invert") boolean invert, @JsonProperty(value="filterAggregation") FilterAggregation filterAggregation) {
        super(columnId, filterId, label);
        this.lowValue = lowValue;
        this.highValue = highValue;
        this.invertFlag = invert;
        if (filterAggregation != null) {
            this.filterAggregation = filterAggregation;
        }
    }

    public NumericRangeFilter(NumericRangeFilter source) {
        super(source.getColumnId(), source.getFilterId(), source.getLabel());
        this.lowValue = source.getLowValue();
        this.highValue = source.getHighValue();
        this.invertFlag = source.getInvertFlag();
        FilterAggregation filterAggregation = source.getFilterAggregation();
        if (filterAggregation != null) {
            this.filterAggregation = filterAggregation;
        }
    }

    public static NumericRangeFilter negate(NumericRangeFilter source) {
        NumericRangeFilter filter = new NumericRangeFilter(source);
        filter.setInvertFlag(!source.getInvertFlag());
        return filter;
    }

    public NumericRangeValue getLowValue() {
        return this.lowValue;
    }

    public void setLowValue(NumericRangeValue low) {
        this.lowValue = low;
    }

    public NumericRangeValue getHighValue() {
        return this.highValue;
    }

    public void setHighValue(NumericRangeValue high) {
        this.highValue = high;
    }

    public boolean getInvertFlag() {
        return this.invertFlag;
    }

    public void setInvertFlag(boolean invert) {
        this.invertFlag = invert;
    }

    public FilterAggregation getFilterAggregation() {
        return this.filterAggregation;
    }

    public void setFilterAggregation(FilterAggregation filterAggregation) {
        this.filterAggregation = filterAggregation;
    }

    @Override
    public FilterType getType() {
        return FilterType.NUMERICRANGE;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        super.toJSONObject(obj);
        obj.put((Object)"lowValue", (Object)this.getLowValue().toJSONObject());
        obj.put((Object)"highValue", (Object)this.getHighValue().toJSONObject());
        obj.put((Object)"invertFlag", (Object)this.getInvertFlag());
        if (this.getFilterAggregation() != null) {
            obj.put((Object)"preOrPost", (Object)this.getFilterAggregation().getPreOrPostAggregation().name());
            obj.put((Object)"aggregationType", (Object)this.getFilterAggregation().getAggregationType().name());
        }
        return obj;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumericRangeFilter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NumericRangeFilter that = (NumericRangeFilter)o;
        return this.isInvertFlag() == that.isInvertFlag() && this.getLowValue().equals(that.getLowValue()) && this.getHighValue().equals(that.getHighValue()) && this.getFilterAggregation().equals(that.getFilterAggregation());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLowValue(), this.getHighValue(), this.isInvertFlag(), this.getFilterAggregation());
    }
}

