/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.rest;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.utils.JoinGraph;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleRestClient
extends RestClient {
    public static final String MODULE_URI = "com.ibm.smarts.common.rest.moduleUri";
    public static final String MODULE_JOIN_GRAPH = "/bi/v1/metadata/modules/%s/joingraph";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleRestClient.class);

    public ModuleRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        this(rccf, requestContext, uri, null);
    }

    public ModuleRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri, Map<String, List<String>> headers) {
        super(rccf, requestContext, uri, headers);
    }

    public CompletableFuture<Module> getModuleAsync(String requestUri) {
        String request = requestUri;
        if (request.startsWith(this.uri)) {
            request = request.substring(this.uri.length());
        }
        return this.maybeGetAsync(request).thenApply(json -> {
            try {
                return json != null ? Module.fromJSON((JSONObject)JSONObject.parse((String)json), (ObjectFactory)new ObjectFactory()) : null;
            }
            catch (IOException e) {
                throw new InternalException("Could not parse module  call-context: " + (Object)((Object)this), new Object[]{e});
            }
        });
    }

    public Module getModule(String uri) {
        CompletableFuture<Module> future = this.getModuleAsync(uri);
        return (Module)this.get(future);
    }

    public CompletableFuture<JoinGraph> getModuleJoinGraphAsync(String moduleId) {
        String path = String.format(MODULE_JOIN_GRAPH, moduleId);
        Instant startJoinGraph = Instant.now();
        return this.getAsync(path).thenApply(json -> {
            LOGGER.info(String.format("Retrieving the join graph takes %s ms", Duration.between(startJoinGraph, Instant.now()).toMillis()));
            Instant startJoinGraphParsing = Instant.now();
            JoinGraph joinGraph = this.parseJoinGraph((String)json);
            LOGGER.info(String.format("Parsing the join graph takes %s ms", Duration.between(startJoinGraphParsing, Instant.now()).toMillis()));
            return joinGraph;
        });
    }

    public JoinGraph getModuleJoinGraph(String moduleId) {
        CompletableFuture<JoinGraph> future = this.getModuleJoinGraphAsync(moduleId);
        return (JoinGraph)this.get(future);
    }

    private JoinGraph parseJoinGraph(String json) {
        try {
            return new JoinGraph(JSONObject.parse((String)json));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Failed to parse response JSON into JoinGraph: " + json, new Object[0]);
        }
    }
}

