/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import java.util.Arrays;
import java.util.List;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgreement;
import simplenlg.features.Person;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentCategory;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.PhraseElement;
import simplenlg.framework.StringElement;
import simplenlg.framework.WordElement;
import simplenlg.lexicon.Lexicon;
import simplenlg.phrasespec.AdjPhraseSpec;
import simplenlg.phrasespec.AdvPhraseSpec;
import simplenlg.phrasespec.NPPhraseSpec;
import simplenlg.phrasespec.PPPhraseSpec;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.phrasespec.VPPhraseSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLGFactory {
    private Lexicon lexicon;
    private static final List<String> PRONOUNS = Arrays.asList("I", "you", "he", "she", "it", "me", "you", "him", "her", "it", "myself", "yourself", "himself", "herself", "itself", "mine", "yours", "his", "hers", "its", "we", "you", "they", "they", "they", "us", "you", "them", "them", "them", "ourselves", "yourselves", "themselves", "themselves", "themselves", "ours", "yours", "theirs", "theirs", "theirs", "there");
    private static final List<String> FIRST_PRONOUNS = Arrays.asList("I", "me", "myself", "we", "us", "ourselves", "mine", "my", "ours", "our");
    private static final List<String> SECOND_PRONOUNS = Arrays.asList("you", "yourself", "yourselves", "yours", "your");
    private static final List<String> REFLEXIVE_PRONOUNS = Arrays.asList("myself", "yourself", "himself", "herself", "itself", "ourselves", "yourselves", "themselves");
    private static final List<String> MASCULINE_PRONOUNS = Arrays.asList("he", "him", "himself", "his");
    private static final List<String> FEMININE_PRONOUNS = Arrays.asList("she", "her", "herself", "hers");
    private static final List<String> POSSESSIVE_PRONOUNS = Arrays.asList("mine", "ours", "yours", "his", "hers", "its", "theirs", "my", "our", "your", "her", "their");
    private static final List<String> PLURAL_PRONOUNS = Arrays.asList("we", "us", "ourselves", "ours", "our", "they", "them", "theirs", "their");
    private static final List<String> EITHER_NUMBER_PRONOUNS = Arrays.asList("there");
    private static final List<String> EXPLETIVE_PRONOUNS = Arrays.asList("there");
    private static final String WORD_REGEX = "\\w*";

    public NLGFactory() {
        this(null);
    }

    public NLGFactory(Lexicon newLexicon) {
        this.setLexicon(newLexicon);
    }

    public void setLexicon(Lexicon newLexicon) {
        this.lexicon = newLexicon;
    }

    public NLGElement createWord(Object word, LexicalCategory category) {
        NLGElement wordElement = null;
        if (word instanceof NLGElement) {
            wordElement = (NLGElement)word;
        } else if (word instanceof String && this.lexicon != null) {
            wordElement = this.lexicon.lookupWord((String)word, category);
            if (PRONOUNS.contains(word)) {
                this.setPronounFeatures(wordElement, (String)word);
            }
        }
        return wordElement;
    }

    public NLGElement createInflectedWord(Object word, LexicalCategory category) {
        NLGElement inflElement = null;
        if (word instanceof WordElement) {
            inflElement = new InflectedWordElement((WordElement)word);
        } else if (word instanceof String) {
            NLGElement baseword = this.createWord((String)word, category);
            inflElement = baseword != null && baseword instanceof WordElement ? new InflectedWordElement((WordElement)baseword) : new InflectedWordElement((String)word, category);
        } else if (word instanceof NLGElement) {
            inflElement = (NLGElement)word;
        }
        return inflElement;
    }

    private void setPronounFeatures(NLGElement wordElement, String word) {
        wordElement.setCategory(LexicalCategory.PRONOUN);
        if (FIRST_PRONOUNS.contains(word)) {
            wordElement.setFeature("person", (Object)Person.FIRST);
        } else if (SECOND_PRONOUNS.contains(word)) {
            wordElement.setFeature("person", (Object)Person.SECOND);
            if ("yourself".equalsIgnoreCase(word)) {
                wordElement.setPlural(false);
            } else if ("yourselves".equalsIgnoreCase(word)) {
                wordElement.setPlural(true);
            } else {
                wordElement.setFeature("number", (Object)NumberAgreement.BOTH);
            }
        } else {
            wordElement.setFeature("person", (Object)Person.THIRD);
        }
        if (REFLEXIVE_PRONOUNS.contains(word)) {
            wordElement.setFeature("reflexive", true);
        } else {
            wordElement.setFeature("reflexive", false);
        }
        if (MASCULINE_PRONOUNS.contains(word)) {
            wordElement.setFeature("gender", (Object)Gender.MASCULINE);
        } else if (FEMININE_PRONOUNS.contains(word)) {
            wordElement.setFeature("gender", (Object)Gender.FEMININE);
        } else {
            wordElement.setFeature("gender", (Object)Gender.NEUTER);
        }
        if (POSSESSIVE_PRONOUNS.contains(word)) {
            wordElement.setFeature("possessive", true);
        } else {
            wordElement.setFeature("possessive", false);
        }
        if (PLURAL_PRONOUNS.contains(word) && !SECOND_PRONOUNS.contains(word)) {
            wordElement.setPlural(true);
        } else if (!EITHER_NUMBER_PRONOUNS.contains(word)) {
            wordElement.setPlural(false);
        }
        if (EXPLETIVE_PRONOUNS.contains(word)) {
            wordElement.setFeature("non_morph", true);
            wordElement.setFeature("expletive_subject", true);
        }
    }

    private void doLexiconLookUp(LexicalCategory category, String word, NLGElement wordElement) {
        WordElement baseWord = null;
        if (LexicalCategory.NOUN.equals(category) && this.lexicon.hasWord(word, LexicalCategory.PRONOUN)) {
            baseWord = this.lexicon.lookupWord(word, LexicalCategory.PRONOUN);
            if (baseWord != null) {
                wordElement.setFeature("base_word", baseWord);
                wordElement.setCategory(LexicalCategory.PRONOUN);
                if (!PRONOUNS.contains(word)) {
                    wordElement.setFeature("non_morph", true);
                }
            }
        } else {
            baseWord = this.lexicon.lookupWord(word, category);
            wordElement.setFeature("base_word", baseWord);
        }
    }

    public PPPhraseSpec createPrepositionPhrase() {
        return this.createPrepositionPhrase(null, null);
    }

    public PPPhraseSpec createPrepositionPhrase(Object preposition) {
        return this.createPrepositionPhrase(preposition, null);
    }

    public PPPhraseSpec createPrepositionPhrase(Object preposition, Object complement) {
        PPPhraseSpec phraseElement = new PPPhraseSpec(this);
        NLGElement prepositionalElement = this.createNLGElement(preposition, LexicalCategory.PREPOSITION);
        this.setPhraseHead(phraseElement, prepositionalElement);
        if (complement != null) {
            this.setComplement(phraseElement, complement);
        }
        return phraseElement;
    }

    private void setComplement(PhraseElement phraseElement, Object complement) {
        NLGElement complementElement = this.createNLGElement(complement);
        phraseElement.addComplement(complementElement);
    }

    public NLGElement createNLGElement(Object element, LexicalCategory category) {
        if (element == null) {
            return null;
        }
        if (element instanceof InflectedWordElement) {
            return ((InflectedWordElement)element).getBaseWord();
        }
        if (element instanceof StringElement) {
            if (this.stringIsWord(((StringElement)element).getRealisation(), category)) {
                return this.createWord(((StringElement)element).getRealisation(), category);
            }
            return (StringElement)element;
        }
        if (element instanceof NLGElement) {
            return (NLGElement)element;
        }
        if (element instanceof String) {
            if (this.stringIsWord((String)element, category)) {
                return this.createWord(element, category);
            }
            return new StringElement((String)element);
        }
        throw new IllegalArgumentException(element.toString() + " is not a valid type");
    }

    private boolean stringIsWord(String string, LexicalCategory category) {
        return this.lexicon != null && (this.lexicon.hasWord(string, category) || PRONOUNS.contains(string) || string.matches(WORD_REGEX));
    }

    public NLGElement createNLGElement(Object element) {
        return this.createNLGElement(element, LexicalCategory.ANY);
    }

    public NPPhraseSpec createNounPhrase() {
        return this.createNounPhrase(null, null);
    }

    public NPPhraseSpec createNounPhrase(Object noun) {
        if (noun instanceof NPPhraseSpec) {
            return (NPPhraseSpec)noun;
        }
        return this.createNounPhrase(null, noun);
    }

    public NPPhraseSpec createNounPhrase(Object specifier, Object noun) {
        if (noun instanceof NPPhraseSpec) {
            return (NPPhraseSpec)noun;
        }
        NPPhraseSpec phraseElement = new NPPhraseSpec(this);
        NLGElement nounElement = this.createNLGElement(noun, LexicalCategory.NOUN);
        this.setPhraseHead(phraseElement, nounElement);
        if (specifier != null) {
            phraseElement.setSpecifier(specifier);
        }
        return phraseElement;
    }

    private void setPhraseHead(PhraseElement phraseElement, NLGElement headElement) {
        if (headElement != null) {
            phraseElement.setHead(headElement);
            headElement.setParent(phraseElement);
        }
    }

    public AdjPhraseSpec createAdjectivePhrase() {
        return this.createAdjectivePhrase(null);
    }

    public AdjPhraseSpec createAdjectivePhrase(Object adjective) {
        AdjPhraseSpec phraseElement = new AdjPhraseSpec(this);
        NLGElement adjectiveElement = this.createNLGElement(adjective, LexicalCategory.ADJECTIVE);
        this.setPhraseHead(phraseElement, adjectiveElement);
        return phraseElement;
    }

    public VPPhraseSpec createVerbPhrase() {
        return this.createVerbPhrase(null);
    }

    public VPPhraseSpec createVerbPhrase(Object verb) {
        VPPhraseSpec phraseElement = new VPPhraseSpec(this);
        phraseElement.setVerb(verb);
        this.setPhraseHead(phraseElement, phraseElement.getVerb());
        return phraseElement;
    }

    public AdvPhraseSpec createAdverbPhrase() {
        return this.createAdverbPhrase(null);
    }

    public AdvPhraseSpec createAdverbPhrase(String adverb) {
        AdvPhraseSpec phraseElement = new AdvPhraseSpec(this);
        NLGElement adverbElement = this.createNLGElement(adverb, LexicalCategory.ADVERB);
        this.setPhraseHead(phraseElement, adverbElement);
        return phraseElement;
    }

    public SPhraseSpec createClause() {
        return this.createClause(null, null, null);
    }

    public SPhraseSpec createClause(Object subject, Object verb) {
        return this.createClause(subject, verb, null);
    }

    public SPhraseSpec createClause(Object subject, Object verb, Object directObject) {
        SPhraseSpec phraseElement = new SPhraseSpec(this);
        if (verb != null) {
            if (verb instanceof PhraseElement) {
                phraseElement.setVerbPhrase((PhraseElement)verb);
            } else {
                phraseElement.setVerb(verb);
            }
        }
        if (subject != null) {
            phraseElement.setSubject(subject);
        }
        if (directObject != null) {
            phraseElement.setObject(directObject);
        }
        return phraseElement;
    }

    public NLGElement createStringElement() {
        return this.createStringElement(null);
    }

    public NLGElement createStringElement(String text) {
        return new StringElement(text);
    }

    public CoordinatedPhraseElement createCoordinatedPhrase() {
        return new CoordinatedPhraseElement();
    }

    public CoordinatedPhraseElement createCoordinatedPhrase(Object coord1, Object coord2) {
        return new CoordinatedPhraseElement(coord1, coord2);
    }

    public DocumentElement createDocument() {
        return this.createDocument(null);
    }

    public DocumentElement createDocument(String title) {
        return new DocumentElement(DocumentCategory.DOCUMENT, title);
    }

    public DocumentElement createDocument(String title, List<DocumentElement> components) {
        DocumentElement document = new DocumentElement(DocumentCategory.DOCUMENT, title);
        if (components != null) {
            document.addComponents(components);
        }
        return document;
    }

    public DocumentElement createDocument(String title, NLGElement component) {
        DocumentElement element = new DocumentElement(DocumentCategory.DOCUMENT, title);
        if (component != null) {
            element.addComponent(component);
        }
        return element;
    }

    public DocumentElement createList() {
        return new DocumentElement(DocumentCategory.LIST, null);
    }

    public DocumentElement createList(List<DocumentElement> textComponents) {
        DocumentElement list = new DocumentElement(DocumentCategory.LIST, null);
        list.addComponents(textComponents);
        return list;
    }

    public DocumentElement createList(NLGElement component) {
        DocumentElement list = new DocumentElement(DocumentCategory.LIST, null);
        list.addComponent(component);
        return list;
    }

    public DocumentElement createEnumeratedList() {
        return new DocumentElement(DocumentCategory.ENUMERATED_LIST, null);
    }

    public DocumentElement createEnumeratedList(List<DocumentElement> textComponents) {
        DocumentElement list = new DocumentElement(DocumentCategory.ENUMERATED_LIST, null);
        list.addComponents(textComponents);
        return list;
    }

    public DocumentElement createEnumeratedList(NLGElement component) {
        DocumentElement list = new DocumentElement(DocumentCategory.ENUMERATED_LIST, null);
        list.addComponent(component);
        return list;
    }

    public DocumentElement createListItem() {
        return new DocumentElement(DocumentCategory.LIST_ITEM, null);
    }

    public DocumentElement createListItem(NLGElement component) {
        DocumentElement listItem = new DocumentElement(DocumentCategory.LIST_ITEM, null);
        listItem.addComponent(component);
        return listItem;
    }

    public DocumentElement createParagraph() {
        return new DocumentElement(DocumentCategory.PARAGRAPH, null);
    }

    public DocumentElement createParagraph(List<DocumentElement> components) {
        DocumentElement paragraph = new DocumentElement(DocumentCategory.PARAGRAPH, null);
        if (components != null) {
            paragraph.addComponents(components);
        }
        return paragraph;
    }

    public DocumentElement createParagraph(NLGElement component) {
        DocumentElement paragraph = new DocumentElement(DocumentCategory.PARAGRAPH, null);
        if (component != null) {
            paragraph.addComponent(component);
        }
        return paragraph;
    }

    public DocumentElement createSection() {
        return new DocumentElement(DocumentCategory.SECTION, null);
    }

    public DocumentElement createSection(String title) {
        return new DocumentElement(DocumentCategory.SECTION, title);
    }

    public DocumentElement createSection(String title, List<DocumentElement> components) {
        DocumentElement section = new DocumentElement(DocumentCategory.SECTION, title);
        if (components != null) {
            section.addComponents(components);
        }
        return section;
    }

    public DocumentElement createSection(String title, NLGElement component) {
        DocumentElement section = new DocumentElement(DocumentCategory.SECTION, title);
        if (component != null) {
            section.addComponent(component);
        }
        return section;
    }

    public DocumentElement createSentence() {
        return new DocumentElement(DocumentCategory.SENTENCE, null);
    }

    public DocumentElement createSentence(List<NLGElement> components) {
        DocumentElement sentence = new DocumentElement(DocumentCategory.SENTENCE, null);
        sentence.addComponents(components);
        return sentence;
    }

    public DocumentElement createSentence(NLGElement components) {
        DocumentElement sentence = new DocumentElement(DocumentCategory.SENTENCE, null);
        sentence.addComponent(components);
        return sentence;
    }

    public DocumentElement createSentence(Object subject, Object verb) {
        return this.createSentence(subject, verb, null);
    }

    public DocumentElement createSentence(Object subject, Object verb, Object complement) {
        DocumentElement sentence = new DocumentElement(DocumentCategory.SENTENCE, null);
        sentence.addComponent(this.createClause(subject, verb, complement));
        return sentence;
    }

    public DocumentElement createSentence(String cannedSentence) {
        DocumentElement sentence = new DocumentElement(DocumentCategory.SENTENCE, null);
        if (cannedSentence != null) {
            sentence.addComponent(this.createStringElement(cannedSentence));
        }
        return sentence;
    }
}

