/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.mq.impl;

import com.ibm.smarts.core.api.Handlers;
import com.ibm.smarts.core.exceptions.ClientException;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.exceptions.ServiceException;
import com.ibm.smarts.core.mq.MessageConsumer;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.mq.QueueId;
import com.ibm.smarts.core.mq.TypedMessageConsumer;
import com.ibm.smarts.core.mq.impl.TypedMessageConsumerImpl;
import com.ibm.smarts.core.mq.impl.WrappedJsonMessage;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.MessageQueueingMetrics;
import com.ibm.smarts.core.util.Request;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.RequestContextDecorator;
import com.ibm.smarts.core.util.RequestJsonHelper;
import com.ibm.smarts.core.util.ToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRawMessageConsumer
implements Handlers {
    private final QueueId queueId;
    private final MessageConsumer consumer;
    private final RequestContextDecorator requestContextDecorator;
    private final MessageQueueingMetrics.ExchangeMetrics metrics;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRawMessageConsumer.class);

    public AbstractRawMessageConsumer(RequestContextDecorator requestContextDecorator, QueueId queueId, MessageConsumer consumer, MessageQueueingMetrics.ExchangeMetrics metrics) {
        this.consumer = consumer;
        this.queueId = queueId;
        this.requestContextDecorator = requestContextDecorator;
        this.metrics = metrics;
    }

    public <T> AbstractRawMessageConsumer(RequestContextDecorator requestContextDecorator, QueueId queueId, TypedMessageConsumer<T> typedConsumer, MessageQueueingMetrics.ExchangeMetrics metrics) {
        this.consumer = new TypedMessageConsumerImpl<T>(typedConsumer);
        this.queueId = queueId;
        this.requestContextDecorator = requestContextDecorator;
        this.metrics = metrics;
    }

    protected abstract MessageProducerProvider getProducerProviderFor(RequestContext var1);

    public void handleJson(String wrappedJson) {
        WrappedJsonMessage wrappedMsg = JsonParserHelper.fromJson(wrappedJson, WrappedJsonMessage.class);
        long writtenToQueueTs = wrappedMsg.getWriteToQueueTimestamp();
        long writtenToQueueNanos = wrappedMsg.getWriteToQueueNanos();
        Request req = RequestJsonHelper.fromJson(wrappedMsg.request);
        RequestContext rc = new RequestContext(req);
        rc.requestMetrics.setLabel(this.queueId.queueName);
        if (this.requestContextDecorator != null) {
            this.requestContextDecorator.decorate(rc);
        }
        MessageProducerProvider producerProvider = this.getProducerProviderFor(rc);
        this.metrics.metrics.metrics.queued.durationEndNow(writtenToQueueNanos);
        this.handle(writtenToQueueTs, rc, wrappedMsg.json, () -> {
            MessageQueueingMetrics.QueueMetrics qMetrics = this.metrics.forQueue(this.queueId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Consumer " + this.consumer + " receiving message " + ToString.valueString(AbstractRawMessageConsumer.trimJson(wrappedMsg.json)));
            }
            long workStartNanos = qMetrics.metrics.working.durationStart();
            try {
                this.consumer.receiveMessage(rc, producerProvider, wrappedMsg.json);
            }
            finally {
                qMetrics.metrics.working.durationEndNow(workStartNanos);
            }
        });
    }

    private void handle(long createdTs, RequestContext ctx, String wrappedJson, Runnable runnable) {
        Handlers.WrappedRunnable wrapped = this.wrap(createdTs, ctx, runnable);
        LOGGER.debug("Call=" + wrapped.callId + " Consuming from queue '" + this.queueId + "' message=" + AbstractRawMessageConsumer.trimJson(wrappedJson));
        try {
            try {
                wrapped.run();
            }
            catch (ServiceException serex) {
                throw serex;
            }
            catch (Throwable ex) {
                throw new InternalException(ex, "handler=" + this.getClass().getName(), new Object[0]);
            }
        }
        catch (ClientException cex) {
            throw cex;
        }
        catch (InternalException svcEx) {
            LOGGER.error("call=" + wrapped.callId, (Throwable)svcEx);
            throw svcEx;
        }
    }

    private static String trimJson(String s) {
        return AbstractRawMessageConsumer.trimTo(s, 2000);
    }

    private static String trimTo(String s, int maxSize) {
        if (s == null) {
            return s;
        }
        if (s.length() <= maxSize) {
            return s;
        }
        return s.substring(0, maxSize) + "...";
    }
}

