/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public final class FileUtils {
    static final String MSG_NULL_PARAM = "<null> or zero-length parameter";
    static final String MSG_FILE_NOT_EXISTS = "File does not exist";
    static final String UTF_8 = "UTF-8";
    public static final int ENSURE_EXISTS = 1;
    public static final int ENSURE_IS_DIRECTORY_IF_EXISTS = 8;
    public static final int ENSURE_IS_FILE_IF_EXISTS = 16;
    public static final int ENSURE_IS_READABLE_FILE = 32;
    public static final int ENSURE_IS_WRITABLE_FILE_IF_EXISTS = 64;
    public static final int FLAG_NOT_EXIST = 1;
    public static final int FLAG_NOT_DIRECTORY = 2;
    public static final int FLAG_NOT_FILE = 4;
    public static final int FLAG_NOT_READABLE = 8;
    public static final int FLAG_NOT_WRITABLE = 16;

    private FileUtils() {
    }

    public static File check(String sFilepath, int flags) {
        File f = new File(sFilepath);
        FileUtils.check(f, flags);
        return f;
    }

    public static void check(File f, int flags) {
        int nResult = 0;
        if (f.exists()) {
            if (f.isFile()) {
                if (FileUtils.checkFlags(flags, 8)) {
                    nResult |= 2;
                }
                if (FileUtils.checkFlags(flags, 32) && !f.canRead()) {
                    nResult |= 8;
                }
                if (FileUtils.checkFlags(flags, 64) && !f.canWrite()) {
                    nResult |= 0x10;
                }
            } else {
                if (FileUtils.checkFlags(flags, 16)) {
                    nResult |= 1;
                }
                if (FileUtils.checkFlags(flags, 32)) {
                    nResult |= 8;
                }
            }
        } else if (FileUtils.checkFlags(flags, 1)) {
            nResult |= 1;
        }
        if (nResult != 0) {
            String sNicePath = FileUtils.getNicePath(f);
            throw new FileCheckException(nResult, sNicePath);
        }
    }

    private static boolean checkFlags(int var, int flags) {
        return (var & flags) != 0;
    }

    public static boolean isDirectory(String sPath) {
        boolean bIsDirectory = false;
        File f = new File(sPath);
        if (f.exists() && f.isDirectory()) {
            bIsDirectory = true;
        }
        return bIsDirectory;
    }

    public static boolean isFile(String sPath) {
        boolean bIsFile = false;
        File f = new File(sPath);
        if (f.exists() && f.isFile()) {
            bIsFile = true;
        }
        return bIsFile;
    }

    public static String join(String sSegment1, String sSegment2) {
        String[] vSegments = new String[]{sSegment1, sSegment2};
        return FileUtils.join(vSegments);
    }

    public static String join(String sSegment1, String sSegment2, String sSegment3) {
        String[] vSegments = new String[]{sSegment1, sSegment2, sSegment3};
        return FileUtils.join(vSegments);
    }

    public static String join(String[] vSegments) {
        String sRet;
        if (vSegments.length == 0) {
            sRet = "";
        } else if (vSegments.length == 1) {
            sRet = vSegments[0];
        } else {
            StringBuffer sb = new StringBuffer(500);
            try {
                int nMax = vSegments.length - 1;
                for (int i = 0; i < nMax; ++i) {
                    String sSegment = vSegments[i];
                    sb.append(sSegment);
                    sb.append(File.separator);
                }
                sb.append(vSegments[vSegments.length - 1]);
                sRet = sb.toString();
            }
            catch (Exception ex) {
                throw new RuntimeException("Joining path segments=[" + StringUtils.join(vSegments) + "]", ex);
            }
        }
        return sRet;
    }

    public static String getNicePath(String sPath) {
        String sRet;
        try {
            File f = new File(sPath);
            sRet = FileUtils.getNicePath(f);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not generate nice path for '" + sPath + "'", ex);
        }
        return sRet;
    }

    public static String getNicePath(File f) {
        String sRet;
        try {
            sRet = f.getCanonicalPath();
        }
        catch (IOException ex) {
            sRet = f.getAbsolutePath();
        }
        return sRet;
    }

    public static long touch(String sFilepathToTouch) {
        return FileUtils.touch(sFilepathToTouch, null);
    }

    public static long touch(String sFilepathToTouch, String sBeNewerThanPath) {
        long nRet = 0L;
        try {
            long nBeNewerThanMillis = 0L;
            if (sBeNewerThanPath != null && FileUtils.exists(sBeNewerThanPath)) {
                File fNewerThan = new File(sBeNewerThanPath);
                nBeNewerThanMillis = fNewerThan.lastModified();
            }
            File f = new File(sFilepathToTouch);
            nRet = FileUtils.touch(f, nBeNewerThanMillis);
        }
        catch (Exception ex) {
            FileUtils.throwFileException(ex, sFilepathToTouch, "Failed to 'touch' file");
        }
        return nRet;
    }

    public static long touch(File fToTouch) {
        return FileUtils.touch(fToTouch, 0L);
    }

    public static long touch(File fToTouch, long nBeNewerThanMillis) {
        long nNewModTime = 0L;
        try {
            long nLastModTime;
            if (fToTouch == null) {
                throw new RuntimeException(MSG_NULL_PARAM);
            }
            if (!fToTouch.exists()) {
                throw new RuntimeException(MSG_FILE_NOT_EXISTS);
            }
            long nCurrentMillis = System.currentTimeMillis();
            nNewModTime = nCurrentMillis > (nLastModTime = fToTouch.lastModified()) ? nCurrentMillis : nLastModTime + 1L;
            if (nNewModTime <= nBeNewerThanMillis) {
                nNewModTime = nBeNewerThanMillis + 1L;
            }
            fToTouch.setLastModified(nNewModTime);
        }
        catch (Exception ex) {
            String sPath = null;
            if (fToTouch != null) {
                try {
                    sPath = FileUtils.getNicePath(fToTouch);
                }
                catch (Exception nLastModTime) {
                    // empty catch block
                }
                if (sPath == null) {
                    sPath = fToTouch.getAbsolutePath();
                }
            }
            String sMsg = "Failed to 'touch' file '" + sPath + "'";
            throw new RuntimeException(sMsg, ex);
        }
        return nNewModTime;
    }

    public static boolean exists(String sFilepath) {
        return new File(sFilepath).exists();
    }

    public static List<String> readLines(String sFilepath) {
        File f = FileUtils.check(sFilepath, 33);
        ArrayList<String> vLines = new ArrayList<String>();
        try (FileInputStream fis = new FileInputStream(f);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, UTF_8);
             LineNumberReader lnr = new LineNumberReader(isr);){
            String sLine;
            while ((sLine = lnr.readLine()) != null) {
                vLines.add(sLine);
            }
        }
        catch (IOException ex) {
            FileUtils.throwFileException(ex, sFilepath, "reading lines from file");
        }
        return vLines;
    }

    public static String getStringData(String sFilepath) {
        byte[] bytes = FileUtils.getBytes(sFilepath, true);
        String sRet = null;
        try {
            sRet = new String(bytes, UTF_8);
        }
        catch (Exception ex) {
            FileUtils.throwFileException(ex, sFilepath, "creating string from bytes in file");
        }
        return sRet;
    }

    public static byte[] getBytes(String sFilepath) {
        return FileUtils.getBytes(sFilepath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(String sFilepath, boolean bFlushUTF8Marker) {
        File f = FileUtils.check(sFilepath, 33);
        byte[] baRet = null;
        FileInputStream fis = null;
        try {
            long nFileSize = f.length();
            fis = new FileInputStream(f);
            if (bFlushUTF8Marker) {
                byte[] baMarker = new byte[3];
                int nMarker = fis.read(baMarker);
                if (nMarker == 3 && baMarker[0] == -17 && baMarker[1] == -69 && baMarker[2] == -65) {
                    nFileSize -= 3L;
                } else {
                    fis.close();
                    fis = new FileInputStream(f);
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)nFileSize);
            byte[] bytes = new byte[8192];
            int nReadCount = 0;
            while ((nReadCount = fis.read(bytes)) != -1) {
                baos.write(bytes, 0, nReadCount);
            }
            baRet = baos.toByteArray();
        }
        catch (Exception ex) {
            FileUtils.throwFileException(ex, sFilepath, "reading bytes from file");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex) {
                    FileUtils.throwFileException(ex, sFilepath, "closing input stream");
                }
            }
        }
        return baRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String sFilepath, byte[] bytes) {
        File f = FileUtils.check(sFilepath, 80);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            fos.write(bytes);
        }
        catch (Exception ex) {
            FileUtils.throwFileException(ex, sFilepath, "writing bytes to file");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ex) {
                    FileUtils.throwFileException(ex, sFilepath, "closing input stream");
                }
            }
        }
    }

    public static void write(String sFilepath, String sData) {
        byte[] bytes = null;
        try {
            bytes = sData.getBytes(UTF_8);
        }
        catch (Exception ex) {
            FileUtils.throwFileException(ex, sFilepath, "writing string to file");
        }
        FileUtils.write(sFilepath, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(String sFilepath, List<String> vLines) {
        File f = FileUtils.check(sFilepath, 80);
        FileOutputStream fos = null;
        try {
            byte[] baNewline = "\r\n".getBytes(UTF_8);
            fos = new FileOutputStream(f);
            for (String sLine : vLines) {
                byte[] bytes = sLine.getBytes(UTF_8);
                fos.write(bytes);
                fos.write(baNewline);
            }
        }
        catch (Exception ex) {
            FileUtils.throwFileException(ex, sFilepath, "writing lines to file");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ex) {
                    FileUtils.throwFileException(ex, sFilepath, "closing file writer");
                }
            }
        }
    }

    static void throwFileException(File f, String sMsg) {
        String sNicePath = FileUtils.getNicePath(f);
        FileUtils.throwFileException(sNicePath, sMsg);
    }

    static void throwFileException(String sFilepath, String sMsg) {
        FileUtils.throwFileException(null, sFilepath, sMsg);
    }

    static void throwFileException(Exception ex, String sFilepath, String sMsg) {
        String sNicePath = FileUtils.getNicePath(sFilepath);
        String sMsgOut = sMsg + ": '" + sNicePath + "'";
        throw new RuntimeException(sMsgOut, ex);
    }

    public static class FileCheckException
    extends RuntimeException {
        private int _flags = 0;
        private static final long serialVersionUID = 5302394473025497455L;

        FileCheckException(int flags, Throwable ex, String sFilepath) {
            super(FileCheckException.buildMessage(flags, sFilepath), ex);
            this._flags = flags;
        }

        FileCheckException(int flags, String sFilepath) {
            super(FileCheckException.buildMessage(flags, sFilepath));
            this._flags = flags;
        }

        public int getFlags() {
            return this._flags;
        }

        private static String buildMessage(int flags, String sFilepath) {
            Object[] vMsgs = new String[5];
            if (FileUtils.checkFlags(flags, 1)) {
                vMsgs[0] = FileUtils.MSG_FILE_NOT_EXISTS;
            }
            if (FileUtils.checkFlags(flags, 2)) {
                vMsgs[1] = "Path is not a directory";
            }
            if (FileUtils.checkFlags(flags, 4)) {
                vMsgs[2] = "Path is not a file";
            }
            if (FileUtils.checkFlags(flags, 8)) {
                vMsgs[3] = "File is not readable";
            }
            if (FileUtils.checkFlags(flags, 16)) {
                vMsgs[4] = "File is not writable";
            }
            String sNicePath = FileUtils.getNicePath(sFilepath);
            String sMsgs = StringUtils.join(vMsgs, true);
            String sRet = "File check: " + sMsgs + ": '" + sNicePath + "'";
            return sRet;
        }
    }
}

