/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.ToString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public class SerializedObject {
    public static final String JSON_TYPE = "json";
    public static final String BASE64_TYPE = "base64";
    public static final String CLASS_NAME_FIELD = "className";
    public static final String TYPE_FIELD = "type";
    public static final String ENCODED_FIELD = "encoded";
    public final String className;
    public final String type;
    public final String encoded;

    public SerializedObject(@JsonProperty(value="className") String className, @JsonProperty(value="type") String type, @JsonProperty(value="encoded") String encoded) {
        this.className = className;
        this.type = type;
        this.encoded = encoded;
    }

    public static SerializedObject from(Object obj) {
        if (obj == null) {
            return new SerializedObject(null, null, null);
        }
        String className = obj.getClass().getName();
        if (obj instanceof Serializable) {
            Serializable s = (Serializable)obj;
            String encoded = SerializedObject.serialize(s);
            return new SerializedObject(className, BASE64_TYPE, encoded);
        }
        String json = JsonParserHelper.toJson(obj);
        if (json != null) {
            return new SerializedObject(className, JSON_TYPE, json);
        }
        throw new InternalException("Unable to serialize object: " + obj, new Object[0]);
    }

    public String toString() {
        return ToString.with(this).field(CLASS_NAME_FIELD, this.className).field(TYPE_FIELD, this.type).field(ENCODED_FIELD, this.encoded).get();
    }

    @JsonIgnore
    public boolean isJsonEncoded() {
        return this.type != null && this.type.equals(JSON_TYPE);
    }

    @JsonIgnore
    public boolean isBase64Encoded() {
        return this.type != null && this.type.equals(BASE64_TYPE);
    }

    private static <T extends Serializable> String serialize(T item) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(item);
            objectOutputStream.close();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Could not base64 encode item: " + ToString.valueString(item), new Object[0]);
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        Base64.Encoder encoder = Base64.getEncoder();
        String ret = encoder.encodeToString(bytes);
        return ret;
    }

    private static <T extends Serializable> T deserialize(String data) {
        Base64.Decoder decoder = Base64.getDecoder();
        try {
            byte[] dataBytes = decoder.decode(data);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(dataBytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Serializable obj = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
            return (T)obj;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Could not base64 decode: " + data, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new InternalException((Throwable)e, "Could not find class", new Object[0]);
        }
    }

    public Object toInstance() {
        if (this.className == null) {
            return null;
        }
        if (this.isJsonEncoded()) {
            Class<?> klass;
            try {
                klass = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new InternalException((Throwable)e, "Could not create instance from " + this, new Object[0]);
            }
            Object obj = JsonParserHelper.fromJson(this.encoded, klass);
            return obj;
        }
        if (this.isBase64Encoded()) {
            Object obj = SerializedObject.deserialize(this.encoded);
            return obj;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.encoded == null ? 0 : this.encoded.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedObject other = (SerializedObject)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.encoded == null ? other.encoded != null : !this.encoded.equals(other.encoded)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

