/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.async.AsyncMetrics;
import com.ibm.smarts.core.util.AbstractMetrics;
import com.ibm.smarts.core.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class StoreMetrics
extends AbstractMetrics<StoreMetrics> {
    public final OpMetrics overall;
    public final OpMetrics getById;
    public final OpMetrics apply;
    public final OpMetrics update;
    public final OpMetrics store;
    public final OpMetrics delete;
    public final OpMetrics deleteByQuery;
    public final OpMetrics query;

    public StoreMetrics() {
        this(null, null, null, null, null, null, null, null);
    }

    public StoreMetrics(OpMetrics overall, OpMetrics getById, OpMetrics apply, OpMetrics update, OpMetrics store, OpMetrics delete, OpMetrics deleteByQuery, OpMetrics query) {
        this.overall = overall == null ? new OpMetrics(null) : overall;
        this.getById = StoreMetrics.maybe(this.overall, getById);
        this.apply = StoreMetrics.maybe(this.overall, apply);
        this.update = StoreMetrics.maybe(this.overall, update);
        this.store = StoreMetrics.maybe(this.overall, store);
        this.delete = StoreMetrics.maybe(this.overall, delete);
        this.deleteByQuery = StoreMetrics.maybe(this.overall, deleteByQuery);
        this.query = StoreMetrics.maybe(this.overall, query);
    }

    private static OpMetrics maybe(OpMetrics parent, OpMetrics om) {
        if (om != null) {
            return om;
        }
        return new OpMetrics(parent);
    }

    private OpMetrics[] allMetrics() {
        return new OpMetrics[]{this.getById, this.apply, this.update, this.store, this.delete, this.deleteByQuery, this.query};
    }

    @Override
    public boolean isTouched() {
        return StoreMetrics.isTouched((AbstractMetrics[])this.allMetrics());
    }

    @Override
    public long firstTouchNanos() {
        return StoreMetrics.firstTouchNanos((AbstractMetrics[])this.allMetrics());
    }

    @Override
    public long lastTouchNanos() {
        return StoreMetrics.lastTouchNanos((AbstractMetrics[])this.allMetrics());
    }

    public StoreMetrics combine(StoreMetrics other) {
        OpMetrics newOverall = this.overall.combine(null, other.overall);
        return new StoreMetrics(newOverall, this.getById.combine(newOverall, other.getById), this.apply.combine(newOverall, other.apply), this.update.combine(newOverall, other.update), this.store.combine(newOverall, other.store), this.delete.combine(newOverall, other.delete), this.deleteByQuery.combine(newOverall, other.deleteByQuery), this.query.combine(newOverall, other.query));
    }

    @Override
    public String toString(boolean pretty, int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("[StoreMetrics");
        if (this.getById.isTouched()) {
            sb.append(StoreMetrics.linePrefix(pretty, indent) + "getById=" + this.getById.toString(pretty, indent + 1));
        }
        if (this.apply.isTouched()) {
            sb.append(StoreMetrics.linePrefix(pretty, indent) + "apply=" + this.apply.toString(pretty, indent + 1));
        }
        if (this.update.isTouched()) {
            sb.append(StoreMetrics.linePrefix(pretty, indent) + "update=" + this.update.toString(pretty, indent + 1));
        }
        if (this.store.isTouched()) {
            sb.append(StoreMetrics.linePrefix(pretty, indent) + "store=" + this.store.toString(pretty, indent + 1));
        }
        if (this.delete.isTouched()) {
            sb.append(StoreMetrics.linePrefix(pretty, indent) + "delete=" + this.delete.toString(pretty, indent + 1));
        }
        if (this.deleteByQuery.isTouched()) {
            sb.append(StoreMetrics.linePrefix(pretty, indent) + "deleteByQuery=" + this.deleteByQuery.toString(pretty, indent + 1));
        }
        if (this.query.isTouched()) {
            sb.append(StoreMetrics.linePrefix(pretty, indent) + "query=" + this.query.toString(pretty, indent + 1));
        }
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }

    public static class OpMetrics
    extends AbstractMetrics<OpMetrics> {
        private final OpMetrics parent;
        public final AsyncMetrics operations;
        public final Timer.DurationTally queued;
        public final Timer.DurationTally working;
        public final Timer.DurationTally callbacks;
        public final Timer.DurationTally blocked;
        private final Timer.DurationTally retryDelays;
        private final AtomicLong retries;
        private final AtomicLong versionConflicts;

        public OpMetrics(OpMetrics parent) {
            this(parent, new AsyncMetrics(parent != null ? parent.operations : null), new Timer.DurationTally(), 0L, 0L);
        }

        private OpMetrics(OpMetrics parent, AsyncMetrics operations, Timer.DurationTally retryDelays, long retries, long versionConflicts) {
            this.parent = parent;
            this.operations = operations;
            this.queued = operations.queued;
            this.working = operations.working;
            this.callbacks = operations.callbacks;
            this.blocked = operations.blocked;
            this.retryDelays = retryDelays;
            this.retries = new AtomicLong(retries);
            this.versionConflicts = new AtomicLong(versionConflicts);
        }

        @Override
        public boolean isTouched() {
            return this.operations.isTouched();
        }

        @Override
        public long firstTouchNanos() {
            return this.operations.firstTouchNanos();
        }

        @Override
        public long lastTouchNanos() {
            return this.operations.lastTouchNanos();
        }

        public Timer.Stopwatch blocked() {
            return this.operations.blocked();
        }

        public Timer.Stopwatch callback() {
            return this.operations.callback();
        }

        public void retryDelay(long count, TimeUnit unit) {
            this.retryDelays.addDuration(count);
        }

        public void retry() {
            this.retries.incrementAndGet();
        }

        public void versionConflict() {
            this.versionConflicts.incrementAndGet();
        }

        public OpMetrics combine(OpMetrics newParent, OpMetrics other) {
            return new OpMetrics(newParent, this.operations.combine(newParent != null ? newParent.operations : null, other.operations), this.retryDelays.combine(newParent != null ? newParent.retryDelays : null, other.retryDelays), this.retries.get() + other.retries.get(), this.versionConflicts.get() + other.versionConflicts.get());
        }

        @Override
        public String toString(boolean pretty, int indent) {
            StringBuilder sb = new StringBuilder();
            sb.append("[OpMetric");
            sb.append(" operations=" + this.operations.toString(pretty, indent));
            if (this.retries.get() > 0L) {
                sb.append(" retries=" + this.retries.get());
            }
            if (this.retryDelays.isTouched()) {
                sb.append(" retryDelays=" + this.retryDelays);
            }
            if (this.versionConflicts.get() > 0L) {
                sb.append(" conflicts=" + this.versionConflicts.get());
            }
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }
    }
}

