/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.reasoner.ExistentialRestrictionCollector;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.UsageType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class AggregationResolution
extends AbstractSmartsModuleClassificationStep {
    private static final IRI HAS_DEFAULT_AGGREGATION_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasDefaultAggregation");
    private List<Ontology<OWLOntology>> mOntologies = null;

    AggregationResolution(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg pkg) {
        Ontology<OWLOntology> ontology = this.mOntologies.get(0);
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        pkg.getDatasetClassificationPkgs().forEach(dp -> dp.getInScopeColumnClassificationPkgs().stream().filter(colPkg -> this.shouldExecute((SmartsModuleClassificationPkg.ColumnClassificationPkg)colPkg, dp.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.NAME, DeltaAnalysisScope.ModifiableProperty.CONCEPTS, DeltaAnalysisScope.ModifiableProperty.USAGE, DeltaAnalysisScope.ModifiableProperty.AGGREGATION)).forEach(cp -> cp.setDefaultAggregation(this.getAggregationType((SmartsModuleClassificationPkg.ColumnClassificationPkg)cp, factory, reasoner, dp.getDelatAnalysisScope()))));
    }

    @Nonnull
    private AggregationType getAggregationType(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLDataFactory factory, OWLReasoner reasoner, DeltaAnalysisScope deltaAnalysisScope) {
        boolean hasAggregationDelta = this.hasModifiedDelta(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.AGGREGATION);
        if (hasAggregationDelta && columnPkg.getColumnInfo().getSemanticInfo() != null) {
            return columnPkg.getColumnInfo().getSemanticInfo().getDefaultAggregation();
        }
        if (columnPkg.getColumnInfo().getKeyType() != null) {
            return AggregationType.COUNT_DISTINCT;
        }
        AggregationType aggregation = this.resolveAggregationType(columnPkg, factory, reasoner);
        if (!columnPkg.getColumnInfo().getDataType().isNumeric() && (aggregation.equals((Object)AggregationType.SUM) || aggregation.equals((Object)AggregationType.AVERAGE))) {
            aggregation = AggregationType.COUNT_DISTINCT;
        }
        return aggregation;
    }

    @Nonnull
    private AggregationType resolveAggregationType(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLDataFactory factory, OWLReasoner reasoner) {
        List specificConcepts;
        Map<ConceptInfo, Set<OWLClass>> aggrs;
        HashSet aggregations = new HashSet();
        if (this.isMeasureColumn(columnPkg.getColumnInfo().getSemanticInfo(), reasoner, factory)) {
            List aggregationDomainConcepts = columnPkg.getConcepts().stream().filter(c -> !ConceptsUtil.getOntologyId((ConceptInfo)c).equalsIgnoreCase("http://www.ibm.com/ontologies/waca/application")).filter(c -> this.isAggregation((ConceptInfo)c, reasoner, factory)).filter(c -> Double.compare(c.getConfidence(), 0.5) > 0).collect(Collectors.toList());
            aggregationDomainConcepts.stream().forEach(a -> aggregations.add(factory.getOWLClass(IRI.create((String)a.getConceptID()))));
        }
        if (!aggregations.isEmpty()) {
            return aggregations.stream().map(this::getAggregationType).findFirst().orElse(AggregationType.NONE);
        }
        List<ConceptInfo> domainConcepts = columnPkg.getColumnInfo().getSemanticInfo().getConcepts().stream().filter(c -> !ConceptsUtil.getOntologyId((ConceptInfo)c).equalsIgnoreCase("http://www.ibm.com/ontologies/waca/application")).collect(Collectors.toList());
        this.consolidateConcepts(domainConcepts, reasoner, factory);
        if (columnPkg.getUsage() == UsageType.FACT) {
            domainConcepts.removeIf(c -> this.isEntity((ConceptInfo)c, reasoner, factory));
            domainConcepts.removeIf(c -> this.isIdentifierConcept((ConceptInfo)c, reasoner, factory));
        }
        if ((aggrs = this.collectAggregationClasses(domainConcepts)).size() == 1) {
            return aggrs.values().iterator().next().stream().map(this::getAggregationType).findFirst().orElse(AggregationType.NONE);
        }
        if (aggrs.size() > 1 && (specificConcepts = aggrs.keySet().stream().filter(k -> !k.getConceptID().equals("http://www.ibm.com/ontologies/waca/domain/common#Entity") && !k.getConceptID().equals("http://www.ibm.com/ontologies/waca/domain/common#Measure")).sorted(Comparator.comparing(ConceptInfo::getConfidence).reversed()).collect(Collectors.toList())) != null && !specificConcepts.isEmpty()) {
            List relations;
            if (specificConcepts.size() >= 2 && Float.compare(((ConceptInfo)specificConcepts.get(0)).getConfidence(), ((ConceptInfo)specificConcepts.get(1)).getConfidence()) == 0 && (relations = columnPkg.getColumnInfo().getSemanticInfo().getRelations()).stream().anyMatch(r -> r.getEndFrom().getConceptID().equals(((ConceptInfo)specificConcepts.get(0)).getConceptID()))) {
                return aggrs.get(specificConcepts.get(1)).stream().map(this::getAggregationType).findFirst().orElse(AggregationType.NONE);
            }
            return aggrs.get(specificConcepts.get(0)).stream().map(this::getAggregationType).findFirst().orElse(AggregationType.NONE);
        }
        if (this.isCategorical(columnPkg)) {
            columnPkg.setDefaultAggregation(AggregationType.COUNT_DISTINCT);
            return AggregationType.COUNT_DISTINCT;
        }
        return AggregationType.SUM;
    }

    private void consolidateConcepts(List<ConceptInfo> domainConcepts, OWLReasoner reasoner, OWLDataFactory factory) {
        List candidatesToRemove = Collections.synchronizedList(new ArrayList(domainConcepts.size() / 2));
        Stream candidatesStream = this.isExecParallel() ? domainConcepts.parallelStream() : domainConcepts.stream();
        candidatesStream.forEach(current -> {
            OWLClass removableClass = factory.getOWLClass(IRI.create((String)current.getConceptID()));
            domainConcepts.stream().filter(other -> other != current).forEach(other -> {
                if (reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(IRI.create((String)other.getConceptID())), false).getFlattened().contains(removableClass)) {
                    candidatesToRemove.add(current);
                }
            });
        });
        domainConcepts.removeAll(candidatesToRemove);
    }

    private boolean isCategorical(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        return columnPkg.getConcepts().stream().anyMatch(c -> c.getConceptID().equals("http://www.ibm.com/ontologies/waca/application#Categorical"));
    }

    private AggregationType getAggregationType(OWLClass agg) {
        try {
            return AggregationType.fromValue((String)this.getValidAggregationName(agg.getIRI().getShortForm()));
        }
        catch (IllegalArgumentException e) {
            return AggregationType.NONE;
        }
    }

    private String getValidAggregationName(String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(name.substring(0, 1).toLowerCase());
        buffer.append(name.substring(1));
        return buffer.toString();
    }

    private Map<ConceptInfo, Set<OWLClass>> collectAggregationClasses(List<ConceptInfo> domainConcepts) {
        HashMap<ConceptInfo, Set<OWLClass>> aggrs = new HashMap<ConceptInfo, Set<OWLClass>>(domainConcepts.size());
        domainConcepts.stream().forEach(c -> {
            Optional<OWLOntology> ontology = this.mOntologies.stream().map(Ontology::getValue).filter(o -> ((IRI)o.getOntologyID().getOntologyIRI().get()).toString().equals(ConceptsUtil.getOntologyId((ConceptInfo)c))).findFirst();
            if (ontology.isPresent()) {
                OWLDataFactory factory = ontology.get().getOWLOntologyManager().getOWLDataFactory();
                OWLClass cClass = factory.getOWLClass(IRI.create((String)c.getConceptID()));
                ExistentialRestrictionCollector hasDefaultAggregationVisitor = new ExistentialRestrictionCollector(Collections.singleton(ontology.get()), Collections.singletonList(HAS_DEFAULT_AGGREGATION_IRI), true);
                cClass.accept((OWLClassExpressionVisitor)hasDefaultAggregationVisitor);
                Set<OWLObject> aggr = hasDefaultAggregationVisitor.getRestrictedProperties(HAS_DEFAULT_AGGREGATION_IRI);
                if (!aggr.isEmpty()) {
                    aggrs.putIfAbsent((ConceptInfo)c, aggr.stream().filter(a -> a instanceof OWLClassExpression).map(a -> ((OWLClassExpression)a).asOWLClass()).collect(Collectors.toSet()));
                }
            }
        });
        return aggrs;
    }
}

