/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.common.util.SampleDataHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.ontology.util.TNode;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.StatisticType;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class HierarchyDetection
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    protected HierarchyDetection(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        if (this.isExecParallel()) {
            smPkg.setModified(smPkg.getDatasetClassificationPkgs().parallelStream().map(this::classify).reduce(Boolean::logicalOr).orElse(false));
        } else {
            smPkg.setModified(smPkg.getDatasetClassificationPkgs().stream().map(this::classify).reduce(Boolean::logicalOr).orElse(false));
        }
        this.clearMDC();
    }

    private boolean classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        this.mdcDSInfo(dsPkg);
        return this.mOntologies.stream().map(o -> this.classify(dsPkg, (Ontology<OWLOntology>)o)).reduce(Boolean::logicalOr).orElse(false);
    }

    private boolean classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg, Ontology<OWLOntology> ontology) {
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty() || inScopeColPkgs.stream().allMatch(colPkg -> this.onlyPropModified((SmartsModuleClassificationPkg.ColumnClassificationPkg)colPkg, dsPkg.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.AGGREGATION))) {
            return false;
        }
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        List<TNode<SmartsModuleClassificationPkg.LogicalGroup>> levels = dsPkg.getGroups().stream().map(TNode::new).collect(Collectors.toList());
        for (TNode tNode : levels) {
            if (tNode.getParent().isPresent()) continue;
            this.buildHierarchy(tNode, Optional.empty(), levels, ontology, reasoner, factory);
        }
        List<TNode<SmartsModuleClassificationPkg.LogicalGroup>> hierarchies = levels.stream().filter(h -> !h.getParent().isPresent() && !h.getChildren().isEmpty()).collect(Collectors.toList());
        if (!hierarchies.isEmpty()) {
            dsPkg.setHierarchies(hierarchies);
            return true;
        }
        return false;
    }

    private void buildHierarchy(TNode<SmartsModuleClassificationPkg.LogicalGroup> parentLevel, Optional<OWLClass> parentLevelConcept, List<TNode<SmartsModuleClassificationPkg.LogicalGroup>> levels, Ontology<OWLOntology> ontology, OWLReasoner reasoner, OWLDataFactory factory) {
        Optional<SmartsModuleClassificationPkg.Candidate> conceptCandidate = parentLevel.getData().getGroupKey();
        if (!conceptCandidate.isPresent()) {
            return;
        }
        Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> parentLevelColumn = this.getGroupIDMember(parentLevel.getData());
        if (!parentLevelColumn.isPresent()) {
            return;
        }
        OWLClass pConcept = parentLevelConcept.isPresent() ? parentLevelConcept.get() : factory.getOWLClass(conceptCandidate.get().getConceptID());
        Set<OWLClass> childrenLevelConcepts = this.collectHasPartRestriction(pConcept, (OWLOntology)ontology.getValue());
        if (childrenLevelConcepts.isEmpty()) {
            return;
        }
        HashSet<TNode<SmartsModuleClassificationPkg.LogicalGroup>> ancestors = new HashSet<TNode<SmartsModuleClassificationPkg.LogicalGroup>>();
        Optional<TNode<SmartsModuleClassificationPkg.LogicalGroup>> tempParentLevel = Optional.of(parentLevel);
        while (tempParentLevel.isPresent()) {
            ancestors.add(tempParentLevel.get());
            tempParentLevel = tempParentLevel.get().getParent();
        }
        List sortedLevels = levels.stream().filter(l -> !ancestors.contains(l)).sorted(Comparator.comparing(l -> {
            Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> idColumn = this.getGroupIDOrDetailMemberColumn((SmartsModuleClassificationPkg.LogicalGroup)l.getData(), false);
            if (idColumn.isPresent()) {
                return this.getStatisticByType(idColumn.get().getColumnInfo(), StatisticType.DISTINCT_COUNT);
            }
            return -1;
        })).collect(Collectors.toList());
        childrenLevelConcepts.stream().forEach(c -> {
            Optional<TNode<SmartsModuleClassificationPkg.LogicalGroup>> childLevel = this.findChildLevelByConcept((OWLClass)c, parentLevelColumn, sortedLevels, reasoner, factory);
            if (childLevel.isPresent()) {
                parentLevel.addChild(childLevel.get());
                if (childLevel.get().getChildren().isEmpty()) {
                    this.buildHierarchy(childLevel.get(), Optional.empty(), levels, ontology, reasoner, factory);
                }
            } else if (!c.equals(pConcept)) {
                this.buildHierarchy(parentLevel, Optional.of(c), levels, ontology, reasoner, factory);
            }
        });
    }

    private Optional<TNode<SmartsModuleClassificationPkg.LogicalGroup>> findChildLevelByConcept(OWLClass concept, Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> parentLevelColumn, List<TNode<SmartsModuleClassificationPkg.LogicalGroup>> levels, OWLReasoner reasoner, OWLDataFactory factory) {
        Integer maxScore;
        List childrenLevelCandidates = ((Stream)levels.stream().sequential()).filter(h -> !h.getParent().isPresent()).filter(h -> ((SmartsModuleClassificationPkg.LogicalGroup)h.getData()).getGroupKey().isPresent() && ((SmartsModuleClassificationPkg.LogicalGroup)h.getData()).getGroupKey().get().getConceptID().equals((Object)concept.getIRI())).filter(h -> !this.isMeasureGroup((SmartsModuleClassificationPkg.LogicalGroup)h.getData(), reasoner, factory)).filter(h -> this.haveOneManyAssociation(parentLevelColumn, this.getGroupIDOrDetailMemberColumn((SmartsModuleClassificationPkg.LogicalGroup)h.getData(), false))).collect(Collectors.toList());
        if (childrenLevelCandidates.isEmpty()) {
            childrenLevelCandidates = ((Stream)levels.stream().sequential()).filter(h -> !h.getParent().isPresent()).filter(h -> ((SmartsModuleClassificationPkg.LogicalGroup)h.getData()).getGroupKey().isPresent() && ((SmartsModuleClassificationPkg.LogicalGroup)h.getData()).getGroupKey().get().getConceptID().equals((Object)concept.getIRI())).filter(h -> !this.isMeasureGroup((SmartsModuleClassificationPkg.LogicalGroup)h.getData(), reasoner, factory)).collect(Collectors.toList());
        }
        if (childrenLevelCandidates.isEmpty()) {
            return Optional.empty();
        }
        if (childrenLevelCandidates.size() == 1) {
            return Optional.of(childrenLevelCandidates.get(0));
        }
        Map<Integer, List<TNode>> mapScoreToLevel = childrenLevelCandidates.stream().collect(Collectors.groupingBy(c -> this.getNameMatchingScore(this.getGroupIDOrDetailMemberColumn((SmartsModuleClassificationPkg.LogicalGroup)c.getData(), false), parentLevelColumn)));
        List<TNode> bestCandidates = mapScoreToLevel.get(maxScore = mapScoreToLevel.keySet().stream().reduce(Integer::max).orElse(-1));
        if (bestCandidates.isEmpty()) {
            return Optional.empty();
        }
        if (bestCandidates.size() == 1) {
            return Optional.of(bestCandidates.get(0));
        }
        bestCandidates.stream().sorted(Comparator.comparing(c -> {
            Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> idColumn = this.getGroupIDOrDetailMemberColumn((SmartsModuleClassificationPkg.LogicalGroup)c.getData(), true);
            if (idColumn.isPresent()) {
                return this.getStatisticByType(idColumn.get().getColumnInfo(), StatisticType.DISTINCT_COUNT);
            }
            return -1;
        }));
        return Optional.of(bestCandidates.get(0));
    }

    private boolean haveOneManyAssociation(Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> left, Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> right) {
        if (!left.isPresent() || !right.isPresent()) {
            return false;
        }
        return SampleDataHelper.haveOneManyAssociation((ColumnInfo)left.get().getColumnInfo(), (ColumnInfo)right.get().getColumnInfo());
    }

    private boolean isMeasureGroup(SmartsModuleClassificationPkg.LogicalGroup group, OWLReasoner reasoner, OWLDataFactory factory) {
        return group.getGroupMembers().size() == 1 && this.isMeasureColumn(group.getGroupMembers().get(0).getSecond(), reasoner, factory);
    }
}

