/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.cluemanager;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.OperationMetrics;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.ClueManager;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.ontology.cluemanager.OntoVersionHelper;
import com.ibm.smarts.ontology.exceptions.InitializationException;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.Clue;
import com.ibm.smarts.schema.ClueHit;
import com.ibm.smarts.schema.DataClue;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.store.api.provider.IClueStore;
import com.ibm.smarts.store.api.provider.IDataClueStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClueManagerImpl
implements ClueManager<OWLOntology> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClueManagerImpl.class);
    private static final Locale DEFAULT_CONCEPT_LOCALE = Locale.ENGLISH;
    private static final String SPACE = " ";
    private static final String PIPE = "|";
    private static final String TSV = ".tsv";
    private static final String APPLICATION_ONTOLOGY_NAMESPACE = "http://www.ibm.com/ontologies/waca/application#";
    private static final IRI NOT_INDEXABLE_CLASS_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#notIndexable");
    private static final IRI EXTERNAL_LEXICAL_CLUE_FILE_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#externalLexicalClueFile");
    private static final IRI EXTERNAL_DATA_CLUE_FILE_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#externalDataClueFile");
    private static final IRI EXTERNAL_DATA_CLUE_GEO_FILE_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#externalDataClueGeoFile");
    private static final String CLUE = "clue";
    private static final String CONCEPT_IRI = "conceptIRI";
    private static final String ONTOLOGY_IRI = "ontologyIRI";
    private static final String TENANT_ID = "tenantID";
    private static final String USER_ID = "userID";
    private IStoreProvider storeProvider;
    private SmartNLP nlp;
    private OntoVersionHelper ovh;
    private Properties config;

    public ClueManagerImpl(IStoreProvider storeProvider, SmartNLP nlp, Properties config) {
        this(storeProvider, nlp, new OntoVersionHelper(storeProvider), config);
    }

    ClueManagerImpl(IStoreProvider storeProvider, SmartNLP nlp, OntoVersionHelper ovh, Properties config) {
        this.storeProvider = storeProvider;
        this.nlp = nlp;
        this.ovh = ovh;
        this.config = config;
    }

    protected OntoVersionHelper getOntoHelper() {
        return this.ovh;
    }

    public void deleteClues(OWLOntology ontology, RequestContext requestContext) {
        StoreStatus ss = this.clueStore(requestContext).delete(KnowledgeDiscoveryHelper.getOntologyID(ontology));
        if (!ss.isSuccess()) {
            LOGGER.error("Failed to delete Lexical clues: {}", (Object)ss.toString());
        } else {
            LOGGER.debug("Lexical Clues were deleted");
        }
    }

    public void deleteDataClues(OWLOntology ontology, RequestContext requestContext) {
        StoreStatus ss = this.dataClueStore(requestContext).delete(KnowledgeDiscoveryHelper.getOntologyID(ontology));
        if (!ss.isSuccess()) {
            LOGGER.error("Failed to delete data clues: {}", (Object)ss.toString());
        } else {
            LOGGER.debug("Data Clues were deleted");
        }
    }

    public void deleteAllClues(OWLOntology ontology, RequestContext requestContext) {
        this.deleteDataClues(ontology, requestContext);
        this.deleteClues(ontology, requestContext);
    }

    protected boolean isLexicalClueExist(OWLOntology ontology) {
        return ontology.containsAnnotationPropertyInSignature(EXTERNAL_LEXICAL_CLUE_FILE_IRI);
    }

    protected boolean isDataClueExist(OWLOntology ontology) {
        return ontology.containsAnnotationPropertyInSignature(EXTERNAL_DATA_CLUE_FILE_IRI);
    }

    public void updateClues(OWLOntology ontology, RequestContext reqCtx) throws Exception {
        String versionInProperties = this.ovh.getVersionFromProp();
        if (this.isUpdateClueRequired(versionInProperties, ontology, reqCtx)) {
            LOGGER.info("Clues are not up to date. Indexing clues.");
            this.deleteAllClues(ontology, reqCtx);
            this.indexClues(ontology, reqCtx);
            this.ovh.storeOntoVersion(reqCtx, KnowledgeDiscoveryHelper.getOntologyID(ontology), versionInProperties);
        }
    }

    boolean isUpdateClueRequired(String versionInProperties, OWLOntology ontology, RequestContext reqCtx) {
        if (!this.storeProvider.getOntoVersionStore(reqCtx).isExist() || !this.storeProvider.getClueStore(reqCtx).isExist() || this.isDataClueExist(ontology) && !this.storeProvider.getDataClueStore(reqCtx).isExist()) {
            return true;
        }
        String versionInStore = this.ovh.getVerFromStore(reqCtx, KnowledgeDiscoveryHelper.getOntologyID(ontology));
        if (versionInStore.equals("")) {
            return true;
        }
        return this.ovh.compareVersions(versionInProperties, versionInStore) > 0;
    }

    public void indexClues(OWLOntology ontology, RequestContext requestContext) throws Exception {
        this.indexClues(ontology, requestContext, true);
    }

    void indexClues(OWLOntology ontology, RequestContext requestContext, boolean dataClues) throws Exception {
        this.indexConcepts(ontology, requestContext);
        this.indexExternalLexicalCluesPerLanguage(ontology, requestContext);
        if (dataClues) {
            ExternalClueHelper dataClueHelper = new ExternalClueHelper(ontology, requestContext);
            dataClueHelper.indexDataClues();
            dataClueHelper.indexGeoLocations();
        }
    }

    public void indexCluesFromOntology(OWLOntology ontology, RequestContext requestContext) throws Exception {
        LOGGER.info("Ontology being read: {}", (Object)ontology.getOntologyID());
        this.indexExternalLexicalCluesPerLanguage(ontology, requestContext);
        ExternalClueHelper dataClueHelper = new ExternalClueHelper(ontology, requestContext);
        dataClueHelper.indexDataClues();
    }

    private void indexConcepts(OWLOntology ontology, RequestContext reqCtx) throws Exception {
        LOGGER.info("indexing clues starts: ");
        List<IRecord<Clue>> documents = this.getConceptClueDocuments(ontology, reqCtx);
        StoreStatus status = this.clueStore(DEFAULT_CONCEPT_LOCALE, reqCtx).store(documents);
        this.checkStoreStatus(status, "Failed to index concept labels.");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("index of concept labels: {}", (Object)documents.stream().map(d -> CommonJAXBHelper.marshalToJSON((Object)d)).collect(Collectors.joining(", ")));
        }
        LOGGER.info("indexing clues ends. ");
    }

    List<IRecord<Clue>> getConceptClueDocuments(OWLOntology ontology, RequestContext reqCtx) {
        List<IRecord<Clue>> documents = ontology.getClassesInSignature(Imports.INCLUDED).parallelStream().filter(c -> !c.getIRI().getNamespace().equals(APPLICATION_ONTOLOGY_NAMESPACE)).filter(c -> this.isIndexable((OWLClass)c, ontology)).map(c -> this.getClueFromConcept(KnowledgeDiscoveryHelper.getOntologyID(ontology), (OWLClass)c, reqCtx)).collect(Collectors.toList());
        return documents;
    }

    private void checkStoreStatus(StoreStatus status, String errorMsg) {
        if (!status.isSuccess()) {
            status.getErrors().stream().findFirst().ifPresent(t -> {
                throw new InitializationException(errorMsg, (Throwable)t);
            });
            throw new InitializationException(errorMsg);
        }
    }

    boolean isIndexable(OWLClass c, OWLOntology ontology) {
        boolean notIndexable;
        IRI entity = c.getIRI();
        Set axiom = ontology.getAxioms(OWLAnnotationAssertionAxiom.class, OWLAnnotationSubject.class, (OWLObject)entity, Imports.INCLUDED, Navigation.IN_SUB_POSITION);
        boolean bl = notIndexable = !axiom.isEmpty() && axiom.stream().anyMatch(a -> a.getProperty().getIRI().equals((Object)NOT_INDEXABLE_CLASS_PROPERTY_IRI) && ((OWLLiteral)a.getValue().asLiteral().get()).isBoolean() && ((OWLLiteral)a.getValue().asLiteral().get()).parseBoolean());
        if (notIndexable) {
            LOGGER.warn("{} is not indexable", (Object)c.getIRI().getShortForm());
        }
        return !notIndexable;
    }

    private void indexExternalLexicalCluesPerLanguage(OWLOntology ontology, RequestContext ctx) {
        Instant before = Instant.now();
        IRI ontologyIRI = KnowledgeDiscoveryHelper.getIRI(ontology);
        if (!this.isLexicalClueExist(ontology)) {
            LOGGER.info("No external LEXICAL CLUE files for {}", (Object)ontologyIRI);
            return;
        }
        LOGGER.info("External LEXICAL CLUE files have been found for ontology: {}", (Object)ontology.getOntologyID());
        LexicalClueHelper lch = new LexicalClueHelper(ontologyIRI, ctx);
        String languageOverridesString = this.config.getProperty("smarts.ontology.resource.languageOverrides");
        String[] languageOverridesStringArray = languageOverridesString.equals("") ? new String[]{} : languageOverridesString.split(",");
        HashSet<String> languageOverrides = new HashSet<String>(Arrays.asList(languageOverridesStringArray));
        OWLDataFactory factory = ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLAnnotationProperty externalClueFile = factory.getOWLAnnotationProperty(EXTERNAL_LEXICAL_CLUE_FILE_IRI);
        ontology.getAnnotations().stream().filter(a -> a.getProperty().equals(externalClueFile)).map(a -> Pair.of((Object)KnowledgeDiscoveryHelper.getOWLLiteral(a).getLang(), (Object)("/" + ((OWLLiteral)a.getValue().asLiteral().get()).getLiteral()))).filter(p -> languageOverrides.isEmpty() || ((String)p.getLeft()).equals(DEFAULT_CONCEPT_LOCALE.getLanguage()) || languageOverrides.contains(p.getLeft())).forEach(p -> {
            String lang = (String)p.getLeft();
            String fileName = (String)p.getRight();
            LOGGER.info("Language of external LEXICAL CLUE file = {}", (Object)lang);
            LOGGER.info("External Lexical Clue FileName = {}", (Object)fileName);
            lch.index(fileName, lang);
        });
        LOGGER.info(String.format("Index External LEXICAL CLUES took [%s]ms", Duration.between(before, Instant.now()).toMillis()));
    }

    private String generateLexicalClueId(Clue clueToIndex) {
        String id = Integer.toHexString(clueToIndex.getText().hashCode()) + PIPE + Integer.toHexString(clueToIndex.getConceptID().hashCode()) + PIPE + Integer.toHexString(clueToIndex.getOntologyID().hashCode());
        if (!StringUtils.isBlank((CharSequence)clueToIndex.getTenantID())) {
            id = id + PIPE + Integer.toHexString(clueToIndex.getTenantID().hashCode());
        }
        if (!StringUtils.isBlank((CharSequence)clueToIndex.getUserID())) {
            id = id + PIPE + Integer.toHexString(clueToIndex.getUserID().hashCode());
        }
        return id;
    }

    private IRecord<Clue> getClueFromConcept(String ontologyID, OWLClass concept, RequestContext ctx) {
        Clue clue = new Clue();
        clue.setText(concept.getIRI().getShortForm());
        clue.setOntologyID(ontologyID);
        clue.setConceptID(concept.getIRI().toString());
        this.expandNlpInfo(clue, ctx);
        return IRecord.create((Object)clue, (String)this.generateLexicalClueId(clue));
    }

    private void expandNlpInfo(Clue clue, RequestContext ctx) {
        List textInfos = null;
        try {
            textInfos = this.nlp.describeText(ctx, new String[]{clue.getText()});
        }
        catch (Exception ex) {
            LOGGER.error(String.format("nlp could not understand the text {%s} :-( ", clue.getText()));
        }
        if (textInfos == null || textInfos.isEmpty() || ((TextInfo)textInfos.get(0)).getPhrases().isEmpty()) {
            String text = clue.getText().toLowerCase(ctx.locale);
            clue.setText(text);
            clue.setTextTokenized(text);
            clue.setTextLemma(text);
        } else {
            StringBuilder textTokenized = new StringBuilder();
            StringBuilder textLemma = new StringBuilder();
            PhraseInfo phrase = (PhraseInfo)((TextInfo)textInfos.get(0)).getPhrases().get(0);
            clue.setText(phrase.getText());
            phrase.getTokens().forEach(token -> this.mapToken(textTokenized, textLemma, (TokenInfo)token));
            clue.setTextLexicalInfo(CommonJAXBHelper.marshalToJSON((Object)phrase));
            clue.setTextTokenized(textTokenized.toString().trim());
            clue.setTextLemma(textLemma.toString().trim());
        }
    }

    private void mapToken(StringBuilder textTokenized, StringBuilder textLemma, TokenInfo token) {
        textTokenized.append(token.getText()).append(SPACE);
        textLemma.append(token.getText()).append(SPACE);
        if (!token.getText().equals(token.getLemma())) {
            textLemma.append(token.getLemma()).append(SPACE);
        }
    }

    public List<ClueHit> searchClues(String token, RequestContext requestContext, Locale localeOverride) throws Exception {
        if (StringUtils.isBlank((CharSequence)token)) {
            return Collections.emptyList();
        }
        Instant before = Instant.now();
        Optional<Locale> localeOverrideOpt = Optional.ofNullable(localeOverride);
        String language = requestContext.locale.getLanguage();
        IClueStore searchStore = this.clueStore(localeOverrideOpt.orElse(new Locale(language)), requestContext);
        IStoreQuery sq = this.buildQuery(token, searchStore, language, localeOverrideOpt);
        List results = searchStore.executeSearch(sq);
        LOGGER.warn(String.format("search took [%s]ms", Duration.between(before, Instant.now()).toMillis()));
        OperationMetrics.OpMetrics metrics = requestContext.requestMetrics.opMetrics.group("onto").metrics("clues-search");
        ArrayList<ClueHit> clueHits = new ArrayList<ClueHit>();
        if (results.isEmpty()) {
            metrics.incrCounter("clues-searches-with-items-not-found");
        } else {
            metrics.incrCounter("clues-searches-with-items-found");
            metrics.incrCounter("clues-found-count", (long)results.size());
            results.forEach(hit -> {
                ClueHit clueHit = new ClueHit();
                clueHit.setClue((Clue)hit.getRecord().getRecord());
                clueHit.setScore(hit.getScore());
                clueHits.add(clueHit);
            });
        }
        return clueHits;
    }

    private IStoreQuery buildQuery(String token, IClueStore searchStore, String language, Optional<Locale> localeOverride) {
        IStoreQuery sq = searchStore.getQueryBuilder().addQuery(SearchFields.TEXT.getName(), token, SearchFields.TEXT.getBoost()).addQuery(SearchFields.TEXTTOKENIZED.getName(), token, SearchFields.TEXTTOKENIZED.getBoost()).addQuery(SearchFields.TEXTLEMMA.getName(), token, SearchFields.TEXTLEMMA.getBoost()).build();
        if (!language.equals(DEFAULT_CONCEPT_LOCALE.getLanguage()) || localeOverride.isPresent()) {
            sq.setLanguages(new String[]{DEFAULT_CONCEPT_LOCALE.getLanguage()});
        }
        return sq;
    }

    public CompletableFuture<List<ClueHit>> searchCluesAsync(String token, RequestContext requestContext, Locale localeOverride) {
        Instant before = Instant.now();
        Optional<Locale> localeOverrideOpt = Optional.ofNullable(localeOverride);
        String language = requestContext.locale.getLanguage();
        IClueStore searchStore = this.clueStore(localeOverrideOpt.orElse(new Locale(language)), requestContext);
        CompletableFuture cluesF = searchStore.executeSearchAsync(this.buildQuery(token, searchStore, language, localeOverrideOpt));
        return cluesF.thenApply(clues -> {
            LOGGER.warn(String.format("Async search took [%s]ms", Duration.between(before, Instant.now()).toMillis()));
            OperationMetrics.OpMetrics metrics = requestContext.requestMetrics.opMetrics.group("onto").metrics("clues-search");
            ArrayList clueHits = new ArrayList();
            if (clues.isEmpty()) {
                metrics.incrCounter("clues-searches-with-items-not-found");
            } else {
                metrics.incrCounter("clues-searches-with-items-found");
                metrics.incrCounter("clues-found-count", (long)clues.size());
                clues.forEach(hit -> {
                    ClueHit clueHit = new ClueHit();
                    clueHit.setClue((Clue)hit.getRecord().getRecord());
                    clueHit.setScore(hit.getScore());
                    clueHits.add(clueHit);
                });
            }
            return clueHits;
        });
    }

    public boolean matchDataClue(String value, String conceptID, RequestContext requestContext) {
        Instant before = Instant.now();
        IDataClueStore searchStore = this.dataClueStore(DEFAULT_CONCEPT_LOCALE, requestContext);
        IStoreQuery sq = searchStore.getQueryBuilder().addFilter("valueUC", new String[]{value.toUpperCase(DEFAULT_CONCEPT_LOCALE)}).addFilter("conceptID", new String[]{conceptID}).build();
        List results = searchStore.executeSearch(sq);
        OperationMetrics.OpMetrics metrics = requestContext.requestMetrics.opMetrics.group("onto").metrics("data-clues-search");
        LOGGER.debug(String.format("Match DATA CLUE took [%s]ms", Duration.between(before, Instant.now()).toMillis()));
        if (!results.isEmpty()) {
            metrics.incrCounter("data-clues-searches-with-items-found");
            return true;
        }
        metrics.incrCounter("data-clues-searches-with-items-not-found");
        LOGGER.debug("DATA CLUE not found {}", (Object)value);
        return false;
    }

    public List<String> lookupIndividuals(RequestContext requestContext, String ... individuals) {
        if (null == individuals || individuals.length == 0) {
            return Collections.emptyList();
        }
        if ((individuals = (String[])Stream.of(individuals).map(i -> i.trim().toUpperCase(DEFAULT_CONCEPT_LOCALE)).filter(StringUtils::isNotBlank).toArray(String[]::new)).length == 0) {
            return Collections.emptyList();
        }
        Instant before = Instant.now();
        IDataClueStore searchStore = this.dataClueStore(DEFAULT_CONCEPT_LOCALE, requestContext);
        IStoreQuery sq = searchStore.getQueryBuilder().addFilter("valueUC", individuals).build();
        sq.getSearchFields().stream().forEach(field -> {
            LOGGER.debug("SEARCH FIELD: " + field.getField());
            LOGGER.debug("SEARCH VALUE: " + Arrays.asList(field.getQueries()));
        });
        List results = searchStore.executeSearch(sq);
        LOGGER.debug(String.format("lookupIndividuals took [%s]ms", Duration.between(before, Instant.now()).toMillis()));
        if (!results.isEmpty()) {
            LOGGER.info("Found [{}] of records using filters [{}]", (Object)results.size(), (Object)individuals);
            return results.stream().map(r -> ((DataClue)r.getRecord().getRecord()).getConceptID()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private IClueStore clueStore(RequestContext requestContext) {
        return this.storeProvider.getClueStore(requestContext);
    }

    private IClueStore clueStore(Locale locale, RequestContext requestContext) {
        return this.storeProvider.getClueStore(locale, requestContext);
    }

    private IDataClueStore dataClueStore(RequestContext requestContext) {
        return this.storeProvider.getDataClueStore(requestContext);
    }

    private IDataClueStore dataClueStore(Locale locale, RequestContext requestContext) {
        return this.storeProvider.getDataClueStore(locale, requestContext);
    }

    class ExternalClueHelper {
        private final OWLOntology ontology;
        private final IRI ontologyIRI;
        private final RequestContext ctx;

        public ExternalClueHelper(OWLOntology ontology, RequestContext ctx) {
            this.ontology = ontology;
            this.ontologyIRI = KnowledgeDiscoveryHelper.getIRI(ontology);
            this.ctx = ctx;
        }

        public void indexDataClues() {
            this.indexDataClues(ExternalClueType.DATA_CLUE);
        }

        public void indexGeoLocations() {
            this.indexDataClues(ExternalClueType.GEO_LOCATION);
        }

        private void indexDataClues(ExternalClueType type) {
            IRI extFileIRI;
            if (type == ExternalClueType.DATA_CLUE) {
                extFileIRI = EXTERNAL_DATA_CLUE_FILE_IRI;
            } else if (type == ExternalClueType.GEO_LOCATION) {
                extFileIRI = EXTERNAL_DATA_CLUE_GEO_FILE_IRI;
            } else {
                throw new InitializationException(String.format("Unsupported External Clue Type [%s]", new Object[]{type}));
            }
            if (!this.ontology.containsAnnotationPropertyInSignature(extFileIRI)) {
                LOGGER.info("No external {} files for {}", (Object)type, (Object)this.ontologyIRI);
            }
            LOGGER.info("External {} files have been found for ontology {}", (Object)type, (Object)this.ontology.getOntologyID());
            Instant before = Instant.now();
            OWLDataFactory factory = KnowledgeDiscoveryHelper.getOWLDataFactory(this.ontology);
            OWLAnnotationProperty extFile = factory.getOWLAnnotationProperty(extFileIRI);
            this.ontology.getAnnotations().stream().filter(a -> KnowledgeDiscoveryHelper.hasProperty(a, extFile)).forEach(a -> {
                String fileName = "/" + KnowledgeDiscoveryHelper.getOWLLiteral(a).getLiteral();
                LOGGER.info("External {} FileName = {}", (Object)type, (Object)fileName);
                List<IRecord<DataClue>> documents = this.getDataClueFromExternalFile(fileName, type);
                StoreStatus status = ClueManagerImpl.this.dataClueStore(this.ctx).store(documents);
                ClueManagerImpl.this.checkStoreStatus(status, "Failed to index external " + (Object)((Object)type) + "s");
                LOGGER.info("indexing {}s ended.", (Object)type);
            });
            LOGGER.info(String.format("Index External [%s] took [%s]ms", new Object[]{type, Duration.between(before, Instant.now()).toMillis()}));
        }

        List<IRecord<DataClue>> getDataClueFromExternalFile(String file, ExternalClueType type) {
            List<Object> result = Collections.emptyList();
            try (InputStream in = KnowledgeDiscoveryHelper.loadFromClasspath(file);){
                if (in == null) {
                    throw new InitializationException("data clue file " + file + " not found on the classpath");
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
                    CSVFormat csvFormat = file.endsWith(ClueManagerImpl.TSV) ? CSVFormat.TDF : CSVFormat.DEFAULT;
                    List dataClues = csvFormat.withHeader(new String[]{ClueManagerImpl.CLUE, ClueManagerImpl.CONCEPT_IRI, ClueManagerImpl.ONTOLOGY_IRI, ClueManagerImpl.TENANT_ID}).withSkipHeaderRecord().parse((Reader)br).getRecords();
                    LOGGER.info("There are [{}] of DATA CLUES in Ontology {}", (Object)dataClues.size(), (Object)this.ontologyIRI.getShortForm());
                    result = dataClues.stream().filter(r -> !StringUtils.isBlank((CharSequence)r.get(ClueManagerImpl.CLUE))).map(clueRecord -> {
                        DataClue dataClue = new DataClue();
                        dataClue.setValue(StringUtils.trim((String)clueRecord.get(ClueManagerImpl.CLUE)));
                        dataClue.setValueUC(dataClue.getValue().toUpperCase(DEFAULT_CONCEPT_LOCALE));
                        dataClue.setConceptID(clueRecord.get(ClueManagerImpl.CONCEPT_IRI));
                        String crOntoIRI = clueRecord.get(ClueManagerImpl.ONTOLOGY_IRI);
                        dataClue.setOntologyID(StringUtils.isBlank((CharSequence)crOntoIRI) ? this.ontologyIRI.toString() : crOntoIRI);
                        String tenantID = clueRecord.get(ClueManagerImpl.TENANT_ID);
                        if (!StringUtils.isBlank((CharSequence)tenantID)) {
                            dataClue.setTenantID(tenantID);
                        }
                        String dataClueID = type == ExternalClueType.GEO_LOCATION ? this.generateGeoLocationId(dataClue) : this.generateDataClueId(dataClue);
                        return IRecord.create((Object)dataClue, (String)dataClueID);
                    }).collect(Collectors.toList());
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to close input stream for " + file, (Throwable)e);
            }
            return result;
        }

        String generateDataClueId(DataClue dataClue) {
            return this.generateDataClueId(dataClue, value -> Integer.toHexString(value.hashCode()));
        }

        String generateGeoLocationId(DataClue dataClue) {
            return this.generateDataClueId(dataClue, value -> {
                try {
                    return DigestUtils.md5Hex((byte[])value.getBytes("UTF8")).substring(0, 9);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new InternalException((Throwable)ex, "Failed to generate data clue ID: " + ex.getMessage(), new Object[0]);
                }
            });
        }

        String generateDataClueId(DataClue dataClue, Function<String, String> valueIdBuilder) {
            String id = valueIdBuilder.apply(dataClue.getValue()) + ClueManagerImpl.PIPE + Integer.toHexString(dataClue.getConceptID().hashCode()) + ClueManagerImpl.PIPE + Integer.toHexString(dataClue.getOntologyID().hashCode());
            if (!StringUtils.isBlank((CharSequence)dataClue.getTenantID())) {
                id = id + ClueManagerImpl.PIPE + Integer.toHexString(dataClue.getTenantID().hashCode());
            }
            return id;
        }
    }

    static enum ExternalClueType {
        DATA_CLUE{

            public String toString() {
                return "Data Clue";
            }
        }
        ,
        GEO_LOCATION{

            public String toString() {
                return "Geo Location";
            }
        };

    }

    class LexicalClueHelper {
        private final IRI ontologyIRI;
        private final RequestContext ctx;

        LexicalClueHelper(IRI ontologyIRI, RequestContext ctx) {
            this.ontologyIRI = ontologyIRI;
            this.ctx = ctx;
        }

        void index(String file, String language) {
            String clueLang = StringUtils.isNotBlank((CharSequence)language) ? language : DEFAULT_CONCEPT_LOCALE.getLanguage();
            Locale clueLocale = new Locale(clueLang);
            List<IRecord<Clue>> documents = this.getCluesFromExternalFile(file, clueLocale);
            IClueStore store = this.isRequestLocale(clueLocale) ? ClueManagerImpl.this.clueStore(this.ctx) : ClueManagerImpl.this.clueStore(clueLocale, this.ctx);
            StoreStatus status = store.store(documents);
            ClueManagerImpl.this.checkStoreStatus(status, "Failed to index external lexical clues for locale " + this.ctx.locale);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("index of external LEXICAL CLUES for locale {}: {}", (Object)language, (Object)documents.stream().map(d -> CommonJAXBHelper.marshalToJSON((Object)d)).collect(Collectors.joining(", ")));
            }
            LOGGER.info("indexing clues ended for locale {}", (Object)this.ctx.locale);
        }

        List<IRecord<Clue>> getCluesFromExternalFile(String file, Locale clueLocale) {
            List<Object> result = Collections.emptyList();
            try (InputStream in = KnowledgeDiscoveryHelper.loadFromClasspath(file);){
                if (in == null) {
                    throw new InitializationException("lexical clues file " + file + " not found on classpath");
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
                    List lexicalClues = CSVFormat.RFC4180.withHeader(new String[]{ClueManagerImpl.CLUE, ClueManagerImpl.CONCEPT_IRI, ClueManagerImpl.ONTOLOGY_IRI, ClueManagerImpl.TENANT_ID, ClueManagerImpl.USER_ID}).withSkipHeaderRecord().parse((Reader)br).getRecords();
                    LOGGER.info("There are [{}] of lexical clues in Ontology {}", (Object)lexicalClues.size(), (Object)this.ontologyIRI.getShortForm());
                    RequestContext localizedRc = this.isRequestLocale(clueLocale) ? this.ctx : new RequestContext(clueLocale, Locale.ENGLISH, false);
                    result = lexicalClues.parallelStream().filter(r -> !StringUtils.isBlank((CharSequence)r.get(ClueManagerImpl.CLUE))).map(clueRecord -> {
                        Clue clueToIndex = new Clue();
                        clueToIndex.setText(StringUtils.trim((String)clueRecord.get(ClueManagerImpl.CLUE)));
                        clueToIndex.setConceptID(clueRecord.get(ClueManagerImpl.CONCEPT_IRI));
                        clueToIndex.setOntologyID(StringUtils.isBlank((CharSequence)clueRecord.get(ClueManagerImpl.ONTOLOGY_IRI)) ? this.ontologyIRI.toString() : clueRecord.get(ClueManagerImpl.ONTOLOGY_IRI));
                        if (!StringUtils.isBlank((CharSequence)clueRecord.get(ClueManagerImpl.TENANT_ID))) {
                            clueToIndex.setTenantID(clueRecord.get(ClueManagerImpl.TENANT_ID));
                        }
                        if (!StringUtils.isBlank((CharSequence)clueRecord.get(ClueManagerImpl.USER_ID))) {
                            clueToIndex.setUserID(clueRecord.get(ClueManagerImpl.USER_ID));
                        }
                        clueToIndex.setTextTokenized(clueToIndex.getText());
                        clueToIndex.setTextLemma(clueToIndex.getText());
                        ClueManagerImpl.this.expandNlpInfo(clueToIndex, localizedRc);
                        return IRecord.create((Object)clueToIndex, (String)ClueManagerImpl.this.generateLexicalClueId(clueToIndex));
                    }).collect(Collectors.toList());
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to close input stream for " + file, (Throwable)e);
            }
            return result;
        }

        private boolean isRequestLocale(Locale clueLocale) {
            return this.ctx.locale.getLanguage().equals(clueLocale.getLanguage());
        }
    }

    private static enum SearchFields {
        TEXT("text", 2.0f),
        TEXTTOKENIZED("textTokenized", 1.5f),
        TEXTLEMMA("textLemma", 1.0f);

        private String name;
        private float boost;

        private SearchFields(String name, float boost) {
            this.name = name;
            this.boost = boost;
        }

        public String getName() {
            return this.name;
        }

        public float getBoost() {
            return this.boost;
        }
    }
}

