/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.cluemanager;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.OntoVersion;
import com.ibm.smarts.store.api.provider.IOntoVersionStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntoVersionHelper {
    static final String DEFAULT_VERSION = "0.0.1";
    static final String ONTO_STORE_ID = "ontology-resource-version";
    static final String VERSION_PROP = "build.version";
    private static final Logger LOGGER = LoggerFactory.getLogger(OntoVersionHelper.class);
    protected IStoreProvider storeProvider;
    private static final String VERSION_FILE_LOCATION = "/onto/versions/version.properties";
    private String propPath;

    protected String getPropPath() {
        return this.propPath;
    }

    public OntoVersionHelper(IStoreProvider storeProvider) {
        this(storeProvider, VERSION_FILE_LOCATION);
    }

    OntoVersionHelper(IStoreProvider storeProvider, String propPath) {
        this.storeProvider = storeProvider;
        this.propPath = propPath;
    }

    protected IStoreQuery buildVerQuery(String ontologyId, IOntoVersionStore ovs) {
        IStoreQuery sq = ovs.getQueryBuilder().addQuery("ontologyID", ontologyId).build();
        return sq;
    }

    protected OntoVersion createOntoVersion(String ontoId, String ver) {
        OntoVersion ov = new OntoVersion();
        ov.setOntologyID(ontoId);
        ov.setVersion(ver);
        return ov;
    }

    protected void deleteOntoVersion(RequestContext rtx, String ontoId) {
        StoreStatus ss = this.storeProvider.getOntoVersionStore(rtx).delete(ontoId);
        if (!ss.isSuccess()) {
            LOGGER.error("Failed to delete ontology version for ontology: {} , cause: {}", (Object)ontoId, (Object)ss.toString());
        } else {
            LOGGER.debug("Ontology version for: {}, was deleted: {}", (Object)ontoId, (Object)ss.toString());
        }
    }

    protected void storeOntoVersion(RequestContext rtx, String ontoId, String ver) {
        this.deleteOntoVersion(rtx, ontoId);
        OntoVersion ov = this.createOntoVersion(ontoId, ver);
        IRecord rec = IRecord.create((Object)ov, (String)Integer.toHexString(ontoId.hashCode()));
        StoreStatus ss = this.storeProvider.getOntoVersionStore(rtx).store(rec);
        if (!ss.isSuccess()) {
            LOGGER.error("There was an error storing the ontology version for ontology: {}, caused by: {}", (Object)ontoId, (Object)ss.toString());
        } else {
            LOGGER.debug("The ontology version: {} for ontology: {} was stored: {}", new Object[]{ver, ontoId, ss.toString()});
        }
    }

    protected String getVerFromStore(RequestContext rtx, String ontologyId) {
        IOntoVersionStore ovs = this.storeProvider.getOntoVersionStore(rtx);
        List recs = ovs.executeSearch(this.buildVerQuery(ontologyId, ovs));
        if (recs.isEmpty() || recs.size() > 1) {
            return "";
        }
        return ((OntoVersion)((IRecordResult)recs.get(0)).getRecord().getRecord()).getVersion();
    }

    protected String getVersionFromProp() {
        try {
            Properties props = KnowledgeDiscoveryHelper.loadProperties(this.getPropPath());
            return props.getProperty(VERSION_PROP);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load ontology version from properties file", (Throwable)e);
            return DEFAULT_VERSION;
        }
    }

    protected Long safeParse(String s) {
        Long i;
        try {
            i = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Could not parse part of the ontology version: {}", (Object)e.toString());
            return new Long(0L);
        }
        return i;
    }

    protected long[] splitVersion(String ver) {
        String[] split1 = ver.split("\\.");
        if (split1.length != 3) {
            LOGGER.error("The version string is not a valid format: {}", (Object)ver);
            return new long[]{0L, 0L, 1L};
        }
        long v = this.safeParse(split1[0]);
        long r = this.safeParse(split1[1]);
        long m = this.safeParse(split1[2]);
        return new long[]{v, r, m};
    }

    protected int compareVersions(String propsStr, String storedStr) {
        long[] stored;
        long[] props = this.splitVersion(propsStr);
        if (props[0] != (stored = this.splitVersion(storedStr))[0]) {
            return Long.compare(props[0], stored[0]);
        }
        if (props[1] != stored[1]) {
            return Long.compare(props[1], stored[1]);
        }
        if (props[2] != stored[2]) {
            return Long.compare(props[2], stored[2]);
        }
        return 0;
    }
}

