/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.service;

import com.ibm.smarts.core.util.ConfigUtil;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.config.KnowledgeDiscoveryProps;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.Properties;

public final class KDSFactory {
    private static KnowledgeDiscoveryService instance;
    private static volatile boolean isInitialized;

    public static synchronized KnowledgeDiscoveryService getInstance() {
        if (null == instance) {
            throw new IllegalStateException("KnowledgeDiscoveryService was not initialized.");
        }
        return instance;
    }

    public static synchronized void initializeKDS(Properties config, SmartNLP nlp, IStoreProvider storeProvider, RequestContext rc) {
        if (KnowledgeDiscoveryHelper.isAnyObjectNull(config, nlp, storeProvider, rc)) {
            throw new IllegalArgumentException("Unable to initialize KDS due to invalid input parameters!");
        }
        if (instance != null) {
            throw new IllegalStateException("KnowledgeDiscoveryService was already initialized.");
        }
        Properties props = ConfigUtil.updateProps((Properties)KnowledgeDiscoveryProps.getDefaultConfig(), (Properties)config);
        instance = new KnowledgeDiscoveryService(props, nlp, storeProvider);
        instance.initialize(rc);
        isInitialized = true;
    }

    public static void terminateKDS(RequestContext rc) {
        if (instance != null) {
            instance.shutDown(rc);
            instance = null;
            isInitialized = false;
        }
    }

    public static boolean isKDSInitialized() {
        return isInitialized;
    }

    static {
        isInitialized = false;
    }
}

