/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.tasks;

import com.ibm.smarts.common.mq.function.SmartsModulePublishUtil;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.StoreStatus;

public class InitialPublishingTaskImpl {
    public void execute(SmartsTaskContext taskContext) {
        String moduleId = taskContext.getSmartsModuleId();
        String datasetId = taskContext.getDatasetId();
        PerformanceLogger.get().info((Object)(moduleId + "." + datasetId));
        IStoreProvider storeProvider = taskContext.getStoreProvider();
        RequestContext rc = taskContext.getRequestContext();
        SmartsModule module = this.getModuleStore(storeProvider, rc).getSmartsModulePart(moduleId, datasetId);
        if (module.getDatasets().isEmpty()) {
            throw new InternalException("Unable to create SmartsModule", new Object[0]);
        }
        DatasetInfo dataset = (DatasetInfo)module.getDatasets().get(0);
        StoreStatus status = SmartsModulePublishUtil.publishSmartsModuleSkeleton((RequestContext)rc, (IStoreProvider)storeProvider, (String)moduleId, (SmartsModule)module, (DatasetInfo)dataset);
        String resourceURI = status.getResourceURI();
        if (resourceURI != null) {
            taskContext.setResourceURI(status.getResourceURI());
        }
        PerformanceLogger.get().info((Object)(moduleId + "." + datasetId));
    }

    private IInMemoryModuleStore getModuleStore(IStoreProvider storeProvider, RequestContext rc) {
        return storeProvider.getModuleStore(rc);
    }
}

