/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.tasks;

import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.dds.core.numerics.Column;
import com.ibm.smarts.dds.core.numerics.StatsAnalysis;
import com.ibm.smarts.dds.core.numerics.StatsKey;
import com.ibm.smarts.dds.core.numerics.bivariate.Bivariate;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueFactory;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredictTaskImpl {
    private final Logger LOGGER = LoggerFactory.getLogger(PredictTaskImpl.class);
    private static final double VIRTUALLY_ZERO = 1.0E-5;

    public void execute(SmartsTaskContext taskContext) {
        String smartsId = taskContext.getSmartsModuleId();
        String datasetId = taskContext.getDatasetId();
        PerformanceLogger.get().info((Object)(smartsId + "." + datasetId));
        RequestContext rc = taskContext.getRequestContext();
        IStoreProvider storeProvider = taskContext.getStoreProvider();
        String taskId = "smarts.dds.predict";
        SmartsModule smartsModule = this.getModuleStore(storeProvider, rc).getSmartsModulePart(smartsId, datasetId);
        if (smartsModule == null) {
            throw new InternalException("SmartsModule not found", new Object[0]);
        }
        DatasetInfo datasetInfo = (DatasetInfo)smartsModule.getDatasets().get(0);
        List columns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo);
        if (!columns.isEmpty()) {
            if (SmartsModuleUtil.logMissingData((String)smartsId, (String)datasetInfo.getId(), (List)columns, (String)taskId)) {
                throw new InternalException("Missing data", new Object[0]);
            }
            int columnCount = columns.size();
            ArrayList ids = new ArrayList(columnCount);
            Map<String, List<String>> columnSamples = columns.stream().collect(Collectors.toMap(BaseObject::getId, ColumnInfo::getSamples));
            StatsAnalysis stats = new StatsAnalysis(columns.stream().collect(Collectors.toMap(BaseObject::getId, ColumnInfo::getDataType)), columnSamples);
            columnSamples.forEach((id, samples) -> ids.add(id));
            ArrayList<BivariateStatistics> bivariatesList = new ArrayList<BivariateStatistics>();
            for (int i = 0; i < columnCount; ++i) {
                for (int j = 0; j < i; ++j) {
                    Bivariate bivariate = stats.getBivariateStats(i, j);
                    if (bivariate == null) continue;
                    BivariateStatistics bivariates = new BivariateStatistics();
                    bivariates.setColumn1((String)ids.get(i));
                    bivariates.setColumn2((String)ids.get(j));
                    BiConsumer<StatisticType, Double> addBivariate = (t, v) -> {
                        Statistic stat = new Statistic();
                        stat.setType(t);
                        if (this.validNonZero((Double)v)) {
                            stat.setValue((Value)ValueFactory.createDouble((Double)v));
                            bivariates.getStatistics().add(stat);
                        }
                    };
                    addBivariate.accept(StatisticType.CRAMERS_V, bivariate.cramersV());
                    if (Double.compare(bivariate.eta(), -2.0) != 0) {
                        addBivariate.accept(StatisticType.ETA, bivariate.eta());
                    }
                    if (Double.compare(bivariate.pearson(), -2.0) != 0) {
                        addBivariate.accept(StatisticType.PEARSON, bivariate.pearson());
                    }
                    if (bivariates.getStatistics() == null || bivariates.getStatistics().isEmpty()) continue;
                    bivariatesList.add(bivariates);
                }
            }
            HashMap smartsUnivariates = new HashMap();
            this.getModuleStore(storeProvider, rc).apply(smartsId, datasetId, dataset -> this.applyStatistics((DatasetInfo)dataset, stats.getColumnsByIdMap(), (List<BivariateStatistics>)bivariatesList, smartsUnivariates));
        }
        PerformanceLogger.get().info((Object)(smartsId + "." + datasetId));
    }

    private IInMemoryModuleStore getModuleStore(IStoreProvider storeProvider, RequestContext rc) {
        return storeProvider.getModuleStore(rc);
    }

    private boolean validNonZero(Double d) {
        return d != null && !Double.isNaN(d) && Math.abs(d) > 1.0E-5;
    }

    public DatasetInfo applyStatistics(DatasetInfo dataset, Map<String, Column> columnInfoAndUnivariates, List<BivariateStatistics> bivariates, Map<String, List<Statistic>> smartsUnivariates) {
        dataset.getBivariateStatistics().addAll(bivariates);
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataset).forEach(column -> {
            Column col = (Column)columnInfoAndUnivariates.get(column.getId());
            Map<StatsKey, Value> univStats = col.getStat();
            if (column.getDataType().isString() || column.getDataType().isBoolean()) {
                if (col.getSampleDistinctValues() != null) {
                    column.getSampleDistinctValues().addAll(col.getSampleDistinctValues());
                }
                if (col.getSampleDistinctValuesCount() != null) {
                    column.getSampleDistinctValueCounts().addAll(col.getSampleDistinctValuesCount());
                }
            }
            List sampleStatistics = column.getSampleStatistics();
            List statistics = column.getStatistics();
            BiConsumer<StatisticType, StatsKey> addUnivariate = (statType, statKey) -> {
                if (univStats.containsKey(statKey)) {
                    Statistic stat = new Statistic();
                    stat.setType(statType);
                    stat.setValue((Value)univStats.get(statKey));
                    sampleStatistics.add(stat);
                    if (this.getStatsKeys().contains(stat.getType())) {
                        statistics.add(stat);
                    }
                }
            };
            addUnivariate.accept(StatisticType.COUNT, StatsKey.valid);
            addUnivariate.accept(StatisticType.TOTAL_COUNT, StatsKey.N);
            addUnivariate.accept(StatisticType.VALID_NUMERIC, StatsKey.validNumeric);
            addUnivariate.accept(StatisticType.VALID, StatsKey.valid);
            addUnivariate.accept(StatisticType.DISTINCT_COUNT, StatsKey.unique);
            addUnivariate.accept(StatisticType.MIN_VALUE, StatsKey.min);
            addUnivariate.accept(StatisticType.MAX_VALUE, StatsKey.max);
            addUnivariate.accept(StatisticType.MEAN, StatsKey.mean);
            addUnivariate.accept(StatisticType.STDDEV, StatsKey.stddev);
            addUnivariate.accept(StatisticType.VARIANCE, StatsKey.variance);
            addUnivariate.accept(StatisticType.SKEW, StatsKey.skew);
            addUnivariate.accept(StatisticType.KURTOSIS, StatsKey.kurtosis);
            addUnivariate.accept(StatisticType.MEDIAN, StatsKey.median);
            addUnivariate.accept(StatisticType.Q_1, StatsKey.q1);
            addUnivariate.accept(StatisticType.Q_3, StatsKey.q3);
            addUnivariate.accept(StatisticType.GRANULARITY, StatsKey.granularity);
            addUnivariate.accept(StatisticType.DECIMAL_PLACES, StatsKey.decimalPlaces);
            addUnivariate.accept(StatisticType.DATE_UNIT, StatsKey.dateUnit);
            addUnivariate.accept(StatisticType.NULL_COUNT, StatsKey.nullCount);
            addUnivariate.accept(StatisticType.DENSITY, StatsKey.DENSITY);
            smartsUnivariates.put(column.getId(), sampleStatistics);
        });
        return dataset;
    }

    private List<StatisticType> getStatsKeys() {
        ArrayList<StatisticType> keys = new ArrayList<StatisticType>();
        keys.add(StatisticType.COUNT);
        keys.add(StatisticType.MIN_VALUE);
        keys.add(StatisticType.MAX_VALUE);
        keys.add(StatisticType.NULL_COUNT);
        keys.add(StatisticType.DENSITY);
        keys.add(StatisticType.DISTINCT_COUNT);
        keys.add(StatisticType.TOTAL_COUNT);
        return keys;
    }
}

