/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.internal;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.smarts.model.common.util.QuerySubjectUtil;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Hierarchy;
import com.ibm.smarts.schema.LogicalGroup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtil.class);
    private static final String DELIMITER = "__|__";
    private static final int HIERARCHY_LEVEL_LOWERBOUND = 2;

    private CommonUtil() {
    }

    public static String getUniqueId(String parentId, String itemId) {
        return parentId + DELIMITER + itemId;
    }

    public static String getUniqueId(String ... args) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            buffer.append(args[i]);
            if (i == args.length - 1) continue;
            buffer.append(DELIMITER);
        }
        return buffer.toString();
    }

    public static Map<String, QueryItem> getVisibleQueryItems(QuerySubject qs, String qsId) {
        HashMap<String, QueryItem> results = new HashMap<String, QueryItem>();
        CommonUtil.populateVisibleQueryItems(results, qsId, qs.getItem(), false);
        return results;
    }

    public static void populateVisibleQueryItems(Map<String, QueryItem> result, String parentIdPath, List<ItemType> items, boolean includeRowId) {
        for (ItemType item : items) {
            if (item.getQueryItem() != null) {
                QueryItem qi = item.getQueryItem();
                if (!QuerySubjectUtil.isVisible((BaseQueryItemType)qi, (boolean)includeRowId)) continue;
                String id = CommonUtil.getUniqueId(parentIdPath, qi.getIdentifier());
                result.put(id, qi);
                CommonUtil.populateVisibleQueryItems(result, id, qi.getItem(), includeRowId);
                continue;
            }
            if (item.getFolder() == null) continue;
            CommonUtil.populateVisibleQueryItems(result, parentIdPath, item.getFolder().getItem(), includeRowId);
        }
    }

    public static void cleanupBivariates(DatasetInfo ds, String columnId) {
        List bivariates = ds.getBivariateStatistics();
        ListIterator itr = bivariates.listIterator();
        while (itr.hasNext()) {
            BivariateStatistics bi = (BivariateStatistics)itr.next();
            if (!bi.getColumn1().equals(columnId) && !bi.getColumn2().equals(columnId)) continue;
            itr.remove();
        }
    }

    public static void cleanupLogicalGroups(DatasetInfo ds, String columnId) {
        List logicalGroups = ds.getLogicalGroups();
        HashSet<String> logicalGroupsDeleted = new HashSet<String>();
        ListIterator logicalGroupListIterator = logicalGroups.listIterator();
        while (logicalGroupListIterator.hasNext()) {
            LogicalGroup logicalGroup = (LogicalGroup)logicalGroupListIterator.next();
            ListIterator logicalGroupMemberListIterator = logicalGroup.getMember().listIterator();
            while (logicalGroupMemberListIterator.hasNext()) {
                LogicalGroup.Member member = (LogicalGroup.Member)logicalGroupMemberListIterator.next();
                if (!member.getColumnId().equals(columnId)) continue;
                logicalGroupMemberListIterator.remove();
                break;
            }
            if (!logicalGroup.getMember().isEmpty()) continue;
            logicalGroupsDeleted.add(logicalGroup.getId());
            logicalGroupListIterator.remove();
        }
        if (!logicalGroupsDeleted.isEmpty()) {
            CommonUtil.onDeleteLogicalGroups(ds, logicalGroupsDeleted);
        }
    }

    private static void onDeleteLogicalGroups(DatasetInfo ds, Set<String> logicalGroupsDeleted) {
        ListIterator itr = ds.getHierarchies().listIterator();
        while (itr.hasNext()) {
            Hierarchy hier = (Hierarchy)itr.next();
            if (!CommonUtil.canDeleteHierarchy(hier, logicalGroupsDeleted)) continue;
            itr.remove();
        }
    }

    private static boolean canDeleteHierarchy(Hierarchy hier, Set<String> logicalGroupsDeleted) {
        ListIterator hierarchyLevelListIterator = hier.getLevel().listIterator();
        while (hierarchyLevelListIterator.hasNext()) {
            Hierarchy.Level level = (Hierarchy.Level)hierarchyLevelListIterator.next();
            if (!logicalGroupsDeleted.contains(level.getGroupId())) continue;
            hierarchyLevelListIterator.remove();
        }
        if (hier.getLevel().size() < 2) {
            return true;
        }
        int i = 1;
        for (Hierarchy.Level level : hier.getLevel()) {
            level.setLevelNo(String.valueOf(i++));
        }
        return false;
    }
}

