/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.common.util;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityEnum;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.SourceCategoryType;
import com.ibm.bi.platform.moser.common.generated.metadata.TaxonomyType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.smarts.model.common.util.ModuleDataTypeUtil;
import com.ibm.smarts.model.common.util.ModuleUtil;
import com.ibm.smarts.model.common.util.TaxonomyTypeWrapper;
import com.ibm.smarts.model.common.util.TaxonomyUtil;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.stats.StatisticsFactory;
import com.ibm.smarts.model.value.decor.SubItemDecoration;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.DatasetType;
import com.ibm.smarts.schema.ItemType;
import com.ibm.smarts.schema.ObjectFactory;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.schema.util.SmartsModuleFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SmartsModuleBuilder {
    private final ObjectFactory mFactory = new ObjectFactory();
    private boolean analyzeSmartsFieldsForShallowBuilder = false;

    public SmartsModuleBuilder() {
        this.analyzeSmartsFieldsForShallowBuilder = false;
    }

    public SmartsModuleBuilder(boolean isShallowBuilder) {
        this.analyzeSmartsFieldsForShallowBuilder = isShallowBuilder;
    }

    public SmartsModule buildFromModule(String smartsId, Module module, Set<String> excludedTables) {
        return this.buildFromModule(smartsId, module, excludedTables, true);
    }

    public SmartsModule buildIntermediateSmartsModuleFromModule(String smartsId, Module module, Set<String> excludedTables) {
        return this.buildFromModule(smartsId, module, excludedTables, true);
    }

    public boolean finalizeIntermediateSmartsModule(SmartsModule intermediateSmartsModule) {
        Optional<Object> calculations = Optional.empty();
        Optional<Object> namedSets = Optional.empty();
        Iterator it = intermediateSmartsModule.getDatasets().iterator();
        while (it.hasNext()) {
            DatasetInfo ds = (DatasetInfo)it.next();
            if (ds.getType().equals((Object)DatasetType.CALCULATIONS)) {
                calculations = Optional.of(ds);
                it.remove();
            } else if (ds.getType().equals((Object)DatasetType.NAMED_SETS)) {
                namedSets = Optional.of(ds);
                it.remove();
            }
            if (!calculations.isPresent() || !namedSets.isPresent()) continue;
            break;
        }
        if (calculations.isPresent()) {
            intermediateSmartsModule.setCalculations((DatasetInfo)calculations.get());
        }
        if (namedSets.isPresent()) {
            intermediateSmartsModule.setNamedSets((DatasetInfo)namedSets.get());
        }
        return calculations.isPresent() || namedSets.isPresent();
    }

    private SmartsModule buildFromModule(String smartsId, Module module, Set<String> excludedTables, boolean consolidateDatasets) {
        DatasetInfo namedSets;
        Map<String, Map<String, String>> columnKeyTypeMap = this.getColumnKeyTypeMap(module);
        SmartsModule container = SmartsModuleFactory.createSmartsModule();
        container.setId(smartsId);
        if (ModuleUtil.isFMPackageModule(module)) {
            container.setType("package");
        }
        if (module.getLabel() != null) {
            container.setName(module.getLabel());
        }
        if (module.getDescription() != null) {
            container.setDescription(module.getDescription());
        }
        if (module.getComment() != null) {
            container.setComment(module.getComment());
        }
        List datasets = container.getDatasets();
        module.getQuerySubject().forEach(qs -> {
            if (SmartsModuleBuilder.isQuerySubjectVisible(module, qs) && (excludedTables == null || !excludedTables.contains(qs.getIdentifier()))) {
                Map keyTypeMap = columnKeyTypeMap.containsKey(qs.getIdentifier()) ? (Map)columnKeyTypeMap.get(qs.getIdentifier()) : Collections.emptyMap();
                datasets.add(this.createDatasetInfo((QuerySubject)qs, keyTypeMap));
            }
        });
        DatasetInfo calculations = module.basicGetCalculation() != null && !module.basicGetCalculation().isEmpty() ? this.createDatasetInfo("_global_calculations", DatasetType.CALCULATIONS, module.getCalculation()) : null;
        this.addNamedSets(module);
        DatasetInfo datasetInfo = namedSets = module.basicGetNamedSet() != null && !module.basicGetNamedSet().isEmpty() ? this.createDatasetInfo("_global_namedSets", DatasetType.NAMED_SETS, module.getNamedSet()) : null;
        if (consolidateDatasets) {
            if (calculations != null) {
                datasets.add(calculations);
            }
            if (namedSets != null) {
                datasets.add(namedSets);
            }
        } else {
            container.setCalculations(calculations);
            container.setNamedSets(namedSets);
        }
        return container;
    }

    public DatasetInfo createDatasetInfo(QuerySubject querySubject, Map<String, String> keyTypeMap) {
        DatasetInfo dataset = this.mFactory.createDatasetInfo();
        this.setBaseObjectProperty((BaseObject)dataset, (ObjectType)querySubject);
        dataset.setType(DatasetType.DATASETS);
        dataset.setSourceCategory(this.createSourceCategoryType(querySubject.getSourceCategory()));
        dataset.getItem().addAll(this.createItems(querySubject.getItem(), keyTypeMap));
        return dataset;
    }

    public DatasetInfo createDatasetInfo(String qualifiedId, DatasetType type, List<? extends BaseQueryItemType> calculations) {
        DatasetInfo dataset = this.mFactory.createDatasetInfo();
        dataset.setId(qualifiedId);
        dataset.setName(qualifiedId);
        dataset.setType(type);
        calculations.forEach(c -> {
            ItemType item = this.mFactory.createItemType();
            item.setColumn(this.createColumnInfo((BaseQueryItemType)c, Collections.emptyMap()));
            dataset.getItem().add(item);
        });
        return dataset;
    }

    public ItemType.Folder createFolder(ItemType.Folder folder, Map<String, String> keyTypeMap) {
        ItemType.Folder result = this.mFactory.createItemTypeFolder();
        this.setBaseObjectProperty((BaseObject)result, (ObjectType)folder);
        result.getItem().addAll(this.createItems(folder.getItem(), keyTypeMap));
        return result;
    }

    public ColumnInfo createColumnInfo(BaseQueryItemType queryItem, Map<String, String> keyTypeMap) {
        ColumnInfo column = this.mFactory.createColumnInfo();
        this.setBaseObjectProperty((BaseObject)column, (ObjectType)queryItem);
        column.setSourceCategory(this.createSourceCategoryType(queryItem.getSourceCategory()));
        if (queryItem.getDatatype() != null) {
            column.setDataType(ModuleDataTypeUtil.createDataType(queryItem.getDatatype()));
        } else {
            column.setDataType((DataType)DataTypes.getUnknownType());
        }
        boolean nullable = queryItem.isNullable() == null ? false : queryItem.isNullable();
        column.getStatistics().add(StatisticsFactory.createNullable((boolean)nullable));
        column.setKeyType(keyTypeMap == null ? null : (String)keyTypeMap.getOrDefault(column.getId(), null));
        column.setExpression(queryItem.getExpression());
        column.getItem().addAll(this.createItems(queryItem.getItem(), keyTypeMap));
        if (this.hasQueryItemParent(queryItem)) {
            column.getValueDecorations().add(new SubItemDecoration());
        }
        if (this.analyzeSmartsFieldsForShallowBuilder) {
            if (column.getSemanticInfo() == null) {
                column.setSemanticInfo(new SemanticInfo());
            }
            column.setDefaultAggregation(SmartsModuleBuilder.reMapAggregation(queryItem.getRegularAggregate()));
            column.setUsage(SmartsModuleBuilder.reMapUsageType(queryItem.getUsage()));
            SmartsModuleBuilder.reMapTaxonomyToConcepts((List<TaxonomyType>)queryItem.getTaxonomy(), column);
        }
        return column;
    }

    private boolean hasQueryItemParent(BaseQueryItemType queryItem) {
        MoserObject parentOfItem;
        boolean hasQueryItemParent = false;
        MoserObject parentItem = queryItem.getParent();
        if (parentItem != null && parentItem instanceof com.ibm.bi.platform.moser.common.generated.metadata.ItemType && (parentOfItem = ((com.ibm.bi.platform.moser.common.generated.metadata.ItemType)parentItem).getParent()) != null && parentOfItem instanceof QueryItem) {
            hasQueryItemParent = true;
        }
        return hasQueryItemParent;
    }

    public static com.ibm.smarts.schema.UsageType reMapUsageType(UsageType usageType) {
        if (usageType == null) {
            return null;
        }
        try {
            String str = JAXBHelper.marshalToJSON((Object)usageType);
            return (com.ibm.smarts.schema.UsageType)JAXBHelper.unmarshalFromJSON(com.ibm.smarts.schema.UsageType.class, (String)str);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void reMapTaxonomyToConcepts(List<TaxonomyType> taxonomyTypes, ColumnInfo columnInfo) {
        SmartsModuleBuilder.reMapTaxonomyToConcepts(taxonomyTypes, columnInfo.getSemanticInfo().getConcepts());
    }

    public static void reMapTaxonomyToConcepts(List<TaxonomyType> taxonomyTypes, List<ConceptInfo> existingConceptList) {
        List taxonomyIds = taxonomyTypes.stream().map(TaxonomyUtil::getConcept).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        for (String newConcept : taxonomyIds) {
            TaxonomyTypeWrapper tax = TaxonomyUtil.getTaxonomyType(newConcept);
            if (tax.getClazz().equals("cGeoLocation") || tax.getClazz().equals("cTime")) {
                SmartsModuleBuilder.addNestedConcept(existingConceptList, newConcept);
                continue;
            }
            if (!tax.getClazz().equals("cNone")) continue;
            existingConceptList.add(SmartsModuleBuilder.createOWLNothingConcept());
        }
    }

    public static ConceptInfo addNestedConcept(List<ConceptInfo> conceptList, String conceptName) {
        ConceptInfo conceptInfo = SmartsModuleBuilder.findExistingConceptOrCreateNew(conceptList, conceptName);
        conceptInfo.setConfidence(1.0f);
        conceptList.add(conceptInfo);
        return conceptInfo;
    }

    private static ConceptInfo findExistingConceptOrCreateNew(List<ConceptInfo> conceptList, String conceptName) {
        for (ConceptInfo concept : conceptList) {
            if (!ConceptsUtil.getConceptName((ConceptInfo)concept).equals(conceptName) || !ConceptsUtil.getOntologyId((ConceptInfo)concept).equals("http://www.ibm.com/ontologies/waca/domain/common")) continue;
            return concept;
        }
        return SmartsModuleBuilder.createDomainCommonConcept(conceptName);
    }

    public static ConceptInfo createDomainCommonConcept(String conceptName) {
        ConceptInfo conceptInfo = new ConceptInfo();
        conceptInfo.setConceptID(SmartsModuleBuilder.makeConceptId(conceptName));
        conceptInfo.setConfidence(1.0f);
        return conceptInfo;
    }

    public static ConceptInfo createOWLNothingConcept() {
        ConceptInfo conceptInfo = new ConceptInfo();
        conceptInfo.setConceptID("owl:Nothing");
        return conceptInfo;
    }

    private static String makeConceptId(String conceptName) {
        StringBuilder strBuilder = new StringBuilder("http://www.ibm.com/ontologies/waca/domain/common");
        strBuilder.append("#");
        strBuilder.append(conceptName);
        return strBuilder.toString();
    }

    public static AggregationType reMapAggregation(RegularAggregateType regularAggregateType) {
        AggregationType smartsAggregationType = AggregationType.NONE;
        if (regularAggregateType == null) {
            return smartsAggregationType;
        }
        switch (regularAggregateType) {
            case AVERAGE: {
                smartsAggregationType = AggregationType.AVERAGE;
                break;
            }
            case COUNT_DISTINCT: {
                smartsAggregationType = AggregationType.COUNT_DISTINCT;
                break;
            }
            case COUNT: {
                smartsAggregationType = AggregationType.COUNT;
                break;
            }
            case TOTAL: {
                smartsAggregationType = AggregationType.SUM;
                break;
            }
            case MAXIMUM: {
                smartsAggregationType = AggregationType.MAXIMUM;
                break;
            }
            case MINIMUM: {
                smartsAggregationType = AggregationType.MINIMUM;
                break;
            }
            default: {
                smartsAggregationType = AggregationType.NONE;
            }
        }
        return smartsAggregationType;
    }

    private List<ItemType> createItems(List<com.ibm.bi.platform.moser.common.generated.metadata.ItemType> items, Map<String, String> keyTypeMap) {
        ArrayList<ItemType> results = new ArrayList<ItemType>();
        items.stream().forEach(i -> {
            if (i.getQueryItem() != null || i.getNamedSet() != null || i.getFolder() != null) {
                ItemType item = null;
                if (i.getQueryItem() != null && !this.isHidden((ObjectType)i.getQueryItem())) {
                    item = this.mFactory.createItemType();
                    item.setColumn(this.createColumnInfo((BaseQueryItemType)i.getQueryItem(), keyTypeMap));
                } else if (i.getNamedSet() != null && !this.isHidden((ObjectType)i.getNamedSet())) {
                    item = this.mFactory.createItemType();
                    item.setColumn(this.createColumnInfo((BaseQueryItemType)i.getNamedSet(), keyTypeMap));
                } else if (i.getFolder() != null && !this.isHidden((ObjectType)i.getFolder())) {
                    item = this.mFactory.createItemType();
                    item.setFolder(this.createFolder(i.getFolder(), keyTypeMap));
                }
                if (item != null) {
                    results.add(item);
                }
            }
        });
        return results;
    }

    public boolean isHidden(ObjectType qi) {
        return qi.isHidden() != null && qi.isHidden() != false;
    }

    public static boolean isQuerySubjectVisible(Module module, QuerySubject qs) {
        Boolean hidden = qs.isHidden();
        if (hidden != null && hidden.booleanValue()) {
            return false;
        }
        List folderList = module.getMetadataTreeView();
        return !SmartsModuleBuilder.isInHiddenFolder(folderList, qs.getIdentifier());
    }

    private static boolean isInHiddenFolder(List<FolderType> folderList, String qsId) {
        HashMap<String, FolderType> folderParentMap = new HashMap<String, FolderType>();
        boolean isHidden = false;
        block0: for (FolderType folder : folderList) {
            FolderType containedFolder = SmartsModuleBuilder.findInFolder(folder, folderParentMap, qsId);
            if (containedFolder == null) continue;
            FolderType currentFolder = containedFolder;
            while (currentFolder != null) {
                Boolean hiddenFlag = currentFolder.isHidden();
                if (hiddenFlag != null && hiddenFlag.booleanValue()) {
                    isHidden = true;
                    continue block0;
                }
                currentFolder = (FolderType)folderParentMap.get(currentFolder.getIdentifier());
            }
        }
        return isHidden;
    }

    private static FolderType findInFolder(FolderType folder, Map<String, FolderType> folderParentMap, String qsId) {
        FolderType containingFolder = null;
        List folderItems = folder.getFolderItem();
        for (FolderItemType folderItem : folderItems) {
            FolderType cFolder;
            FolderType aFolder = folderItem.getFolder();
            if (folderItem.getRef() != null && folderItem.getRef().equals(qsId) || folderItem.getDefLink() != null && folderItem.getDefLink().getRef().equals(qsId)) {
                containingFolder = folder;
                break;
            }
            if (aFolder == null) continue;
            if (aFolder.getIdentifier() != null) {
                folderParentMap.put(aFolder.getIdentifier(), folder);
            }
            if ((cFolder = SmartsModuleBuilder.findInFolder(aFolder, folderParentMap, qsId)) == null) continue;
            containingFolder = cFolder;
        }
        return containingFolder;
    }

    private void setBaseObjectProperty(BaseObject target, ObjectType source) {
        target.setId(source.getIdentifier());
        target.setIdForExpression(source.getIdForExpression());
        target.setName(source.getLabel());
        target.setDescription(source.getDescription());
        target.setComment(source.getComment());
    }

    private com.ibm.smarts.schema.SourceCategoryType createSourceCategoryType(SourceCategoryType type) {
        return type != null ? com.ibm.smarts.schema.SourceCategoryType.fromValue((String)type.value()) : null;
    }

    public Map<String, Map<String, String>> getColumnKeyTypeMap(Module module) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        module.getQuerySubject().forEach(qs -> {
            if (qs.getItemNormalization() != null) {
                Map v = map.computeIfAbsent(qs.getIdentifier(), k -> new HashMap());
                qs.getItemNormalization().getItemNormalizationGroup().forEach(g -> {
                    if (g.getKey() != null) {
                        v.put(g.getKey().getItemRef(), "PK");
                    }
                });
            }
        });
        module.getRelationship().forEach(r -> r.getLink().forEach(l -> {
            this.processLink(map, r.getLeft(), l.getLeftRef());
            this.processLink(map, r.getRight(), l.getRightRef());
        }));
        return map;
    }

    private void processLink(Map<String, Map<String, String>> map, CardinalityType card, String columnId) {
        String keyType = this.getKeyType(card);
        map.compute(card.getRef(), (k, v) -> {
            if (v == null) {
                HashMap<String, String> columnMap = new HashMap<String, String>();
                columnMap.put(columnId, keyType);
                return columnMap;
            }
            v.compute(columnId, (k1, v1) -> v1 == null || v1.equals("FK") ? keyType : v1);
            return v;
        });
    }

    private String getKeyType(CardinalityType card) {
        if (card.getMaxcard().equals((Object)CardinalityEnum.ONE) && card.getMincard().equals((Object)CardinalityEnum.ONE)) {
            return "PK";
        }
        return "FK";
    }

    private void addNamedSets(Module module) {
        ArrayList<NamedSet> namedSets = new ArrayList<NamedSet>();
        List querySubjects = module.getQuerySubject();
        for (QuerySubject qs : querySubjects) {
            this.addNamedSets(qs.getItem(), namedSets);
        }
        if (!namedSets.isEmpty()) {
            module.getNamedSet().addAll(namedSets);
        }
    }

    private void addNamedSets(List<com.ibm.bi.platform.moser.common.generated.metadata.ItemType> itemTypes, List<NamedSet> namedSets) {
        if (itemTypes != null) {
            for (com.ibm.bi.platform.moser.common.generated.metadata.ItemType itemType : itemTypes) {
                QueryItem qi;
                NamedSet ns = itemType.getNamedSet();
                if (ns != null) {
                    namedSets.add(ns);
                }
                if ((qi = itemType.getQueryItem()) == null) continue;
                this.addNamedSets(qi.getItem(), namedSets);
            }
        }
    }
}

