/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dashboard.generator.schema.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.dashboard.generator.schema.core.ContentGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Container {
    private final String label;
    private final String description;
    private final List<ContentGroup> groups = new ArrayList<ContentGroup>();
    private final boolean predictive;

    public Container(List<ContentGroup> groups, boolean isPredictive) {
        this.label = null;
        this.description = null;
        this.groups.addAll(groups);
        this.predictive = isPredictive;
    }

    @JsonCreator
    public Container(@JsonProperty(value="label") String label, @JsonProperty(value="description") String description, @JsonProperty(value="groups") List<ContentGroup> groups, @JsonProperty(value="predictive") boolean isPredictive) {
        this.label = label;
        this.description = description;
        this.groups.addAll(groups);
        this.predictive = isPredictive;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ContentGroup> getGroups() {
        return this.groups;
    }

    public boolean getPredictive() {
        return this.predictive;
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container container = (Container)o;
        return Objects.equals(this.getLabel(), container.getLabel()) && Objects.equals(this.getDescription(), container.getDescription()) && Objects.equals(this.getGroups(), container.getGroups()) && Objects.equals(this.predictive, container.getPredictive());
    }

    public int hashCode() {
        return Objects.hash(this.getLabel(), this.getDescription(), this.getGroups(), this.getPredictive());
    }

    public String toString() {
        return "Container{label='" + this.label + '\'' + ", description='" + this.description + '\'' + ", groups=" + this.groups + ", predictive=" + this.predictive + '}';
    }
}

