/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dashboard.generator.schema.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.dashboard.generator.schema.core.ChartContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ContentGroup {
    private final String label;
    private final String description;
    private final List<ChartContent> contents = new ArrayList<ChartContent>();

    public ContentGroup() {
        this.label = null;
        this.description = null;
    }

    public ContentGroup(List<ChartContent> contents) {
        this.label = null;
        this.description = null;
        this.contents.addAll(contents);
    }

    @JsonCreator
    public ContentGroup(@JsonProperty(value="label") String label, @JsonProperty(value="description") String description, @JsonProperty(value="contents") List<ChartContent> contents) {
        this.label = label;
        this.description = description;
        this.contents.addAll(contents);
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ChartContent> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    public void addContents(List<ChartContent> contents) {
        this.contents.addAll(contents);
    }

    public void addContent(ChartContent content) {
        this.contents.add(content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentGroup)) {
            return false;
        }
        ContentGroup that = (ContentGroup)o;
        return Objects.equals(this.getLabel(), that.getLabel()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getContents(), that.getContents());
    }

    public int hashCode() {
        return Objects.hash(this.getLabel(), this.getDescription(), this.getContents());
    }

    public String toString() {
        return super.toString();
    }
}

