/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.core.util;

import com.ibm.smarts.model.builder.QGEncodedSamples;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionGeneratorCoreUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionGeneratorCoreUtil.class);
    private static final int MAX_NO_OF_SAMPLES = 3;

    private QuestionGeneratorCoreUtil() {
    }

    public static List<QGEncodedSamples> encodeSamples(DatasetInfo dataSetInfo) {
        long startTime = System.currentTimeMillis();
        ArrayList<QGEncodedSamples> results = new ArrayList<QGEncodedSamples>();
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataSetInfo).forEach(col -> {
            List<String> samples;
            if (QuestionGeneratorCoreUtil.isEncodable(col) && !(samples = QuestionGeneratorCoreUtil.getCleanDistinctSamples(col, 3)).isEmpty()) {
                QGEncodedSamples qgEncodedSamples = new QGEncodedSamples(col.getIdForExpression(), dataSetInfo.getId(), samples);
                results.add(qgEncodedSamples);
            }
        });
        LOGGER.debug("Encoded QGSamples for the DataSet [{}] in {}ms. Number of encoded columns={}", new Object[]{dataSetInfo.getId(), System.currentTimeMillis() - startTime, results.size()});
        return results;
    }

    private static List<String> getCleanDistinctSamples(ColumnInfo columnInfo, int maxSamples) {
        return columnInfo.getSampleDistinctValues().stream().filter(Objects::nonNull).filter(s -> !StringUtils.isBlank((CharSequence)s)).limit(maxSamples).collect(Collectors.toList());
    }

    public static boolean isEncodable(ColumnInfo columnInfo) {
        return columnInfo.getUsage() != UsageType.FACT;
    }
}

