/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.prescriptive.recommender.ml;

import com.ibm.smarts.db.query.util.RectangleOfData;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueStatus;
import com.ibm.smarts.prescriptive.recommender.ml.ColStatistics;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class DataExtractor {
    private double[][] x;
    private double[][] y;
    private static final double EPSILON = 1.0E-10;
    private List<ColStatistics> colStatistics = new LinkedList<ColStatistics>();

    public DataExtractor(RectangleOfData rectangleOfData, int tragetColumnIndex, List<Integer> featureColumnsIndexes) {
        this.extractTrainingData(rectangleOfData, tragetColumnIndex, featureColumnsIndexes);
        this.extractStatsFromData(rectangleOfData, tragetColumnIndex, featureColumnsIndexes);
        this.normalizeData();
    }

    private void normalizeData() {
        int rowNo = this.x[0].length;
        int colNo = this.x.length;
        for (int r = 0; r < rowNo; ++r) {
            this.y[0][r] = this.normalize(this.y[0][r], 0);
        }
        for (int c = 0; c < colNo; ++c) {
            for (int r = 0; r < rowNo; ++r) {
                this.x[c][r] = this.normalize(this.x[c][r], c + 1);
            }
        }
    }

    private void extractStatsFromData(RectangleOfData rectangleOfData, int tragetColumnIndex, List<Integer> featureColumnsIndexes) {
        int rowNo = this.x[0].length;
        double[] col = new double[rowNo];
        for (int r = 0; r < rowNo; ++r) {
            col[r] = this.y[0][r];
        }
        this.colStatistics.add(this.extractStatsFromColData(tragetColumnIndex, col));
        int c = 0;
        for (int i : featureColumnsIndexes) {
            for (int r = 0; r < rowNo; ++r) {
                col[r] = this.x[c][r];
            }
            ++c;
            this.colStatistics.add(this.extractStatsFromColData(i, col));
        }
    }

    private void extractTrainingData(RectangleOfData rectangleOfData, int tragetColumnId, List<Integer> featureColumnsIndexes) {
        List rows = rectangleOfData.getValues();
        ArrayList<Integer> completeRowsIndexes = new ArrayList<Integer>();
        int rowNumber = -1;
        for (List row : rows) {
            ++rowNumber;
            boolean append = true;
            Value v = (Value)row.get(tragetColumnId);
            if (v.getStatus() != ValueStatus.OK) continue;
            for (int id : featureColumnsIndexes) {
                v = (Value)row.get(id);
                if (v.getStatus() == ValueStatus.OK) continue;
                append = false;
                break;
            }
            if (!append) continue;
            completeRowsIndexes.add(rowNumber);
        }
        this.updateXandY(completeRowsIndexes, rectangleOfData, tragetColumnId, featureColumnsIndexes);
    }

    private void updateXandY(List<Integer> completeRowsIndexes, RectangleOfData rectangleOfData, int tragetColumnId, List<Integer> featureColumnsIndexes) {
        if (!completeRowsIndexes.isEmpty()) {
            this.x = new double[featureColumnsIndexes.size()][completeRowsIndexes.size()];
            this.y = new double[1][completeRowsIndexes.size()];
            List rows = rectangleOfData.getValues();
            for (int r : completeRowsIndexes) {
                List row = (List)rows.get(r);
                int c = 0;
                for (int id : featureColumnsIndexes) {
                    this.x[c++][r] = ((Value)row.get(id)).doubleValue();
                }
                this.y[0][r] = ((Value)row.get(tragetColumnId)).doubleValue();
            }
        }
    }

    public double normalize(double value, int colIndex) {
        return (value - this.colStatistics.get(colIndex).getMean()) / (this.colStatistics.get(colIndex).getStandardDeviation() + 1.0E-10);
    }

    public double denormalize(double value, int colIndex) {
        return value * this.colStatistics.get(colIndex).getStandardDeviation() + this.colStatistics.get(colIndex).getMean();
    }

    private ColStatistics extractStatsFromColData(int tragetColumnId, double[] col) {
        DescriptiveStatistics statistics = new DescriptiveStatistics(col);
        return new ColStatistics(tragetColumnId, statistics.getMin(), statistics.getMax(), statistics.getMean(), statistics.getStandardDeviation());
    }

    public double[][] getX() {
        return this.x;
    }

    public double[][] getY() {
        return this.y;
    }

    public List<ColStatistics> getColStatistics() {
        return this.colStatistics;
    }
}

